/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.action.AbstractHandlerDelegatingProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.impl.PopulateSignatureSigningParametersHandler;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateSignatureSigningParameters
extends AbstractHandlerDelegatingProfileAction<PopulateSignatureSigningParametersHandler> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSignatureSigningParameters.class);
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SecurityParametersContext.class, true), (Function)new OutboundMessageContextLookup());
    @Nullable
    private Function<ProfileRequestContext, SecurityParametersContext> existingParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<SignatureSigningConfiguration>> configurationLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLMetadataContext.class), (Function)Functions.compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class), (Function)new OutboundMessageContextLookup()));
    @NonnullAfterInit
    private SignatureSigningParametersResolver resolver;
    private boolean noResultIsError;

    public PopulateSignatureSigningParameters() {
        super(PopulateSignatureSigningParametersHandler.class, (ContextDataLookupFunction<ProfileRequestContext, MessageContext>)new OutboundMessageContextLookup());
        this.setErrorEvent("InvalidSecurityConfiguration");
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setExistingParametersContextLookupStrategy(@Nullable Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.existingParametersContextLookupStrategy = strategy;
    }

    public void setMetadataContextLookupStrategy(@Nullable Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataContextLookupStrategy = strategy;
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<SignatureSigningConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SignatureSigningConfiguration lookup strategy cannot be null");
    }

    public void setSignatureSigningParametersResolver(@Nonnull SignatureSigningParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (SignatureSigningParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"SignatureSigningParametersResolver cannot be null");
    }

    public void setNoResultIsError(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.noResultIsError = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureSigningParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<ProfileRequestContext, List<SignatureSigningConfiguration>>(){

                public List<SignatureSigningConfiguration> apply(ProfileRequestContext input) {
                    return Collections.singletonList(SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration());
                }
            };
        }
        PopulateSignatureSigningParametersHandler delegate = (PopulateSignatureSigningParametersHandler)((Object)this.getDelegate());
        delegate.setNoResultIsError(this.noResultIsError);
        delegate.setSignatureSigningParametersResolver(this.resolver);
        delegate.setConfigurationLookupStrategy(this.adapt(this.configurationLookupStrategy));
        delegate.setSecurityParametersContextLookupStrategy(this.adapt(this.securityParametersContextLookupStrategy));
        delegate.setExistingParametersContextLookupStrategy(this.adapt(this.existingParametersContextLookupStrategy));
        delegate.setMetadataContextLookupStrategy(this.adapt(this.metadataContextLookupStrategy));
        delegate.initialize();
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (super.doPreExecute(profileRequestContext)) {
            this.log.debug("{} Signing enabled", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} Signing not enabled", (Object)this.getLogPrefix());
        return false;
    }
}

