/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.slo;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.slo.SLOMessageContextUtils;
import com.ibm.ws.security.saml.sso20.slo.SLOPostLogoutPageBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SLOPostLogoutHandler {
    private static TraceComponent tc = Tr.register(SLOPostLogoutHandler.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    public static final String PARAM_LOGOUT_STATUS = "logout_status";
    private HttpServletRequest request = null;
    private SsoConfig config = null;
    private BasicMessageContext<?, ?> messageContext = null;
    private SLOMessageContextUtils msgContextUtils = null;
    static final long serialVersionUID = 3487764489169423141L;

    public SLOPostLogoutHandler(HttpServletRequest request, SsoConfig config, BasicMessageContext<?, ?> msgCtx) {
        this.request = request;
        this.config = config;
        this.messageContext = msgCtx;
        this.msgContextUtils = new SLOMessageContextUtils(this.messageContext);
    }

    public void sendToPostLogoutPage(HttpServletResponse response) throws IOException {
        if (this.isValidPostLogoutRedirectUrlConfigured()) {
            this.redirectToCustomPostLogoutPage(response);
        } else {
            this.generateDefaultPostLogoutPage(response);
        }
    }

    boolean isValidPostLogoutRedirectUrlConfigured() {
        String postLogoutUrl = this.getAndValidatePostLogoutRedirectUrl();
        return postLogoutUrl != null;
    }

    void redirectToCustomPostLogoutPage(HttpServletResponse response) throws IOException {
        String postLogoutUrl = this.getAndValidatePostLogoutRedirectUrl();
        if (postLogoutUrl == null) {
            Tr.debug((TraceComponent)tc, (String)"Somehow the redirect URL [{0}] is no longer valid, so will redirect to default post logout page", (Object[])new Object[]{postLogoutUrl});
            this.generateDefaultPostLogoutPage(response);
            return;
        }
        response.sendRedirect(postLogoutUrl + "?" + this.getCustomPostLogoutQueryString());
    }

    String getCustomPostLogoutQueryString() {
        String query = "logout_status=";
        try {
            String statusCode = this.getStatusCodeForQueryString();
            query = query + URLEncoder.encode(statusCode, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.sso20.slo.SLOPostLogoutHandler", (String)"77", (Object)this, (Object[])new Object[0]);
        }
        return query;
    }

    String getStatusCodeForQueryString() {
        String statusCode = this.msgContextUtils.getSloStatusCode();
        if (statusCode == null || statusCode.isEmpty()) {
            statusCode = "UNKNOWN";
        }
        return statusCode;
    }

    String getAndValidatePostLogoutRedirectUrl() {
        String postLogoutUrl = this.config.getPostLogoutRedirectUrl();
        if (postLogoutUrl != null) {
            if (WebUtils.validateUriFormat((String)postLogoutUrl, (String)"[a-zA-Z0-9._~%!$&'()*+,;=:@/-]+")) {
                return postLogoutUrl;
            }
            Tr.error((TraceComponent)tc, (String)"SAML20_POST_LOGOUT_URL_NOT_VALID", (Object[])new Object[]{postLogoutUrl, "postLogoutRedirectUrl", this.config.getProviderId()});
        }
        postLogoutUrl = null;
        String formLogoutExitPage = this.messageContext.getCachedRequestInfo().getFormLogoutExitPage();
        if (formLogoutExitPage != null) {
            postLogoutUrl = formLogoutExitPage;
        }
        return postLogoutUrl;
    }

    void generateDefaultPostLogoutPage(HttpServletResponse response) throws IOException {
        SLOPostLogoutPageBuilder pageBuilder = this.getPostLogoutPageBuilder();
        pageBuilder.writeDefaultLogoutPage(response);
    }

    SLOPostLogoutPageBuilder getPostLogoutPageBuilder() {
        return new SLOPostLogoutPageBuilder(this.request, this.messageContext);
    }
}

