/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.ErrorHandler;
import com.ibm.ws.security.saml.error.ErrorHandlerImpl;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.impl.KnownSamlUrl;
import com.ibm.ws.security.saml.sso20.internal.AssertionToSubject;
import com.ibm.ws.security.saml.sso20.internal.Initiator;
import com.ibm.ws.security.saml.sso20.internal.SAMLResponseTAI;
import com.ibm.ws.security.saml.sso20.internal.SpCookieRetriver;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.saml.sso20.rs.SamlInboundService;
import com.ibm.ws.security.saml.sso20.slo.SLOHandler;
import com.ibm.ws.security.sso.common.saml.propagation.SamlCommonUtil;
import com.ibm.ws.webcontainer.security.UnprotectedResourceService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.saml2.UserCredentialResolver;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SAMLRequestTAI
implements TrustAssociationInterceptor,
UnprotectedResourceService {
    public static final TraceComponent tc = Tr.register(SAMLRequestTAI.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static final String KEY_LOCATION_ADMIN = "locationAdmin";
    static final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    static final String KEY_AUTH_CACHE_SERVICE = "authCacheService";
    static final AtomicServiceReference<AuthCacheService> authCacheServiceRef = new AtomicServiceReference("authCacheService");
    static final String KEY_SECURITY_SERVICE = "securityService";
    static final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    public static final String TYPE = "SAMLSso20";
    public static final String VERSION = "v1.0";
    protected static final String KEY_SERVICE_PID = "service.pid";
    protected static final String KEY_PROVIDER_ID = "id";
    protected static final String KEY_ID = "id";
    public static final String KEY_FILTER = "authFilter";
    protected static final ConcurrentServiceReferenceMap<String, AuthenticationFilter> authFilterServiceRef = new ConcurrentServiceReferenceMap("authFilter");
    static HashMap<String, String> filterIdMap = new HashMap();
    public static final String KEY_SSO_SAML_SERVICE = "ssoSamlService";
    protected final ConcurrentServiceReferenceMap<String, SsoSamlService> reqSsoSamlServiceRef = new ConcurrentServiceReferenceMap("ssoSamlService");
    public static final String KEY_USER_RESOLVER = "userResolver";
    protected final ConcurrentServiceReferenceMap<String, UserCredentialResolver> userResolverRef = new ConcurrentServiceReferenceMap("userResolver");
    static SubjectHelper subjectHelper = new SubjectHelper();
    static SamlInboundService activatedSamlInboundService = null;
    static final long serialVersionUID = -9160391814767908455L;

    static void setActivatedInboundService(SamlInboundService inboundService) {
        activatedSamlInboundService = inboundService;
    }

    public void setSecurityService(ServiceReference<SecurityService> reference) {
        securityServiceRef.setReference(reference);
    }

    public void unsetSecurityService(ServiceReference<SecurityService> reference) {
        securityServiceRef.unsetReference(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void setAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        String servicePid = (String)ref.getProperty(KEY_SERVICE_PID);
        String id = (String)ref.getProperty("id");
        String oldId = null;
        ConcurrentServiceReferenceMap<String, AuthenticationFilter> concurrentServiceReferenceMap = authFilterServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            authFilterServiceRef.putReference((Object)servicePid, ref);
            oldId = filterIdMap.put(servicePid, id);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setFilter:" + servicePid + " id:" + id + ":" + oldId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        String servicePid = (String)ref.getProperty(KEY_SERVICE_PID);
        String id = (String)ref.getProperty("id");
        String oldId = null;
        ConcurrentServiceReferenceMap<String, AuthenticationFilter> concurrentServiceReferenceMap = authFilterServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            authFilterServiceRef.putReference((Object)servicePid, ref);
            oldId = filterIdMap.put(servicePid, id);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" updateFilter:" + servicePid + " id:" + id + ":" + oldId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void unsetAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        String servicePid = (String)ref.getProperty(KEY_SERVICE_PID);
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, AuthenticationFilter> concurrentServiceReferenceMap = authFilterServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            authFilterServiceRef.removeReference((Object)servicePid, ref);
            filterIdMap.remove(servicePid);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetFilter:" + servicePid + " id:" + id), (Object[])new Object[0]);
        }
    }

    AuthenticationFilter getAuthFilter(String servicePid) {
        return (AuthenticationFilter)authFilterServiceRef.getService((Object)servicePid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void setSsoSamlService(ServiceReference<SsoSamlService> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, SsoSamlService> concurrentServiceReferenceMap = this.reqSsoSamlServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            this.reqSsoSamlServiceRef.putReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setSsoSamlService id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedSsoSamlService(ServiceReference<SsoSamlService> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, SsoSamlService> concurrentServiceReferenceMap = this.reqSsoSamlServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            this.reqSsoSamlServiceRef.putReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" updateSsoSamlService id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void unsetSsoSamlService(ServiceReference<SsoSamlService> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, SsoSamlService> concurrentServiceReferenceMap = this.reqSsoSamlServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            this.reqSsoSamlServiceRef.removeReference((Object)id, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetSsoSamlService id:" + id), (Object[])new Object[0]);
        }
    }

    SsoSamlService getSsoSamlService(String key) {
        return (SsoSamlService)this.reqSsoSamlServiceRef.getService((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void setUserResolver(ServiceReference<UserCredentialResolver> ref) {
        String serviceId = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, UserCredentialResolver> concurrentServiceReferenceMap = this.userResolverRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userResolverRef.putReference((Object)serviceId, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setUserResolver id:" + serviceId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedUserResolver(ServiceReference<UserCredentialResolver> ref) {
        String serviceId = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, UserCredentialResolver> concurrentServiceReferenceMap = this.userResolverRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userResolverRef.putReference((Object)serviceId, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" updateUserResolver id:" + serviceId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void unsetUserResolver(ServiceReference<UserCredentialResolver> ref) {
        String serviceId = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, UserCredentialResolver> concurrentServiceReferenceMap = this.userResolverRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userResolverRef.removeReference((Object)serviceId, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetUserResolverRef id:" + serviceId), (Object[])new Object[0]);
        }
    }

    @Trivial
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        locationAdminRef.setReference(ref);
    }

    @Trivial
    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        locationAdminRef.unsetReference(ref);
    }

    @Trivial
    protected void setAuthCacheService(ServiceReference<AuthCacheService> reference) {
        authCacheServiceRef.setReference(reference);
    }

    @Trivial
    protected void unsetAuthCacheService(ServiceReference<AuthCacheService> reference) {
        authCacheServiceRef.unsetReference(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        Object object = authFilterServiceRef;
        synchronized (object) {
            authFilterServiceRef.activate(cc);
        }
        object = this.reqSsoSamlServiceRef;
        synchronized (object) {
            this.reqSsoSamlServiceRef.activate(cc);
        }
        this.userResolverRef.activate(cc);
        locationAdminRef.activate(cc);
        authCacheServiceRef.activate(cc);
        securityServiceRef.activate(cc);
        SAMLResponseTAI.setTheActivatedSsoSamlServiceRef(this.reqSsoSamlServiceRef);
        AssertionToSubject.setActivatedUserResolverRef(this.userResolverRef);
        SAMLResponseTAI.setActivatedRequestTai(this);
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext cc) {
        Object object = authFilterServiceRef;
        synchronized (object) {
            authFilterServiceRef.deactivate(cc);
        }
        object = this.reqSsoSamlServiceRef;
        synchronized (object) {
            this.reqSsoSamlServiceRef.deactivate(cc);
        }
        this.userResolverRef.deactivate(cc);
        locationAdminRef.deactivate(cc);
        authCacheServiceRef.deactivate(cc);
        securityServiceRef.deactivate(cc);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SamlException.class})
    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest req, HttpServletResponse resp) throws WebTrustAssociationFailedException {
        TAIResult taiResult = this.handleErrorIfAnyAlready(req, resp);
        if (taiResult != null) {
            return taiResult;
        }
        SsoSamlService service = null;
        String spInitiatorId = (String)req.getAttribute("com.ibm.ws.saml.sp.initiator");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("spInitiatorId:" + spInitiatorId), (Object[])new Object[0]);
        }
        if (spInitiatorId != null && !spInitiatorId.isEmpty() && (service = (SsoSamlService)this.reqSsoSamlServiceRef.getService((Object)spInitiatorId)) != null) {
            Initiator initiator = new Initiator(service);
            try {
                return initiator.forwardRequestToSamlIdp(req, resp);
            }
            catch (SamlException e) {
                ErrorHandler errorHandler = ErrorHandlerImpl.getInstance();
                try {
                    errorHandler.handleException(req, resp, e);
                }
                catch (Exception exception) {
                    void e1;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.internal.SAMLRequestTAI", (String)"334", (Object)this, (Object[])new Object[]{req, resp});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unexpceted exception during errorHandling" + e), (Object[])new Object[0]);
                    }
                    throw new WebTrustAssociationFailedException(new SamlException((Exception)e1).getMessage());
                }
                return TAIResult.create((int)403);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("There is no SP service available!!" + spInitiatorId), (Object[])new Object[0]);
        }
        String errMsg = SamlException.formatMessage("SAML20_AUTHENTICATION_FAIL", "CWWKS5063E: SAML Exception: The SAML service provider (SP) failed to process the authentication request.", new Object[]{spInitiatorId});
        throw new WebTrustAssociationFailedException(errMsg);
    }

    public boolean isTargetInterceptor(HttpServletRequest req) throws WebTrustAssociationException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isTargetInterceptor()", (Object[])new Object[0]);
        }
        if (RequestUtil.isUnprotectedUrlForSaml(req)) {
            return false;
        }
        if (this.findSsoSpSpecificFirst(req, this.reqSsoSamlServiceRef, Constants.EndpointType.REQUEST, false)) {
            return true;
        }
        Object exception = req.getAttribute("com.ibm.ws.saml.samlexception.found");
        return exception != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean findSsoSpSpecificFirst(HttpServletRequest req, ConcurrentServiceReferenceMap<String, SsoSamlService> reqSsoSamlServiceRef, Constants.EndpointType endpointType, boolean bSamlInboundAsWell) {
        ConcurrentServiceReferenceMap<String, SsoSamlService> concurrentServiceReferenceMap = reqSsoSamlServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            SsoSamlServiceConfig ssoSamlServiceConfig = new SsoSamlServiceConfig(req, reqSsoSamlServiceRef, bSamlInboundAsWell);
            if (ssoSamlServiceConfig.isMultiple(req)) {
                return false;
            }
            SsoSamlService ssoSamlService = ssoSamlServiceConfig.getSpecificConfig(req, endpointType);
            if (ssoSamlService != null) {
                return true;
            }
            ssoSamlService = ssoSamlServiceConfig.getGenericConfig(req, endpointType);
            if (ssoSamlService != null) {
                return true;
            }
        }
        return false;
    }

    boolean findSpSpecificFirst(HttpServletRequest req, ConcurrentServiceReferenceMap<String, SsoSamlService> ssoSamlServiceRef, Constants.EndpointType endpointType) {
        return this.findSsoSpSpecificFirst(req, ssoSamlServiceRef, endpointType, true);
    }

    public int initialize(Properties props) throws WebTrustAssociationFailedException {
        return 0;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getType() {
        return TYPE;
    }

    public void cleanup() {
    }

    public static HashMap<String, String> getFilterIdMap() {
        return filterIdMap;
    }

    boolean validateSubject(Subject subject, HttpServletRequest req, HttpServletResponse resp, SsoRequest samlRequest) {
        boolean bValid;
        boolean bl = bValid = subject != null;
        if (bValid) {
            SsoConfig samlConfig = samlRequest.getSsoConfig();
            long reAuthnCushionMilliseconds = samlConfig.getReAuthnCushion();
            if (samlConfig.isReAuthnOnAssertionExpire()) {
                Saml20Token saml20Token = SamlCommonUtil.getSaml20TokenFromSubject((Subject)subject, (boolean)true);
                if (saml20Token != null) {
                    DateTime expiredDate = new DateTime(saml20Token.getSamlExpires().getTime() - reAuthnCushionMilliseconds);
                    bValid = expiredDate.isAfterNow();
                } else {
                    bValid = false;
                }
            }
            if (bValid) {
                Hashtable hashtable = subjectHelper.getHashtableFromSubject(subject, new String[]{"com.ibm.ws.saml.spcookie.session.not.on.or.after"});
                if (hashtable == null) {
                    bValid = false;
                } else {
                    long lSessionNotOnOrAfter = (Long)hashtable.get("com.ibm.ws.saml.spcookie.session.not.on.or.after");
                    DateTime sessionNotOnOrAfter = new DateTime(lSessionNotOnOrAfter - reAuthnCushionMilliseconds);
                    if (!sessionNotOnOrAfter.isAfterNow()) {
                        bValid = false;
                    }
                }
            }
        }
        if (!bValid && resp != null) {
            this.removeInvalidSpCookie(req, resp, samlRequest);
        }
        return bValid;
    }

    void removeInvalidSpCookie(HttpServletRequest req, HttpServletResponse resp, SsoRequest samlRequest) {
        String spCookieName = samlRequest.getSpCookieName();
        RequestUtil.removeCookie(req, resp, spCookieName);
    }

    public boolean isAuthenticationRequired(HttpServletRequest request) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isAuthenticationRequired()", (Object[])new Object[0]);
        }
        if (RequestUtil.isUnprotectedUrlForSaml(request)) {
            return false;
        }
        if (this.findSsoSpSpecificFirst(request, this.reqSsoSamlServiceRef, Constants.EndpointType.RESPONSE, false)) {
            IExtendedRequest req = (IExtendedRequest)request;
            SsoRequest samlRequest = (SsoRequest)req.getAttribute("Saml20Request");
            samlRequest.setLocationAdminRef(locationAdminRef);
            req.removeAttribute("Saml20Request");
            if (this.spCookiesExist(req, samlRequest)) {
                return true;
            }
            if (RequestUtil.isLogoutRequestFromIdP((HttpServletRequest)req, req.getContextPath())) {
                return false;
            }
            if (RequestUtil.isUnprocessedAcsCookiePresent(this.reqSsoSamlServiceRef, req, samlRequest)) {
                return true;
            }
        }
        return false;
    }

    boolean spCookiesExist(IExtendedRequest req, SsoRequest samlRequest) {
        String spCookieName;
        byte[] cookieValueBytes;
        if (samlRequest.isDisableLtpaCookie() && (cookieValueBytes = req.getCookieValueAsBytes(spCookieName = samlRequest.getSpCookieName())) != null && cookieValueBytes.length > 0) {
            SpCookieRetriver spCookieRetriver = new SpCookieRetriver((AuthCacheService)authCacheServiceRef.getService(), (HttpServletRequest)req, samlRequest);
            Subject subject = spCookieRetriver.getSubjectFromSpCookie();
            boolean bSubjectValid = this.validateSubject(subject, (HttpServletRequest)req, null, samlRequest);
            if (!bSubjectValid) {
                spCookieRetriver.removeSubject();
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout(HttpServletRequest request, HttpServletResponse response, String userName) {
        boolean bSetSubject = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("logout() userName:" + userName + ", and request URL = " + request.getRequestURI()), (Object[])new Object[0]);
        }
        ConcurrentServiceReferenceMap<String, SsoSamlService> concurrentServiceReferenceMap = this.reqSsoSamlServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            IExtendedRequest req;
            SsoRequest samlRequest = this.getSamlRequest(request, "com.ibm.ws.saml.sp.initiator");
            if (samlRequest != null) {
                samlRequest.setLocationAdminRef(locationAdminRef);
                if (this.isSamlSingleLogoutInProgress(request) || this.servletLogoutPerformsSLO(samlRequest)) {
                    return this.handleSpCookie((IExtendedRequest)request, response, samlRequest, userName, new SpCookieRetriver((AuthCacheService)authCacheServiceRef.getService(), (HttpServletRequest)((IExtendedRequest)request), samlRequest), bSetSubject);
                }
            } else if (this.findSsoSpSpecificFirst(request, this.reqSsoSamlServiceRef, Constants.EndpointType.LOGOUT, false) && (samlRequest = (SsoRequest)(req = (IExtendedRequest)request).getAttribute("Saml20Request")) != null) {
                samlRequest.setLocationAdminRef(locationAdminRef);
                if (this.servletLogoutPerformsSLO(samlRequest)) {
                    return this.handleSpCookie((IExtendedRequest)request, response, samlRequest, userName, new SpCookieRetriver((AuthCacheService)authCacheServiceRef.getService(), (HttpServletRequest)((IExtendedRequest)request), samlRequest), bSetSubject);
                }
            }
            Iterator services = this.reqSsoSamlServiceRef.getServices();
            SsoSamlService ssoSamlService = null;
            boolean delegatedLogout = false;
            while (services.hasNext()) {
                ssoSamlService = (SsoSamlService)services.next();
                samlRequest = new SsoRequest(ssoSamlService.getProviderId(), Constants.EndpointType.LOGOUT, request, Constants.SamlSsoVersion.SAMLSSO20, ssoSamlService);
                samlRequest.setLocationAdminRef(locationAdminRef);
                if (!this.servletLogoutPerformsSLO(samlRequest) || !(delegatedLogout = this.isDelegatedLogoutInProgress(request, response, samlRequest))) continue;
                request.setAttribute("Saml20Request", (Object)samlRequest);
                request.setAttribute("com.ibm.ws.saml.sp.initiator", (Object)samlRequest.getProviderName());
                if (!this.handleSpCookie((IExtendedRequest)request, response, samlRequest, userName, new SpCookieRetriver((AuthCacheService)authCacheServiceRef.getService(), (HttpServletRequest)((IExtendedRequest)request), samlRequest), bSetSubject)) break;
                bSetSubject = true;
                break;
            }
            if (!delegatedLogout) {
                services = this.reqSsoSamlServiceRef.getServices();
                boolean logError = false;
                StringBuffer spList = new StringBuffer(0);
                while (services.hasNext()) {
                    ssoSamlService = (SsoSamlService)services.next();
                    samlRequest = new SsoRequest(ssoSamlService.getProviderId(), Constants.EndpointType.LOGOUT, request, Constants.SamlSsoVersion.SAMLSSO20, ssoSamlService);
                    if (this.servletLogoutPerformsSLO(samlRequest)) {
                        spList.append(", ");
                        logError = true;
                        spList.append(samlRequest.getProviderName());
                    }
                    samlRequest.setLocationAdminRef(locationAdminRef);
                    if (!this.handleSpCookie((IExtendedRequest)request, response, samlRequest, userName, new SpCookieRetriver((AuthCacheService)authCacheServiceRef.getService(), (HttpServletRequest)((IExtendedRequest)request), samlRequest), bSetSubject)) continue;
                    bSetSubject = true;
                }
                if (logError) {
                    spList.delete(0, 1);
                    Tr.error((TraceComponent)tc, (String)"LOGOUT_CANNOT_PERFORM_SLO", (Object[])new Object[]{spList.toString()});
                }
            }
        }
        return bSetSubject;
    }

    private boolean isDelegatedLogoutInProgress(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest) {
        boolean delegated = false;
        SpCookieRetriver spCookieRetriever = new SpCookieRetriver((AuthCacheService)authCacheServiceRef.getService(), (HttpServletRequest)((IExtendedRequest)request), samlRequest);
        Subject subject = spCookieRetriever.getSubjectFromSpCookie();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("subject from spCookie is:" + subject), (Object[])new Object[0]);
        }
        String samlServiceProvider = null;
        if (subject != null) {
            samlServiceProvider = this.getPropertyFromCallerSubjectPrivateCredentials(subject, "io.openliberty.security.sso.saml.idp");
        }
        if (samlServiceProvider != null && samlServiceProvider.equals(samlRequest.getProviderName())) {
            String oidcProvider = this.getPropertyFromCallerSubjectPrivateCredentials(subject, "io.openliberty.security.sso.oidc.op");
            String requestUri = request.getRequestURI();
            if (oidcProvider != null && (requestUri.endsWith("/" + oidcProvider + "/end_session") || requestUri.endsWith("/" + oidcProvider + "/logout"))) {
                delegated = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("delegated logout from other local providers , saml SP : " + samlServiceProvider + ", other provider : " + oidcProvider), (Object[])new Object[0]);
                }
            }
        }
        return delegated;
    }

    private String getPropertyFromCallerSubjectPrivateCredentials(Subject subject, String providerKey) {
        Set<Hashtable> hashtableCreds = subject.getPrivateCredentials(Hashtable.class);
        if (hashtableCreds != null) {
            for (Hashtable hashtable : hashtableCreds) {
                String propertyValue = (String)hashtable.get(providerKey);
                if (propertyValue == null) continue;
                return propertyValue;
            }
        }
        return null;
    }

    private SsoRequest getSamlRequest(HttpServletRequest request, String attrib) {
        SsoSamlService service;
        String provider = this.getSamlSP(request, attrib);
        if (provider != null && (service = this.getSsoSamlService(provider)) != null) {
            return new SsoRequest(provider, Constants.EndpointType.LOGOUT, request, Constants.SamlSsoVersion.SAMLSSO20, service);
        }
        return null;
    }

    private String getSamlSP(HttpServletRequest request, String attribute) {
        if (request != null && request.getAttribute(attribute) != null) {
            return (String)request.getAttribute(attribute);
        }
        return null;
    }

    private boolean isSamlSingleLogoutInProgress(HttpServletRequest request) {
        return this.requestHasAttribute(request, "SLOInProgress");
    }

    private boolean requestHasAttribute(HttpServletRequest request, String attrib) {
        if (request.getAttribute(attrib) != null) {
            return (Boolean)request.getAttribute(attrib);
        }
        return false;
    }

    private void performSamlSLO(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest, Subject subject) throws SamlException {
        if (this.isSamlSingleLogoutInProgress(request)) {
            this.removeSLOAttribute(request);
            return;
        }
        SLOHandler slohandler = new SLOHandler();
        Map<String, Object> parameters = this.createParamMap(samlRequest, subject);
        slohandler.handleRequest(request, response, samlRequest, parameters);
    }

    private void removeSLOAttribute(HttpServletRequest request) {
        request.removeAttribute("SLOInProgress");
    }

    private Map<String, Object> createParamMap(SsoRequest samlRequest, Subject subject) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put(Constants.KEY_SAML_SERVICE, samlRequest.getSsoSamlService());
        results.put(Constants.KEY_SECURITY_SERVICE, securityServiceRef.getService());
        results.put("KEY_SUBJECT", subject);
        return results;
    }

    private boolean servletLogoutPerformsSLO(SsoRequest samlRequest) {
        return samlRequest.getSsoConfig().isServletRequestLogoutPerformsSamlLogout();
    }

    boolean handleSpCookie(IExtendedRequest req, HttpServletResponse response, SsoRequest samlRequest, String userName, SpCookieRetriver spCookieRetriever, boolean bSetSubjectAlready) {
        boolean bSetSubject = false;
        Subject subject = spCookieRetriever.getSubjectFromSpCookie();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("subject from spCookie is:" + subject), (Object[])new Object[0]);
        }
        if (subject == null) {
            String spCookieName = samlRequest.getSpCookieName();
            RequestUtil.removeCookie((HttpServletRequest)req, response, spCookieName);
            return false;
        }
        if (samlRequest.isDisableLtpaCookie()) {
            if (!bSetSubjectAlready) {
                bSetSubject = this.authenticateBeforeRemovingSubject(subject, req, response, userName, spCookieRetriever.getCustomCacheKey(), samlRequest);
            }
            this.removeSubjectAndCookie(req, response, spCookieRetriever, samlRequest);
        }
        return bSetSubject;
    }

    @FFDCIgnore(value={CredentialExpiredException.class, CredentialDestroyedException.class})
    boolean authenticateBeforeRemovingSubject(Subject subject, IExtendedRequest req, HttpServletResponse response, String userName, String customCacheKey, SsoRequest samlRequest) {
        WSCredential wsCredential = SamlUtil.getWSCredential(subject);
        if (wsCredential != null) {
            try {
                String accessId = wsCredential.getAccessId();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("wsCredential user:" + accessId), (Object[])new Object[0]);
                }
                if (accessId != null) {
                    WSAuthenticationData authenticationData = new WSAuthenticationData();
                    authenticationData.set("HTTP_SERVLET_REQUEST", (Object)req);
                    authenticationData.set("HTTP_SERVLET_RESPONSE", (Object)response);
                    authenticationData.set("TOKEN64", (Object)customCacheKey);
                    return this.authenticateSubject(subject, (HttpServletRequest)req, response, (AuthenticationData)authenticationData, samlRequest);
                }
            }
            catch (CredentialExpiredException credentialExpiredException) {
            }
            catch (CredentialDestroyedException credentialDestroyedException) {
                // empty catch block
            }
        }
        return false;
    }

    void removeSubjectAndCookie(IExtendedRequest req, HttpServletResponse response, SpCookieRetriver spCookieRetriever, SsoRequest samlRequest) {
        spCookieRetriever.removeSubject();
        String spCookieName = samlRequest.getSpCookieName();
        RequestUtil.removeCookie((HttpServletRequest)req, response, spCookieName);
    }

    boolean authenticateSubject(Subject subject, HttpServletRequest req, HttpServletResponse resp, AuthenticationData authenticationData, SsoRequest samlRequest) {
        Hashtable hashtable = subjectHelper.getHashtableFromSubject(subject, new String[]{"com.ibm.ws.saml.spcookie.session.not.on.or.after"});
        if (hashtable == null) {
            return false;
        }
        long lSessionNotOnOrAfter = (Long)hashtable.get("com.ibm.ws.saml.spcookie.session.not.on.or.after");
        DateTime sessionNotOnOrAfter = new DateTime(lSessionNotOnOrAfter);
        if (!sessionNotOnOrAfter.isAfterNow()) {
            this.removeInvalidSpCookie(req, resp, samlRequest);
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("subject from spCookie is:" + subject), (Object[])new Object[0]);
        }
        SecurityService securityService = (SecurityService)securityServiceRef.getService();
        AuthenticationService authenticationService = securityService.getAuthenticationService();
        return this.authenticateWithSubject(req, resp, subject, authenticationService, authenticationData);
    }

    @FFDCIgnore(value={AuthenticationException.class})
    private boolean authenticateWithSubject(HttpServletRequest req, HttpServletResponse res, Subject subject, AuthenticationService authenticationService, AuthenticationData authenticationData) {
        try {
            Subject newSubject = authenticationService.authenticate("system.WEB_INBOUND", authenticationData, subject);
            SubjectManager subjectManager = new SubjectManager();
            subjectManager.setCallerSubject(newSubject);
        }
        catch (AuthenticationException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticationException:" + (Object)((Object)e)), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    TAIResult handleErrorIfAnyAlready(HttpServletRequest req, HttpServletResponse resp) throws WebTrustAssociationFailedException {
        block3: {
            SamlException exception = (SamlException)req.getAttribute("com.ibm.ws.saml.samlexception.found");
            if (exception == null) {
                return null;
            }
            ErrorHandler errorHandler = ErrorHandlerImpl.getInstance();
            try {
                errorHandler.handleException(req, resp, exception);
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.security.saml.sso20.internal.SAMLRequestTAI", (String)"1025", (Object)this, (Object[])new Object[]{req, resp});
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Unexpceted exception during errorHandling" + exception), (Object[])new Object[0]);
            }
        }
        return TAIResult.create((int)403);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postLogout(HttpServletRequest request, HttpServletResponse response) {
        boolean result = true;
        ConcurrentServiceReferenceMap<String, SsoSamlService> concurrentServiceReferenceMap = this.reqSsoSamlServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            SsoRequest samlRequest = this.getSamlRequest(request, "com.ibm.ws.saml.sp.initiator");
            if (samlRequest != null && this.servletLogoutPerformsSLO(samlRequest)) {
                samlRequest.setLocationAdminRef(locationAdminRef);
                try {
                    this.performSamlSLO(request, response, samlRequest, WSSubject.getCallerSubject());
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.saml.sso20.internal.SAMLRequestTAI", (String)"1052", (Object)this, (Object[])new Object[]{request, response});
                    result = false;
                }
                catch (SamlException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.internal.SAMLRequestTAI", (String)"1054", (Object)this, (Object[])new Object[]{request, response});
                    result = false;
                }
            }
        }
        return result;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class SsoSamlServiceConfig {
        private static final String SAML_CONTEXT_PATH = "/ibm/saml20";
        public SsoSamlService[] filteredSsoSamlServices = null;
        public int iFilteredSsoCnt = 0;
        public SsoSamlService[] genericSsoSamlServices = null;
        public int iGenericSsoCnt = 0;
        ConcurrentServiceReferenceMap<String, SsoSamlService> activatedSsoSamlServiceRef = null;
        boolean bSamlInboundAsWell;
        static final long serialVersionUID = 5229011354003447717L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SsoSamlServiceConfig(HttpServletRequest req, ConcurrentServiceReferenceMap<String, SsoSamlService> ssoSamlServiceRef, boolean bSamlInboundAsWell) {
            this.activatedSsoSamlServiceRef = ssoSamlServiceRef;
            this.bSamlInboundAsWell = bSamlInboundAsWell;
            this.filteredSsoSamlServices = new SsoSamlService[this.activatedSsoSamlServiceRef.size()];
            this.genericSsoSamlServices = new SsoSamlService[this.activatedSsoSamlServiceRef.size()];
            Iterator ssoServices = this.activatedSsoSamlServiceRef.getServices();
            SsoSamlService ssoSamlService = null;
            while (ssoServices.hasNext()) {
                ssoSamlService = (SsoSamlService)ssoServices.next();
                if (!bSamlInboundAsWell && ssoSamlService.isInboundPropagation() || !ssoSamlService.isEnabled()) continue;
                String ctxPath = req.getContextPath();
                if (RequestUtil.isLogoutRequestFromIdP(req, ctxPath) && ssoSamlService.getProviderId().equals(this.getProviderNameFromUrl(req))) {
                    this.iFilteredSsoCnt = 1;
                    this.filteredSsoSamlServices[0] = ssoSamlService;
                    break;
                }
                AuthenticationFilter authFilter = ssoSamlService.getConfig().getAuthFilter(authFilterServiceRef);
                if (authFilter != null) {
                    if (!authFilter.isAccepted(req)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("pass sso authFilter(" + authFilter + "):" + ssoSamlService.getProviderId()), (Object[])new Object[0]);
                    }
                    this.filteredSsoSamlServices[this.iFilteredSsoCnt++] = ssoSamlService;
                    continue;
                }
                this.genericSsoSamlServices[this.iGenericSsoCnt++] = ssoSamlService;
            }
        }

        public Matcher endpointRequestMatcher(HttpServletRequest request) {
            Matcher m;
            String path = request.getPathInfo();
            if (path != null && (m = KnownSamlUrl.matchKnownSamlUrl(path)).matches()) {
                return m;
            }
            return null;
        }

        public String getProviderNameFromUrl(HttpServletRequest request) {
            Matcher m = this.endpointRequestMatcher(request);
            if (m != null) {
                return m.group(1);
            }
            return null;
        }

        public SsoSamlService getGenericConfig(HttpServletRequest req, Constants.EndpointType endpointType) {
            SsoSamlService ssoSamlService = null;
            if (this.iGenericSsoCnt > 0) {
                String spProviderId = null;
                for (int iI = 0; iI < this.iGenericSsoCnt && "defaultSP".equals(spProviderId = (ssoSamlService = this.genericSsoSamlServices[iI]).getProviderId()); ++iI) {
                }
                req.setAttribute("com.ibm.ws.saml.sp.initiator", spProviderId);
                RequestUtil.setSamlRequest(req, ssoSamlService, endpointType);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("the first generic SP passed:" + spProviderId), (Object[])new Object[0]);
                }
            }
            return ssoSamlService;
        }

        public SsoSamlService getSpecificConfig(HttpServletRequest req, Constants.EndpointType endpointType) {
            SsoSamlService ssoSamlService = null;
            if (this.iFilteredSsoCnt == 1) {
                ssoSamlService = this.filteredSsoSamlServices[0];
                RequestUtil.setSamlRequest(req, ssoSamlService, endpointType);
                String spProviderId = ssoSamlService.getProviderId();
                req.setAttribute("com.ibm.ws.saml.sp.initiator", (Object)spProviderId);
            }
            return ssoSamlService;
        }

        public boolean isMultiple(HttpServletRequest req) {
            if (this.iFilteredSsoCnt > 1) {
                String spNames = "";
                for (int iI = 0; iI < this.iFilteredSsoCnt; ++iI) {
                    String middle = iI > 0 ? (this.iFilteredSsoCnt - iI == 1 ? " and " : ", ") : "";
                    spNames = spNames.concat(middle).concat(this.filteredSsoSamlServices[iI].getProviderId());
                }
                String requestUrl = req.getRequestURL().toString();
                SamlException samlException = new SamlException("SAML20_MULTI_SPECIFIC_SP", null, new Object[]{requestUrl, spNames});
                req.setAttribute("com.ibm.ws.saml.samlexception.found", (Object)samlException);
                return true;
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.saml.sso20.internal.SAMLRequestTAI$SsoSamlServiceConfig", SsoSamlServiceConfig.class, null, null);
        }
    }
}

