/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.PublicApi;
import graphql.cachecontrol.CacheControl;
import graphql.collect.ImmutableKit;
import graphql.execution.ExecutionId;
import graphql.execution.RawVariables;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationState;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.dataloader.DataLoaderRegistry;

@PublicApi
public class ExecutionInput {
    private final String query;
    private final String operationName;
    private final Object context;
    private final GraphQLContext graphQLContext;
    private final Object localContext;
    private final Object root;
    private final RawVariables rawVariables;
    private final Map<String, Object> extensions;
    private final DataLoaderRegistry dataLoaderRegistry;
    private final CacheControl cacheControl;
    private final ExecutionId executionId;
    private final Locale locale;

    @Internal
    private ExecutionInput(Builder builder) {
        this.query = Assert.assertNotNull(builder.query, () -> "query can't be null");
        this.operationName = builder.operationName;
        this.context = builder.context;
        this.graphQLContext = Assert.assertNotNull(builder.graphQLContext);
        this.root = builder.root;
        this.rawVariables = builder.rawVariables;
        this.dataLoaderRegistry = builder.dataLoaderRegistry;
        this.cacheControl = builder.cacheControl;
        this.executionId = builder.executionId;
        this.locale = builder.locale != null ? builder.locale : Locale.getDefault();
        this.localContext = builder.localContext;
        this.extensions = builder.extensions;
    }

    public String getQuery() {
        return this.query;
    }

    public String getOperationName() {
        return this.operationName;
    }

    @Deprecated
    public Object getContext() {
        return this.context;
    }

    public GraphQLContext getGraphQLContext() {
        return this.graphQLContext;
    }

    public Object getLocalContext() {
        return this.localContext;
    }

    public Object getRoot() {
        return this.root;
    }

    public Map<String, Object> getVariables() {
        return this.rawVariables.toMap();
    }

    public RawVariables getRawVariables() {
        return this.rawVariables;
    }

    public DataLoaderRegistry getDataLoaderRegistry() {
        return this.dataLoaderRegistry;
    }

    @Deprecated
    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public ExecutionInput transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder().query(this.query).operationName(this.operationName).context(this.context).transfer(this.graphQLContext).localContext(this.localContext).root(this.root).dataLoaderRegistry(this.dataLoaderRegistry).cacheControl(this.cacheControl).variables(this.rawVariables.toMap()).extensions(this.extensions).executionId(this.executionId).locale(this.locale);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public String toString() {
        return "ExecutionInput{query='" + this.query + '\'' + ", operationName='" + this.operationName + '\'' + ", context=" + this.context + ", graphQLContext=" + this.graphQLContext + ", root=" + this.root + ", rawVariables=" + this.rawVariables + ", dataLoaderRegistry=" + this.dataLoaderRegistry + ", executionId= " + this.executionId + ", locale= " + this.locale + '}';
    }

    public static Builder newExecutionInput() {
        return new Builder();
    }

    public static Builder newExecutionInput(String query) {
        return new Builder().query(query);
    }

    public static class Builder {
        private String query;
        private String operationName;
        private GraphQLContext graphQLContext = GraphQLContext.newContext().build();
        private Object context = this.graphQLContext;
        private Object localContext;
        private Object root;
        private RawVariables rawVariables = RawVariables.emptyVariables();
        public Map<String, Object> extensions = ImmutableKit.emptyMap();
        private DataLoaderRegistry dataLoaderRegistry = DataLoaderDispatcherInstrumentationState.EMPTY_DATALOADER_REGISTRY;
        private CacheControl cacheControl = CacheControl.newCacheControl();
        private Locale locale = Locale.getDefault();
        private ExecutionId executionId;

        public Builder query(String query) {
            this.query = Assert.assertNotNull(query, () -> "query can't be null");
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder executionId(ExecutionId executionId) {
            this.executionId = executionId;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder localContext(Object localContext) {
            this.localContext = localContext;
            return this;
        }

        @Deprecated
        public Builder context(Object context) {
            this.context = context;
            return this;
        }

        @Deprecated
        public Builder context(GraphQLContext.Builder contextBuilder) {
            this.context = contextBuilder.build();
            return this;
        }

        @Deprecated
        public Builder context(UnaryOperator<GraphQLContext.Builder> contextBuilderFunction) {
            GraphQLContext.Builder builder = GraphQLContext.newContext();
            builder = (GraphQLContext.Builder)contextBuilderFunction.apply(builder);
            return this.context(builder.build());
        }

        public Builder graphQLContext(Consumer<GraphQLContext.Builder> builderFunction) {
            GraphQLContext.Builder builder = GraphQLContext.newContext();
            builderFunction.accept(builder);
            this.graphQLContext.putAll(builder);
            return this;
        }

        public Builder graphQLContext(Map<?, Object> mapOfContext) {
            this.graphQLContext.putAll(mapOfContext);
            return this;
        }

        private Builder transfer(GraphQLContext graphQLContext) {
            this.graphQLContext = Assert.assertNotNull(graphQLContext);
            return this;
        }

        public Builder root(Object root) {
            this.root = root;
            return this;
        }

        public Builder variables(Map<String, Object> rawVariables) {
            Assert.assertNotNull(rawVariables, () -> "variables map can't be null");
            this.rawVariables = RawVariables.of(rawVariables);
            return this;
        }

        public Builder extensions(Map<String, Object> extensions) {
            this.extensions = Assert.assertNotNull(extensions, () -> "extensions map can't be null");
            return this;
        }

        public Builder dataLoaderRegistry(DataLoaderRegistry dataLoaderRegistry) {
            this.dataLoaderRegistry = Assert.assertNotNull(dataLoaderRegistry);
            return this;
        }

        @Deprecated
        public Builder cacheControl(CacheControl cacheControl) {
            this.cacheControl = Assert.assertNotNull(cacheControl);
            return this;
        }

        public ExecutionInput build() {
            return new ExecutionInput(this);
        }
    }
}

