/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.source.utils.AuditUtils;
import java.util.Arrays;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JMSAuthorizationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(JMSAuthorizationEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = -2087069304781485486L;

    public JMSAuthorizationEvent() {
        this.set("eventName", "SECURITY_JMS_AUTHZ");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public JMSAuthorizationEvent(String userName, String hostAddress, String port, String chainName, String busName, String messagingEngine, String destination, String operationType, String[] roles, String resource, Integer statusCode) {
        block17: {
            this();
            try {
                if (busName != null) {
                    this.set("target.messaging.busname", busName);
                } else {
                    this.set("target.messaging.busname", "defaultBus");
                }
                if (messagingEngine != null) {
                    this.set("target.messaging.engine", messagingEngine);
                } else {
                    this.set("target.messaging.engine", "defaultME");
                }
                this.set("observer.name", "JMSMessagingImplementation");
                if (userName != null) {
                    this.set("target.credential.token", userName);
                    this.set("target.credential.type", "BASIC");
                }
                if (destination != null) {
                    this.set("target.messaging.destination", destination);
                }
                if (operationType != null) {
                    this.set("target.messaging.operationType", operationType);
                }
                if (hostAddress != null) {
                    this.set("target.messaging.callType", "remote");
                    this.set("target.host.address", hostAddress);
                    if (port != null) {
                        this.set("target.host.address", hostAddress + ":" + port);
                    }
                } else {
                    this.set("target.messaging.callType", "local");
                    this.set("target.host.address", "127.0.0.1:8010");
                }
                if (chainName != null) {
                    this.set("target.messaging.remote.chainName", chainName);
                }
                this.set("target.realm", AuditUtils.getRealmName());
                if (roles != null && roles.length != 0) {
                    this.set("target.messaging.jmsActions", Arrays.toString(roles));
                }
                if (resource != null) {
                    this.set("target.messaging.jmsResource", resource);
                }
                if (statusCode == 200) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", "JMS");
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", "JMS");
                }
                this.set("target.typeURI", "service/jms/messagingResource");
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.event.JMSAuthorizationEvent", (String)"102", (Object)((Object)this), (Object[])new Object[]{userName, hostAddress, port, chainName, busName, messagingEngine, destination, operationType, roles, resource, statusCode});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block17;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating JMSAuthorizationEvent", (Object[])new Object[]{e});
            }
        }
    }
}

