/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor;
import com.ibm.ws.webcontainer.servlet.FileServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class StaticFileServletWrapper
extends FileServletWrapper {
    private File file;
    RandomAccessFile raf = null;
    private long fileSize = -1L;

    public StaticFileServletWrapper(IServletContext parent, DefaultExtensionProcessor parentProcessor, File file) {
        super(parent, parentProcessor);
        this.file = file;
    }

    @Override
    public String getServletName() {
        return "Static File wrapper";
    }

    @Override
    public String getName() {
        return "Static File wrapper";
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    protected RandomAccessFile getRandomAccessFile() throws IOException {
        this.raf = new RandomAccessFile(this.file, "rw");
        return this.raf;
    }

    @Override
    protected long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    protected long getFileSize(boolean update) {
        if (this.fileSize == -1L || update) {
            this.fileSize = this.file.length();
        }
        return this.fileSize;
    }

    @Override
    public void setParent(IServletContext parent) {
    }

    @Override
    public boolean isAvailable() {
        return this.file.exists();
    }
}

