/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.CpuMethods;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class Cpu {
    static final Cpu INSTANCE = new Cpu();
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return INSTANCE.registerObservers(openTelemetry, Runtime.getRuntime()::availableProcessors, CpuMethods.processCpuTime(), CpuMethods.processCpuUtilization());
    }

    List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, IntSupplier availableProcessors, @Nullable Supplier<Long> processCpuTime, @Nullable Supplier<Double> processCpuUtilization) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        if (processCpuTime != null) {
            observables.add(meter.counterBuilder("jvm.cpu.time").ofDoubles().setDescription("CPU time used by the process as reported by the JVM.").setUnit("s").buildWithCallback(observableMeasurement -> {
                Long cpuTimeNanos = (Long)processCpuTime.get();
                if (cpuTimeNanos != null && cpuTimeNanos >= 0L) {
                    observableMeasurement.record((double)cpuTimeNanos.longValue() / NANOS_PER_S);
                }
            }));
        }
        observables.add(meter.upDownCounterBuilder("jvm.cpu.count").setDescription("Number of processors available to the Java virtual machine.").setUnit("{cpu}").buildWithCallback(observableMeasurement -> observableMeasurement.record(availableProcessors.getAsInt())));
        if (processCpuUtilization != null) {
            observables.add(meter.gaugeBuilder("jvm.cpu.recent_utilization").setDescription("Recent CPU utilization for the process as reported by the JVM.").setUnit("1").buildWithCallback(observableMeasurement -> {
                Double cpuUsage = (Double)processCpuUtilization.get();
                if (cpuUsage != null && cpuUsage >= 0.0) {
                    observableMeasurement.record(cpuUsage);
                }
            }));
        }
        return observables;
    }

    private Cpu() {
    }
}

