/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.genai;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import java.util.List;
import javax.annotation.Nullable;

public final class GenAiAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    static final AttributeKey<String> GEN_AI_OPERATION_NAME = AttributeKey.stringKey("gen_ai.operation.name");
    private static final AttributeKey<List<String>> GEN_AI_REQUEST_ENCODING_FORMATS = AttributeKey.stringArrayKey("gen_ai.request.encoding_formats");
    private static final AttributeKey<Double> GEN_AI_REQUEST_FREQUENCY_PENALTY = AttributeKey.doubleKey("gen_ai.request.frequency_penalty");
    private static final AttributeKey<Long> GEN_AI_REQUEST_MAX_TOKENS = AttributeKey.longKey("gen_ai.request.max_tokens");
    static final AttributeKey<String> GEN_AI_REQUEST_MODEL = AttributeKey.stringKey("gen_ai.request.model");
    private static final AttributeKey<Double> GEN_AI_REQUEST_PRESENCE_PENALTY = AttributeKey.doubleKey("gen_ai.request.presence_penalty");
    private static final AttributeKey<Long> GEN_AI_REQUEST_SEED = AttributeKey.longKey("gen_ai.request.seed");
    private static final AttributeKey<List<String>> GEN_AI_REQUEST_STOP_SEQUENCES = AttributeKey.stringArrayKey("gen_ai.request.stop_sequences");
    private static final AttributeKey<Double> GEN_AI_REQUEST_TEMPERATURE = AttributeKey.doubleKey("gen_ai.request.temperature");
    private static final AttributeKey<Double> GEN_AI_REQUEST_TOP_K = AttributeKey.doubleKey("gen_ai.request.top_k");
    private static final AttributeKey<Double> GEN_AI_REQUEST_TOP_P = AttributeKey.doubleKey("gen_ai.request.top_p");
    private static final AttributeKey<List<String>> GEN_AI_RESPONSE_FINISH_REASONS = AttributeKey.stringArrayKey("gen_ai.response.finish_reasons");
    private static final AttributeKey<String> GEN_AI_RESPONSE_ID = AttributeKey.stringKey("gen_ai.response.id");
    static final AttributeKey<String> GEN_AI_RESPONSE_MODEL = AttributeKey.stringKey("gen_ai.response.model");
    static final AttributeKey<String> GEN_AI_SYSTEM = AttributeKey.stringKey("gen_ai.system");
    static final AttributeKey<Long> GEN_AI_USAGE_INPUT_TOKENS = AttributeKey.longKey("gen_ai.usage.input_tokens");
    static final AttributeKey<Long> GEN_AI_USAGE_OUTPUT_TOKENS = AttributeKey.longKey("gen_ai.usage.output_tokens");
    private final GenAiAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(GenAiAttributesGetter<REQUEST, RESPONSE> attributesGetter) {
        return new GenAiAttributesExtractor<REQUEST, RESPONSE>(attributesGetter);
    }

    private GenAiAttributesExtractor(GenAiAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_OPERATION_NAME, this.getter.getOperationName(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_SYSTEM, this.getter.getSystem(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_MODEL, this.getter.getRequestModel(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_SEED, this.getter.getRequestSeed(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_ENCODING_FORMATS, this.getter.getRequestEncodingFormats(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_FREQUENCY_PENALTY, this.getter.getRequestFrequencyPenalty(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_MAX_TOKENS, this.getter.getRequestMaxTokens(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_PRESENCE_PENALTY, this.getter.getRequestPresencePenalty(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_STOP_SEQUENCES, this.getter.getRequestStopSequences(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_TEMPERATURE, this.getter.getRequestTemperature(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_TOP_K, this.getter.getRequestTopK(request));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_REQUEST_TOP_P, this.getter.getRequestTopP(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        List<String> finishReasons = this.getter.getResponseFinishReasons(request, response);
        if (finishReasons != null && !finishReasons.isEmpty()) {
            attributes.put(GEN_AI_RESPONSE_FINISH_REASONS, finishReasons);
        }
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_RESPONSE_ID, this.getter.getResponseId(request, response));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_RESPONSE_MODEL, this.getter.getResponseModel(request, response));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_USAGE_INPUT_TOKENS, this.getter.getUsageInputTokens(request, response));
        AttributesExtractorUtil.internalSet(attributes, GEN_AI_USAGE_OUTPUT_TOKENS, this.getter.getUsageOutputTokens(request, response));
    }
}

