/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.HeaderBuilder;
import io.smallrye.graphql.client.typesafe.impl.QueryBuilder;
import io.smallrye.graphql.client.typesafe.impl.ResultBuilder;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphQlClientProxy {
    private static final Logger log = LoggerFactory.getLogger(GraphQlClientProxy.class);
    private static final MediaType APPLICATION_JSON_UTF8 = MediaType.APPLICATION_JSON_TYPE.withCharset("utf-8");
    private static final JsonBuilderFactory jsonObjectFactory = Json.createBuilderFactory(null);
    private final Map<String, String> queryCache = new HashMap<String, String>();
    private final WebTarget target;

    GraphQlClientProxy(WebTarget target) {
        this.target = target;
    }

    Object invoke(Class<?> api, MethodInvocation method) {
        MultivaluedMap<String, Object> headers = new HeaderBuilder(api, method).build();
        String request = this.request(method);
        String response = this.post(request, headers);
        log.debug("response graphql: {}", (Object)response);
        return new ResultBuilder(method, this.queryCache, response).read();
    }

    private String request(MethodInvocation method) {
        JsonObjectBuilder request = jsonObjectFactory.createObjectBuilder();
        String query = this.queryCache.computeIfAbsent(method.getKey(), key -> new QueryBuilder(method).build());
        request.add("query", query);
        request.add("variables", this.variables(method));
        request.add("operationName", method.getName());
        log.info("request graphql: {}", (Object)query);
        String requestString = request.build().toString();
        log.debug("full graphql request: {}", (Object)requestString);
        return requestString;
    }

    private JsonObjectBuilder variables(MethodInvocation method) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        method.valueParameters().forEach(parameter -> builder.add(parameter.getName(), this.value(parameter.getValue())));
        return builder;
    }

    private JsonValue value(Object value) {
        if (value == null) {
            return JsonValue.NULL;
        }
        TypeInfo type = TypeInfo.of(value.getClass());
        if (type.isScalar()) {
            return this.scalarValue(value);
        }
        if (type.isCollection()) {
            return this.arrayValue(value);
        }
        return this.objectValue(value, type.fields());
    }

    private JsonValue scalarValue(Object value) {
        if (value instanceof String) {
            return Json.createValue((String)((String)value));
        }
        if (value instanceof Date) {
            return Json.createValue((String)((Date)value).toInstant().toString());
        }
        if (value instanceof Enum) {
            return Json.createValue((String)((Enum)value).name());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Byte) {
            return Json.createValue((int)((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return Json.createValue((int)((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return Json.createValue((int)((Integer)value));
        }
        if (value instanceof Long) {
            return Json.createValue((long)((Long)value));
        }
        if (value instanceof Double) {
            return Json.createValue((double)((Double)value));
        }
        if (value instanceof Float) {
            return Json.createValue((double)((Float)value).floatValue());
        }
        if (value instanceof BigInteger) {
            return Json.createValue((BigInteger)((BigInteger)value));
        }
        if (value instanceof BigDecimal) {
            return Json.createValue((BigDecimal)((BigDecimal)value));
        }
        return Json.createValue((String)value.toString());
    }

    private JsonArray arrayValue(Object value) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        this.values(value).forEach(item -> array.add(this.value(item)));
        return array.build();
    }

    private Collection<?> values(Object value) {
        return value.getClass().isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
    }

    private JsonObject objectValue(Object object, Stream<FieldInfo> fields) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        fields.forEach(field -> builder.add(field.getName(), this.value(field.get(object))));
        return builder.build();
    }

    private String post(String request, MultivaluedMap<String, Object> headers) {
        Response response = this.target.request(new MediaType[]{APPLICATION_JSON_UTF8}).headers(headers).post(Entity.entity((Object)request, (MediaType)APPLICATION_JSON_UTF8));
        Response.StatusType status = response.getStatusInfo();
        if (status.getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new GraphQlClientException("expected successful status code but got " + status.getStatusCode() + " " + status.getReasonPhrase() + ":\n" + (String)response.readEntity(String.class));
        }
        return (String)response.readEntity(String.class);
    }
}

