/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.virtualhost;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.virtualhost.VirtualHostAlias;
import com.ibm.ws.sip.container.virtualhost.VirtualHostAliasImpl;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.sip.SipURI;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class SipVirtualHostAdapter {
    private static final LogMgr c_logger = Log.get(SipVirtualHostAdapter.class);
    private static final TraceComponent tc = Tr.register(SipVirtualHostAdapter.class);
    public static final String DEFAULT_VH_ID = "default_host";
    private static final String SIP_CONNECTOR_VH_ID = "sipUA_VH";
    private static final String VH_FACTORY_PID = "com.ibm.ws.http.virtualhost";
    private static final String RTCOMM_CONNECTOR_FACTORY_PID = "com.ibm.ws.rtcomm.connector";
    private static final String HOST_ALIAS_ATTRIBUTE = "hostAlias";
    private static final String HOST_ATTRIBUTE = "host";
    private static final String SERVICE_PID_ATTRIBUTE = "service.pid";
    private static final String VIRTUAL_HOST_REF_ATTRIBUTE = "virtualhostRef";
    private static final String SIP_CONNECTOR_PREFIX = "gateway.";
    private static final String ALLOW_FROM_SIPENDPOINT_REF_SUFFIX = ".allowFromSipEndpointRef";
    private static List<VirtualHostAlias> s_defaultVH_hostAliases = Collections.synchronizedList(new LinkedList());
    private static List<VirtualHostAlias> s_sipConnectorVH_hostAliases = Collections.synchronizedList(new LinkedList());
    private static Map<InetAddress, Map<String, HashSet<Integer>>> sipConnectorEndpoint = new HashMap<InetAddress, Map<String, HashSet<Integer>>>();
    private static HashSet<String> vhExcludedFromComposition = new HashSet();

    public static void addSipEndpointHostAliasesToVH(Map<String, Object> sipEndpointProperties, boolean isSslEnabled, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        boolean isSipConnectorVH;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] params = new Object[]{sipEndpointProperties, isSslEnabled};
            Tr.debug((TraceComponent)tc, (String)"Add SIP endpoint host aliases to virtual host", (Object[])params);
        }
        if (isSipConnectorVH = SipVirtualHostAdapter.isSipConnectorReferenecedEndpoint(sipEndpointProperties, configAdminRef)) {
            boolean isExistSipUaVH = SipVirtualHostAdapter.isExistSipUaVirtualHost(configAdminRef);
            if (!isExistSipUaVH) {
                SipVirtualHostAdapter.createSipConnectorVirtualHost(sipEndpointProperties, isSslEnabled, configAdminRef);
            } else {
                SipVirtualHostAdapter.updateSipEndpointVirtualHostAliases(true, sipEndpointProperties, isSslEnabled, configAdminRef);
            }
            SipVirtualHostAdapter.addConnectorSipEndpointToList(sipEndpointProperties);
        } else {
            SipVirtualHostAdapter.updateSipEndpointVirtualHostAliases(true, sipEndpointProperties, isSslEnabled, configAdminRef);
        }
    }

    private static void addConnectorSipEndpointToList(Map<String, Object> sipEndpointProperties) throws UnknownHostException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "addConnectorSipEndpointToList", (Object)sipEndpointProperties);
        }
        String endpointHost = (String)sipEndpointProperties.get(HOST_ATTRIBUTE);
        String tcpPort = String.valueOf(sipEndpointProperties.get("sipTCPPort"));
        SipVirtualHostAdapter.addHostTransportPortToConnectorList(endpointHost, "TCP", tcpPort);
        String udpPort = String.valueOf(sipEndpointProperties.get("sipUDPPort"));
        SipVirtualHostAdapter.addHostTransportPortToConnectorList(endpointHost, "UDP", udpPort);
        String tlsPort = String.valueOf(sipEndpointProperties.get("sipTLSPort"));
        SipVirtualHostAdapter.addHostTransportPortToConnectorList(endpointHost, "TLS", tlsPort);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "addConnectorSipEndpointToList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addHostTransportPortToConnectorList(String host, String transport, String port) throws UnknownHostException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "addHostTransportPortToConnectorList", host, transport, port);
        }
        try {
            if (port == null || port.length() <= 0) {
                return;
            }
            Integer portInt = Integer.decode(port);
            Map<InetAddress, Map<String, HashSet<Integer>>> map = sipConnectorEndpoint;
            synchronized (map) {
                HashSet<Integer> ports;
                InetAddress iaHost = SipVirtualHostAdapter.normlizeHost(host);
                Map<String, HashSet<Integer>> transports = sipConnectorEndpoint.get(iaHost);
                if (transports == null) {
                    transports = new HashMap<String, HashSet<Integer>>();
                    sipConnectorEndpoint.put(iaHost, transports);
                }
                if ((ports = transports.get(transport)) == null) {
                    ports = new HashSet();
                    transports.put(transport, ports);
                }
                ports.add(portInt);
            }
        }
        finally {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(null, "addHostTransportPortToConnectorList");
            }
        }
    }

    private static void removeConnectorSipEndpointFromList(Map<String, Object> sipEndpointProperties) throws UnknownHostException {
        String endpointHost = (String)sipEndpointProperties.get(HOST_ATTRIBUTE);
        String tcpPort = String.valueOf(sipEndpointProperties.get("sipTCPPort"));
        SipVirtualHostAdapter.removeHostTransportPortFromConnectorList(endpointHost, "TCP", tcpPort);
        String udpPort = String.valueOf(sipEndpointProperties.get("sipUDPPort"));
        SipVirtualHostAdapter.removeHostTransportPortFromConnectorList(endpointHost, "UDP", udpPort);
        String tlsPort = String.valueOf(sipEndpointProperties.get("sipTLSPort"));
        SipVirtualHostAdapter.removeHostTransportPortFromConnectorList(endpointHost, "TLS", tlsPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeHostTransportPortFromConnectorList(String host, String transport, String port) throws UnknownHostException {
        if (port == null || port.length() <= 0) {
            return;
        }
        Integer portInt = Integer.decode(port);
        Map<InetAddress, Map<String, HashSet<Integer>>> map = sipConnectorEndpoint;
        synchronized (map) {
            InetAddress iaHost = SipVirtualHostAdapter.normlizeHost(host);
            Map<String, HashSet<Integer>> transports = sipConnectorEndpoint.get(iaHost);
            if (transports == null) {
                return;
            }
            HashSet<Integer> ports = transports.get(transport);
            if (ports == null) {
                return;
            }
            ports.remove(portInt);
        }
    }

    private static InetAddress normlizeHost(String host) throws UnknownHostException {
        InetAddress iaHost;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "normlizeHost", (Object)host);
        }
        InetAddress inetAddress = iaHost = host.equals("*") || host.equals("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(host);
        if (iaHost.isLoopbackAddress()) {
            iaHost = InetAddress.getLocalHost();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "normlizeHost", iaHost);
        }
        return iaHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSipUriAConnectorInterface(SipURI uri) throws UnknownHostException {
        Map<InetAddress, Map<String, HashSet<Integer>>> map = sipConnectorEndpoint;
        synchronized (map) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)null, "isSipUriAConnectorInterface", (Object)uri);
            }
            boolean result = false;
            try {
                String transport;
                HashSet<Integer> ports;
                InetAddress iaHost = SipVirtualHostAdapter.normlizeHost(uri.getHost());
                Map<String, HashSet<Integer>> transports = sipConnectorEndpoint.get(iaHost);
                if (transports != null && (ports = transports.get(transport = (transport = uri.getTransportParam()) == null || transport.length() <= 0 ? "UDP" : transport.toUpperCase())) != null) {
                    boolean bl2 = result = ports.contains(uri.getPort());
                    return bl2;
                }
                result = false;
                boolean bl = false;
                return bl;
            }
            finally {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit(null, "isSipUriAConnectorInterface", result);
                }
            }
        }
    }

    public static void removeSipEndpointHostAliasesFromVH(Map<String, Object> sipEndpointProperties, boolean isSslEnabled, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] params = new Object[]{sipEndpointProperties, isSslEnabled};
            Tr.debug((TraceComponent)tc, (String)"Remove SIP endpoint host aliases from virtual host", (Object[])params);
        }
        SipVirtualHostAdapter.updateSipEndpointVirtualHostAliases(false, sipEndpointProperties, isSslEnabled, configAdminRef);
        SipVirtualHostAdapter.removeConnectorSipEndpointFromList(sipEndpointProperties);
    }

    public static void updateSipEndpointHostAliasesToVH(Map<String, Object> prevProperties, Map<String, Object> newProperties, boolean isSslEnabled, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] params = new Object[]{prevProperties, newProperties, isSslEnabled};
            Tr.debug((TraceComponent)tc, (String)"Update SIP endpoint host aliases to virtual host", (Object[])params);
        }
        SipVirtualHostAdapter.removeSipEndpointHostAliasesFromVH(prevProperties, isSslEnabled, configAdminRef);
        SipVirtualHostAdapter.addSipEndpointHostAliasesToVH(newProperties, isSslEnabled, configAdminRef);
    }

    private static void updateSipEndpointVirtualHostAliases(boolean add, Map<String, Object> properties, boolean isSslEnabled, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        String virtualHostPid = SipVirtualHostAdapter.getVirtualHostPidForSipEndpoint(properties, configAdminRef);
        List<String> hostAliasesFromEndpoint = SipVirtualHostAdapter.createHostAliasesFromEndpoint(properties, isSslEnabled);
        String defaultVirtualHostPid = SipVirtualHostAdapter.getVirtualHostPidForId(DEFAULT_VH_ID, configAdminRef);
        if (defaultVirtualHostPid.equals(virtualHostPid)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(virtualHostPid + " is " + DEFAULT_VH_ID), (Object[])new Object[0]);
            }
            SipVirtualHostAdapter.updateDefaultVirtualHost(add, hostAliasesFromEndpoint);
        } else {
            SipVirtualHostAdapter.updateNonDefaultVirtualHost(add, virtualHostPid, hostAliasesFromEndpoint, configAdminRef);
        }
    }

    private static void updateDefaultVirtualHost(boolean add, List<String> hostAliasesFromEndpoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] params = new Object[]{add, hostAliasesFromEndpoint};
            Tr.debug((TraceComponent)tc, (String)"updateDefaultVirtualHost", (Object[])params);
        }
        for (String ha : hostAliasesFromEndpoint) {
            VirtualHostAliasImpl vhai = new VirtualHostAliasImpl();
            vhai.init(ha);
            if (add) {
                if (s_defaultVH_hostAliases.contains(vhai)) continue;
                s_defaultVH_hostAliases.add(vhai);
                continue;
            }
            if (!s_defaultVH_hostAliases.contains(vhai)) continue;
            s_defaultVH_hostAliases.remove(vhai);
        }
    }

    public static void fillWithDefaultHostAliases(List<VirtualHostAlias> virtualHostAliases) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "fillWithDefaultHostAliases", "Adding to virtualHostAliases=" + Arrays.toString(virtualHostAliases.toArray()) + ", s_defaultVH_hostAliases=" + Arrays.toString(s_defaultVH_hostAliases.toArray()));
        }
        virtualHostAliases.addAll(s_defaultVH_hostAliases);
    }

    private static void updateNonDefaultVirtualHost(boolean add, String virtualHostPid, List<String> hostAliasesFromEndpoint, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        Configuration[] configs;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] params = new Object[]{add, virtualHostPid, hostAliasesFromEndpoint};
            Tr.debug((TraceComponent)tc, (String)"updateNonDefaultVirtualHost", (Object[])params);
        }
        if ((configs = SipVirtualHostAdapter.getVirtualHostConfiguration(virtualHostPid, configAdminRef)) != null) {
            for (Configuration configuration : configs) {
                String[] vhHostAliases = (String[])configuration.getProperties().get(HOST_ALIAS_ATTRIBUTE);
                List<String> vhHostAliasesAsList = SipVirtualHostAdapter.createVirtualHostAliasesToUpdate(add, vhHostAliases, hostAliasesFromEndpoint);
                if (vhHostAliasesAsList == null) continue;
                SipVirtualHostAdapter.updateVirtualHostAlisesConfiguration(configuration, vhHostAliasesAsList);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] params = new Object[]{add, virtualHostPid, hostAliasesFromEndpoint};
            Tr.debug((TraceComponent)tc, (String)"updateNonDefaultVirtualHost didn't update virtual host becasue it didn't find any configuration for SIP endpoint", (Object[])params);
        }
    }

    private static List<String> createVirtualHostAliasesToUpdate(boolean add, String[] vhHostAliases, List<String> hostAliasesFromEndpoint) {
        ArrayList<String> vhHostAliasesAsList = null;
        if (vhHostAliases == null) {
            if (add) {
                vhHostAliasesAsList = new ArrayList();
            }
        } else {
            vhHostAliasesAsList = new LinkedList<String>(Arrays.asList(vhHostAliases));
        }
        for (String hafe : hostAliasesFromEndpoint) {
            if (add) {
                if (vhHostAliasesAsList.contains(hafe)) continue;
                vhHostAliasesAsList.add(hafe);
                continue;
            }
            if (!vhHostAliasesAsList.contains(hafe)) continue;
            vhHostAliasesAsList.remove(hafe);
        }
        return vhHostAliasesAsList;
    }

    private static String getVirtualHostPidForId(String id, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        String virtualHostPid = null;
        String specificVHFilter = "(&" + FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)VH_FACTORY_PID) + FilterUtils.createPropertyFilter((String)"id", (String)id) + ")";
        Configuration[] sipConnectorConf = configAdminRef.listConfigurations(specificVHFilter);
        if (sipConnectorConf != null && sipConnectorConf.length == 1) {
            Dictionary properties = sipConnectorConf[0].getProperties();
            virtualHostPid = (String)properties.get(SERVICE_PID_ATTRIBUTE);
        }
        return virtualHostPid;
    }

    private static String getVirtualHostPidForSipEndpoint(Map<String, Object> sipEndpointProperties, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        String virtualHostPid = null;
        boolean isSipConnectorVH = SipVirtualHostAdapter.isSipConnectorReferenecedEndpoint(sipEndpointProperties, configAdminRef);
        if (isSipConnectorVH) {
            virtualHostPid = SipVirtualHostAdapter.getVirtualHostPidForId(SIP_CONNECTOR_VH_ID, configAdminRef);
        }
        if (virtualHostPid == null) {
            virtualHostPid = (String)sipEndpointProperties.get(VIRTUAL_HOST_REF_ATTRIBUTE);
        }
        return virtualHostPid;
    }

    public static boolean isVirtualHostExcludedFromComposition(String vhName) {
        return vhExcludedFromComposition.contains(vhName);
    }

    private static List<String> createHostAliasesFromEndpoint(Map<String, Object> sipEndpointProperties, boolean isSslEnabled) {
        String tlsPort;
        String tlsHostAlias;
        ArrayList<String> hostAliasesList = new ArrayList<String>();
        String endpointHost = (String)sipEndpointProperties.get(HOST_ATTRIBUTE);
        String tcpPort = String.valueOf(sipEndpointProperties.get("sipTCPPort"));
        String tcpHostAlias = VirtualHostAliasImpl.createHostAliasString(endpointHost, tcpPort);
        hostAliasesList.add(tcpHostAlias);
        String udpPort = String.valueOf(sipEndpointProperties.get("sipUDPPort"));
        String udpHostAlias = VirtualHostAliasImpl.createHostAliasString(endpointHost, udpPort);
        if (!tcpHostAlias.equals(udpHostAlias)) {
            hostAliasesList.add(udpHostAlias);
        }
        if (isSslEnabled && !(tlsHostAlias = VirtualHostAliasImpl.createHostAliasString(endpointHost, tlsPort = String.valueOf(sipEndpointProperties.get("sipTLSPort")))).equals(tcpHostAlias) && !tlsHostAlias.equals(udpHostAlias)) {
            hostAliasesList.add(tlsHostAlias);
        }
        return hostAliasesList;
    }

    private static boolean isSipConnectorReferenecedEndpoint(Map<String, Object> sipEndpointProperties, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        String endpointPid = String.valueOf(sipEndpointProperties.get(SERVICE_PID_ATTRIBUTE));
        String allVHFilter = "(&" + FilterUtils.createPropertyFilter((String)SERVICE_PID_ATTRIBUTE, (String)RTCOMM_CONNECTOR_FACTORY_PID) + ")";
        Configuration[] configs = configAdminRef.listConfigurations(allVHFilter);
        if (configs != null) {
            for (Configuration configuration : configs) {
                Set<String> flatSipConnectorConfPropeties = SipVirtualHostAdapter.getFlatSipConnectorReferenceProperties(configuration.getProperties());
                for (String property : flatSipConnectorConfPropeties) {
                    String[] sipEndpointPidRefs = (String[])configuration.getProperties().get(property);
                    if (sipEndpointPidRefs == null) continue;
                    for (String sipEndpointPidRef : sipEndpointPidRefs) {
                        if (!sipEndpointPidRef.equals(endpointPid)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static Set<String> getFlatSipConnectorReferenceProperties(Dictionary<String, Object> rtcommConnectorProperties) {
        HashSet<String> allowFromProperties = new HashSet<String>();
        Enumeration<String> iter = rtcommConnectorProperties.keys();
        while (iter.hasMoreElements()) {
            String property = iter.nextElement();
            if (!property.startsWith(SIP_CONNECTOR_PREFIX) || !property.endsWith(ALLOW_FROM_SIPENDPOINT_REF_SUFFIX)) continue;
            allowFromProperties.add(property);
        }
        return allowFromProperties;
    }

    private static Configuration[] getVirtualHostConfiguration(String virtualHostPid, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        String specificVHFilter = "(&" + FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)VH_FACTORY_PID) + FilterUtils.createPropertyFilter((String)SERVICE_PID_ATTRIBUTE, (String)virtualHostPid) + ")";
        return configAdminRef.listConfigurations(specificVHFilter);
    }

    private static void updateVirtualHostAlisesConfiguration(Configuration configuration, List<String> vhHostAliasesAsList) throws IOException {
        Object[] listToArray = vhHostAliasesAsList.toArray();
        String[] vhHostAliases = (String[])Arrays.copyOf(listToArray, listToArray.length, String[].class);
        Dictionary dict = configuration.getProperties();
        dict.put(HOST_ALIAS_ATTRIBUTE, vhHostAliases);
        configuration.update(dict);
    }

    private static void createSipConnectorVirtualHost(Map<String, Object> sipEndpointProperties, boolean isSslEnabled, ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object[] params = new Object[]{sipEndpointProperties, isSslEnabled};
            Tr.debug((TraceComponent)tc, (String)"Creates SIP connector virtual host for SIP endpoint", (Object[])params);
        }
        List<String> hostAliasesFromEndpoint = SipVirtualHostAdapter.createHostAliasesFromEndpoint(sipEndpointProperties, isSslEnabled);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("id", SIP_CONNECTOR_VH_ID);
        props.put("config.displayId", "virtualHost[sipUA_VH]");
        props.put("config.id", "com.ibm.ws.http.virtualhost[sipUA_VH]");
        props.put("enabled", "true");
        String virtualHostBundle = SipVirtualHostAdapter.getVirtualHostBundleLocation(configAdminRef);
        Configuration vhConfig = configAdminRef.createFactoryConfiguration(VH_FACTORY_PID, virtualHostBundle);
        Object[] listToArray = hostAliasesFromEndpoint.toArray();
        String[] vhHostAliases = (String[])Arrays.copyOf(listToArray, listToArray.length, String[].class);
        for (String ha : hostAliasesFromEndpoint) {
            VirtualHostAliasImpl vhai = new VirtualHostAliasImpl();
            vhai.init(ha);
            if (s_sipConnectorVH_hostAliases.contains(vhai)) continue;
            s_sipConnectorVH_hostAliases.add(vhai);
        }
        props.put(HOST_ALIAS_ATTRIBUTE, vhHostAliases);
        vhConfig.update(props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Finish to create SIP connector virtual host for SIP endpoint", (Object[])new Object[]{props});
        }
    }

    private static String getVirtualHostBundleLocation(ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        String defaultVirtualHostBundleLocation = null;
        String specificVHFilter = "(&" + FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)VH_FACTORY_PID) + FilterUtils.createPropertyFilter((String)"id", (String)DEFAULT_VH_ID) + ")";
        Configuration[] sipConnectorConf = configAdminRef.listConfigurations(specificVHFilter);
        if (sipConnectorConf != null && sipConnectorConf.length == 1) {
            defaultVirtualHostBundleLocation = sipConnectorConf[0].getBundleLocation();
        }
        return defaultVirtualHostBundleLocation;
    }

    private static boolean isExistSipUaVirtualHost(ConfigurationAdmin configAdminRef) throws IOException, InvalidSyntaxException {
        String vhPid = SipVirtualHostAdapter.getVirtualHostPidForId(SIP_CONNECTOR_VH_ID, configAdminRef);
        return vhPid != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHostAliasMatchVirtualHost(VirtualHostAlias vha, SipAppDesc app) {
        List<VirtualHostAlias> virtualHostAliasesList;
        String vhName = app.getVirtualHostName();
        if (DEFAULT_VH_ID.equals(vhName)) {
            virtualHostAliasesList = s_defaultVH_hostAliases;
        } else {
            virtualHostAliasesList = app.getVirtualHostAliases();
            if (virtualHostAliasesList == null || virtualHostAliasesList.size() == 0) {
                virtualHostAliasesList = s_sipConnectorVH_hostAliases;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Using locally generated rtcomm gateway's hosts alias list", (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Searching for alias in VH " + app.getVirtualHostName() + " to match host=" + vha.getHost() + ", port=" + vha.getPort()), (Object[])new Object[0]);
        }
        List<VirtualHostAlias> list = virtualHostAliasesList;
        synchronized (list) {
            for (int i = 0; i < virtualHostAliasesList.size(); ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Module virtual host = " + virtualHostAliasesList.get(i)), (Object[])new Object[0]);
                }
                if (!virtualHostAliasesList.get(i).match(vha)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        vhExcludedFromComposition.add(SIP_CONNECTOR_VH_ID);
    }
}

