/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.sip.stack.transport.netty.GenericChain;
import com.ibm.ws.sip.stack.transport.sip.SipChannelFactory;
import com.ibm.ws.sip.stack.transport.sip.netty.SIPConnectionFactoryImplWs;
import com.ibm.ws.sip.stack.transport.sip.netty.SipInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.netty.SipTcpInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.netty.SipTlsInboundChannel;
import com.ibm.ws.sip.stack.transport.sip.netty.SipUdpInboundChannel;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryPropertyIgnoredException;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.util.Map;

public class SipInboundChannelFactoryWs
extends SipChannelFactory {
    private static final TraceComponent tc = Tr.register(SipInboundChannelFactoryWs.class);
    public static final String ACCEPTOR_ID = SipInboundChannelFactoryWs.class.getName();
    private static int s_chains = 0;

    public ListeningPoint initChannel(GenericChain chain) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"initChannel", (Object[])new Object[]{chain});
        }
        String transport = chain.getTransport();
        ListeningPoint lp = this.createListeningPoint(chain);
        String chainNumber = String.valueOf(s_chains++);
        SipInboundChannel channel = null;
        String outboundChainName = null;
        switch (chain.getType()) {
            case UDP: {
                outboundChainName = "UdpOutboundChain_" + chainNumber;
                channel = SipUdpInboundChannel.instance(lp, outboundChainName);
                break;
            }
            case TCP: {
                outboundChainName = "TcpOutboundChain_" + chainNumber;
                channel = new SipTcpInboundChannel(lp, outboundChainName);
                break;
            }
            case TLS: {
                outboundChainName = "TcpOutboundChain_" + chainNumber;
                channel = new SipTlsInboundChannel(lp, outboundChainName);
            }
        }
        try {
            SIPConnectionFactoryImplWs.instance().addListeningConnection(lp, channel, chain.getChainName());
            return lp;
        }
        catch (IOException e2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed creating a connection", (Object[])new Object[]{e2});
            }
            return null;
        }
    }

    private ListeningPoint createListeningPoint(GenericChain chain) {
        String host = chain.getActiveHost();
        if (host.equals("*")) {
            host = "0.0.0.0";
        }
        return new ListeningPointImpl(host, chain.getActivePort(), chain.getTransport(), chain.getChainName());
    }

    public Channel findOrCreateChannel(ChannelData config) throws ChannelException {
        return null;
    }

    public void updateProperties(Map<Object, Object> properties) throws ChannelFactoryPropertyIgnoredException {
    }

    public Map<Object, Object> getProperties() {
        return null;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map<Object, Object> props) {
        return null;
    }
}

