/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.chfw;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.dispatch.Dispatcher;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transport.sip.chfw.SipConnLink;
import com.ibm.ws.sip.stack.transport.sip.chfw.SipInboundChannel;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public abstract class SipInboundConnLink
extends SipConnLink {
    private static final TraceComponent tc = Tr.register(SipInboundConnLink.class);
    private boolean m_initialized = false;

    public SipInboundConnLink(SipInboundChannel channel) {
        super(channel);
    }

    protected void init(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"init", (Object[])new Object[]{"vc [" + vc + ']'});
        }
        this.setVirtualConnection(vc);
        TCPConnectionContext connectionContext = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        InetAddress remoteAddress = connectionContext.getRemoteAddress();
        int remotePort = connectionContext.getRemotePort();
        InetSocketAddress address = new InetSocketAddress(remoteAddress, remotePort);
        this.setRemoteAddress(address);
        SIPListenningConnection listener = this.getSIPListenningConnection();
        Dispatcher.instance().queueConnectionAcceptedEvent(listener, this);
        this.connectionEstablished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready(VirtualConnection vc) {
        if (!this.m_initialized) {
            SipInboundConnLink sipInboundConnLink = this;
            synchronized (sipInboundConnLink) {
                if (!this.m_initialized) {
                    this.m_initialized = true;
                    this.init(vc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(VirtualConnection vc, TCPReadRequestContext readCtx) {
        if (!this.m_initialized) {
            SipInboundConnLink sipInboundConnLink = this;
            synchronized (sipInboundConnLink) {
                if (!this.m_initialized) {
                    this.m_initialized = true;
                    this.init(vc);
                }
            }
        }
        super.complete(vc, readCtx);
    }

    @Override
    public void connect() throws IOException {
        throw new IOException("connect should not be called for inbound connection");
    }
}

