/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.netty;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.stack.transport.ActiveConfiguration;
import com.ibm.ws.sip.stack.transport.GenericChainBase;
import com.ibm.ws.sip.stack.transport.GenericEndpointImpl;
import com.ibm.ws.sip.stack.transport.sip.netty.SipInboundChannelFactoryWs;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.ServerBootstrapExtended;
import io.openliberty.netty.internal.exception.NettyException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class GenericChain
extends GenericChainBase {
    private static final LogMgr c_logger = Log.get(GenericChain.class);
    protected static final String LOCALHOST = "localhost";
    protected static final String ID = "id";
    protected static String SIP_Channel = "SIPChannel_";
    protected static String CHAIN = "Chain";
    protected static int s_chains = 0;
    protected String endpointName;
    protected String sipChannelName;
    protected String chainName;
    protected volatile boolean enabled = false;
    protected volatile ActiveConfiguration currentConfig = null;
    protected final GenericEndpointImpl owner;
    protected NettyFramework nettyBundle;
    protected ServerBootstrapExtended serverBootstrap;
    protected BootstrapExtended bootstrap;
    protected SipInboundChannelFactoryWs sipInboundChannelFactory = new SipInboundChannelFactoryWs();

    protected void activate(Map<String, Object> properties) throws NettyException {
    }

    protected void deactivate(Map<String, Object> properties, int reason) {
        this.serverBootstrap = null;
        this.bootstrap = null;
    }

    public GenericChain(GenericEndpointImpl owner) {
        this.owner = owner;
    }

    protected String getEndpointName() {
        return this.endpointName;
    }

    public void init(String endpointId, Object componentId, NettyFramework nettyBundle, String name) {
        String chainNumber = String.valueOf(s_chains++);
        this.nettyBundle = nettyBundle;
        this.endpointName = endpointId;
        this.sipChannelName = SIP_Channel + this.getName() + "_" + endpointId + "_" + chainNumber;
        this.chainName = CHAIN + endpointId + "_" + chainNumber;
    }

    public String getChainName() {
        return this.chainName;
    }

    @Override
    public void enable() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("enable chain " + this);
        }
        this.enabled = true;
    }

    public void disable() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("disable chain " + this);
        }
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected GenericEndpointImpl getOwner() {
        return this.owner;
    }

    @Override
    public int getActivePort() {
        ActiveConfiguration cfg = this.currentConfig;
        if (cfg != null) {
            return cfg.getActivePort();
        }
        return -1;
    }

    @Override
    public String getActiveHost() {
        ActiveConfiguration cfg = this.currentConfig;
        if (cfg != null) {
            return cfg.getConfigHost();
        }
        return null;
    }

    @Override
    protected abstract void setupEventProps(Map<String, Object> var1);

    @Override
    protected abstract ActiveConfiguration createActiveConfiguration();

    @Override
    protected abstract void rebuildTheChannel(ActiveConfiguration var1, ActiveConfiguration var2);

    protected ActiveConfiguration getCurrentConfig() {
        return this.currentConfig;
    }

    protected void setCurrentConfig(ActiveConfiguration currentConfig) {
        this.currentConfig = currentConfig;
    }

    @Override
    public synchronized void update() {
        if (c_logger.isEventEnabled()) {
            c_logger.event("update chain " + this, new Object[0]);
        }
        if (!this.isEnabled() || FrameworkState.isStopping()) {
            return;
        }
        ActiveConfiguration oldConfig = this.getCurrentConfig();
        boolean validOldConfig = oldConfig == null ? false : oldConfig.validConfiguration;
        ActiveConfiguration newConfig = this.createActiveConfiguration();
        if (newConfig.configPort < 0 || !newConfig.isReady()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Stopping chain due to configuration " + newConfig);
            }
            this.setCurrentConfig(newConfig);
            return;
        }
        if (validOldConfig && newConfig.unchanged(oldConfig)) {
            int port;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Configuration is unchanged " + newConfig);
            }
            if ((port = newConfig.getActivePort()) == oldConfig.getActivePort() && port != -1) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Chain is already started " + oldConfig);
                }
                return;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Existing config must be started " + newConfig);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("New/changed chain configuration " + newConfig);
        }
        if (validOldConfig) {
            this.rebuildTheChannel(oldConfig, newConfig);
        } else {
            this.createChannels(newConfig);
        }
        this.setCurrentConfig(newConfig);
        this.currentConfig.validConfiguration = true;
    }

    public synchronized void chainStarted() {
        ActiveConfiguration cfg;
        int port;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Chain " + this.toString() + " is started");
        }
        if ((port = (cfg = this.currentConfig).getActivePort()) > 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("New configuration started " + cfg);
            }
            String topic = this.owner.getEventTopic() + "/STARTED";
            this.postEvent(topic, cfg, null);
        }
    }

    protected void postEvent(String t, ActiveConfiguration c, Exception e2) {
        EventAdmin engine;
        HashMap<String, Object> eventProps = new HashMap<String, Object>(4);
        if (c.activeHost != null) {
            eventProps.put("activeHost", c.activeHost);
        }
        eventProps.put("activePort", c.configPort);
        eventProps.put("configHost", c.configHost);
        eventProps.put("configPort", c.configPort);
        this.setupEventProps(eventProps);
        if (e2 != null) {
            eventProps.put("exception", e2.toString());
        }
        if ((engine = GenericEndpointImpl.getEventAdmin()) != null) {
            Event event = new Event(t, eventProps);
            engine.postEvent(event);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[@=" + System.identityHashCode(this) + ",enabled=" + this.enabled + ",chainName=" + this.chainName + ",config=" + this.currentConfig + "]";
    }

    @Override
    protected void createChannels(ActiveConfiguration newConfig) {
    }

    @Override
    public void stop() {
    }
}

