/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transactions.st;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.sip.stack.dispatch.TimerEvent;
import com.ibm.ws.sip.stack.transaction.SIPStackConfiguration;
import com.ibm.ws.sip.stack.transaction.SIPTransactionConstants;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transactions.BranchMethodKey;
import com.ibm.ws.sip.stack.transaction.transactions.MergedRequestKey;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionHelper;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPServerTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transport.SIPTransportException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.TimeStampHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;

public class SIPInviteServerTransactionImpl
extends SIPServerTransactionImpl {
    public static final int STATE_PROCEEDING = 0;
    public static final int STATE_COMPLETED = 1;
    public static final int STATE_CONFIRMED = 2;
    public static final int STATE_TERMINATED = 3;
    TimerH m_timerH;
    TimerI m_timerI;
    TimerG m_timerG;
    private Response m_mostRecentProvisionalResponse;
    private Response m_finalResponse;
    private static final LogMgr c_logger = Log.get(SIPInviteServerTransactionImpl.class);

    public SIPInviteServerTransactionImpl(SIPTransactionStack transactionStack, SipProvider provider, Request req, BranchMethodKey key, MergedRequestKey mergedRequestKey) {
        super(transactionStack, provider, req, key, mergedRequestKey);
    }

    @Override
    public synchronized void processRequest(Request sipRequest) throws SipParseException {
        try {
            switch (this.getState()) {
                case -1: {
                    this.setState(0);
                    if (this.getParentStack().getConfiguration().isAuto100OnInvite()) {
                        this.m_mostRecentProvisionalResponse = this.createTryingResponse(sipRequest);
                        this.sendResponseToTransport(this.m_mostRecentProvisionalResponse);
                    }
                    this.sendRequestToUA(sipRequest);
                    break;
                }
                case 0: {
                    if (this.m_mostRecentProvisionalResponse == null) break;
                    this.sendResponseToTransport(this.m_mostRecentProvisionalResponse);
                    break;
                }
                case 1: {
                    if ("INVITE".equals(sipRequest.getCSeqHeader().getMethod())) {
                        if (this.m_finalResponse == null) break;
                        this.sendResponseToTransport(this.m_finalResponse);
                        break;
                    }
                    if (!"ACK".equals(sipRequest.getCSeqHeader().getMethod())) break;
                    if (!this.isTransportReliable()) {
                        long delay = this.getParentStack().getConfiguration().getTimerI();
                        this.m_timerI = new TimerI(this, this.getCallId());
                        this.addTimerTask(this.m_timerI, delay);
                        this.setState(2);
                        break;
                    }
                    this.destroyTransaction();
                    break;
                }
                case 2: {
                    if (!c_logger.isTraceDebugEnabled()) break;
                    c_logger.traceDebug("SIP INVITE Transaction Error - Got ACK in CONFIRMED state");
                    break;
                }
                case 3: {
                    if (null == this.m_finalResponse) break;
                    if ("INVITE".equals(sipRequest.getMethod())) {
                        this.sendResponseToTransport(this.m_finalResponse);
                        break;
                    }
                    if (!"ACK".equals(sipRequest.getMethod())) break;
                    this.sendRequestToUA(sipRequest, -1L);
                }
            }
        }
        catch (SIPTransportException exp) {
            this.prossesTransportError();
        }
    }

    @Override
    public synchronized void processResponse(Response sipResponse) throws SipParseException {
        try {
            switch (this.getState()) {
                case 0: {
                    if (SIPTransactionHelper.isProvionalResponse(sipResponse.getStatusCode())) {
                        this.m_mostRecentProvisionalResponse = sipResponse;
                        this.sendResponseToTransport(sipResponse);
                        break;
                    }
                    if (SIPTransactionHelper.isOKFinalResponse(sipResponse.getStatusCode())) {
                        this.m_finalResponse = sipResponse;
                        this.destroyTransaction();
                        this.sendResponseToTransport(sipResponse);
                        break;
                    }
                    if (!SIPTransactionHelper.isNonOkFinalResponse(sipResponse.getStatusCode())) break;
                    this.m_finalResponse = sipResponse;
                    this.setCompletedState();
                    this.sendResponseToTransport(sipResponse);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
        catch (SIPTransportException exp) {
            this.prossesTransportError();
        }
    }

    @Override
    public synchronized void prossesTransportError() {
        this.notifyRespnseErrorToUA(this.getMostRecentResponse());
        this.destroyTransaction();
    }

    private void setCompletedState() {
        long delay;
        SIPStackConfiguration config = this.getParentStack().getConfiguration();
        if (!this.isTransportReliable()) {
            delay = config.getTimerG();
            this.m_timerG = new TimerG(1L, this, this.getCallId());
            this.addTimerTask(this.m_timerG, delay);
        }
        delay = config.getTimerH();
        this.m_timerH = new TimerH(this, this.getCallId());
        this.addTimerTask(this.m_timerH, delay);
        this.setState(1);
    }

    synchronized void timerGfired(long interval) {
        block5: {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "timerGfired", "Timer G fired on transaction " + this.toString());
            }
            this.updateSipTimersInvocationsPMICounter();
            if (this.getState() == 1) {
                try {
                    double aDelay = Math.min(Math.pow(2.0, interval - 1L) * (double)SIPTransactionConstants.T1, (double)SIPTransactionConstants.T2);
                    if (c_logger.isTraceDebugEnabled()) {
                        StringBuffer buf = new StringBuffer(256);
                        buf.append("Resending message. Retransmission [");
                        buf.append(interval);
                        buf.append("]. Next resend in [");
                        buf.append(aDelay);
                        buf.append("] milliseconds");
                        c_logger.traceDebug(this, "timerGfired", buf.toString());
                    }
                    this.sendResponseToTransport(this.getMostRecentResponse());
                    this.m_timerG = new TimerG(interval + 1L, this, this.getCallId());
                    this.addTimerTask(this.m_timerG, (long)aDelay);
                }
                catch (SIPTransportException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block5;
                    c_logger.traceDebug(this, "timerGfired", e2.getMessage());
                }
            }
        }
    }

    void timerHfired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerHfired", "Timer H fired on transaction " + this.toString());
        }
        this.updateSipTimersInvocationsPMICounter();
        if (this.getState() == 1) {
            this.notifyTimeOutToUA();
            this.destroyTransaction();
        }
    }

    void timerIfired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerIfired", "Timer I fired on transaction " + this.toString());
        }
        this.updateSipTimersInvocationsPMICounter();
        if (this.getState() == 2) {
            this.notifyTimeOutToUA();
            this.destroyTransaction();
        }
    }

    void timerCleanupTimerFired() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timerCleanupTimerFired", "Timer CleanupTimer fired on transaction " + this.toString());
        }
        this.remove();
    }

    @Override
    public Response getMostRecentResponse() {
        Response retVal = null;
        if (this.m_finalResponse != null) {
            retVal = this.m_finalResponse;
        } else if (this.m_mostRecentProvisionalResponse != null) {
            retVal = this.m_mostRecentProvisionalResponse;
        }
        return retVal;
    }

    private Response createTryingResponse(Request req) throws SipParseException {
        Response response = SipJainFactories.getInstance().getMesssageFactory().createResponse(100, req);
        TimeStampHeader timeStamp = req.getTimeStampHeader();
        if (timeStamp != null) {
            response.setTimeStampHeader(timeStamp);
        }
        return response;
    }

    @Override
    public void destroyTransaction() {
        boolean is2xxUnreliableResponse;
        block9: {
            if (this.getState() == 3) {
                return;
            }
            this.setState(3);
            if (this.m_timerG != null) {
                this.m_timerG.cancel();
            }
            if (this.m_timerH != null) {
                this.m_timerH.cancel();
            }
            if (this.m_timerI != null) {
                this.m_timerI.cancel();
            }
            is2xxUnreliableResponse = false;
            try {
                if (!this.isTransportReliable() && this.m_finalResponse != null && SIPTransactionHelper.isOKFinalResponse(this.m_finalResponse.getStatusCode())) {
                    is2xxUnreliableResponse = true;
                }
            }
            catch (SipParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block9;
                c_logger.traceDebug(this, "destroyTransaction", e2.getMessage());
            }
        }
        if (!is2xxUnreliableResponse) {
            this.remove();
        } else {
            int delay = this.getParentStack().getConfiguration().getInviteServerTransactionTimer();
            this.addTimerTask(new CleanupTimer(this, this.getCallId()), delay);
        }
    }

    @Override
    protected boolean is2543RequestPartOfTransaction(Request req, ViaHeader oldVia, ViaHeader newVia) {
        boolean match;
        String newMethod;
        String newFromTag;
        URI newRequestURI;
        URI oldRequestURI;
        Request initial = this.getFirstRequest();
        String oldFromTag = initial.getFromHeader().getTag();
        if (oldFromTag == null) {
            oldFromTag = "";
        }
        CallIdHeader oldCallId = initial.getCallIdHeader();
        CSeqHeader oldCSeq = initial.getCSeqHeader();
        try {
            oldRequestURI = initial.getRequestURI();
            newRequestURI = req.getRequestURI();
        }
        catch (SipParseException e2) {
            return false;
        }
        String newToTag = req.getToHeader().getTag();
        if (newToTag == null) {
            newToTag = "";
        }
        if ((newFromTag = req.getFromHeader().getTag()) == null) {
            newFromTag = "";
        }
        CallIdHeader newCallId = req.getCallIdHeader();
        CSeqHeader newCSeq = req.getCSeqHeader();
        try {
            newMethod = req.getMethod();
        }
        catch (SipParseException e3) {
            return false;
        }
        if (newMethod.equals("INVITE")) {
            String oldToTag = initial.getToHeader().getTag();
            if (oldToTag == null) {
                oldToTag = "";
            }
            match = newRequestURI.equals(oldRequestURI) && newToTag.equals(oldToTag) && newFromTag.equals(oldFromTag) && newCallId.equals(oldCallId) && newCSeq.equals(oldCSeq) && newVia.equals(oldVia);
        } else if (newMethod.equals("ACK")) {
            String oldToTag;
            String string = oldToTag = this.m_finalResponse == null ? null : this.m_finalResponse.getToHeader().getTag();
            if (oldToTag == null) {
                oldToTag = "";
            }
            match = newRequestURI.equals(oldRequestURI) && newFromTag.equals(oldFromTag) && newCallId.equals(oldCallId) && newCSeq.getSequenceNumber() == oldCSeq.getSequenceNumber() && newVia.equals(oldVia) && newToTag.equals(oldToTag);
        } else {
            match = false;
        }
        return match;
    }

    @Override
    public LogMgr getLoger() {
        return c_logger;
    }

    @Override
    protected String getType() {
        return "Server INVITE";
    }

    @Override
    public String getStateAsString() {
        switch (this.getState()) {
            case 0: {
                return "Proceeding";
            }
            case 1: {
                return "Completed";
            }
            case 2: {
                return "Confirmed";
            }
            case 3: {
                return "Terminated";
            }
        }
        return super.getStateAsString();
    }

    static class TimerI
    extends TimerEvent {
        SIPInviteServerTransactionImpl m_st;

        TimerI(SIPInviteServerTransactionImpl st, String callId) {
            super(callId);
            this.m_st = st;
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }

        @Override
        public void onExecute() {
            this.m_st.timerIfired();
        }
    }

    static class TimerG
    extends TimerEvent {
        private long m_interval;
        SIPInviteServerTransactionImpl m_st;

        TimerG(long interval, SIPInviteServerTransactionImpl st, String callId) {
            super(callId);
            this.m_interval = interval;
            this.m_st = st;
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }

        @Override
        public void onExecute() {
            this.m_st.timerGfired(this.m_interval);
        }
    }

    static class TimerH
    extends TimerEvent {
        SIPInviteServerTransactionImpl m_st;

        TimerH(SIPInviteServerTransactionImpl st, String callId) {
            super(callId);
            this.m_st = st;
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }

        @Override
        public void onExecute() {
            this.m_st.timerHfired();
        }
    }

    static class CleanupTimer
    extends TimerEvent {
        SIPInviteServerTransactionImpl m_st;

        CleanupTimer(SIPInviteServerTransactionImpl st, String callId) {
            super(callId);
            this.m_st = st;
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }

        @Override
        public void onExecute() {
            this.m_st.timerCleanupTimerFired();
        }
    }
}

