/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersImpl;
import com.ibm.ws.sip.container.servlets.BaseURI;
import com.ibm.ws.sip.container.servlets.URIImpl;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.URI;
import java.util.Iterator;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.TelURL;

public class TelURLImpl
extends URIImpl
implements TelURL,
BaseURI {
    private static final LogMgr c_logger = Log.get(TelURLImpl.class);
    private boolean m_isGlobal;
    private String m_phoneNumber;
    private ParametersImpl m_params = new ParametersImpl();
    private static final String TEL = "tel";
    private static final String FAX = "fax";
    private static final String MODEM = "modem";

    public TelURLImpl(URI jainURI) {
        super(jainURI);
        try {
            this.parse(jainURI.getSchemeData(), false);
        }
        catch (ServletParseException servletParseException) {
            // empty catch block
        }
    }

    public TelURLImpl(URI jainURI, boolean mayThrow) throws ServletParseException {
        super(jainURI);
        this.parse(jainURI.getSchemeData(), mayThrow);
    }

    private void parse(String jainURI, boolean mayThrow) throws ServletParseException {
        block3: {
            try {
                this.parse(jainURI);
            }
            catch (ServletParseException e2) {
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{jainURI};
                    c_logger.error("error.invalid.tel.url", "Create", args, (Throwable)((Object)e2));
                }
                if (!mayThrow) break block3;
                throw e2;
            }
        }
    }

    private void parse(String url) throws ServletParseException {
        if (null == url) {
            throw new ServletParseException("null URL");
        }
        int length = url.length();
        int position = this.parseIsGlobal(url);
        if (position >= length) {
            throw new ServletParseException("unexpected end of URL [" + url + ']');
        }
        position = this.parsePhoneNumber(url, position, this.isGlobal());
        if ((position = this.parseParam(url, position)) != length) {
            throw new ServletParseException("unexpected character in URL [" + url + "] at position [" + position + ']');
        }
    }

    private int parseParam(String url, int position) throws ServletParseException {
        String name;
        char c;
        int length = url.length();
        int i = position;
        while (i < length && (c = url.charAt(i)) == ';' && (name = TelURLImpl.token(url, ++i)) != null) {
            String value;
            if ((i += name.length()) < length) {
                c = url.charAt(i);
                if (c == '=') {
                    if ((value = TelURLImpl.token(url, ++i)) == null) break;
                    i += value.length();
                } else {
                    value = "";
                }
            } else {
                value = "";
            }
            if (!this.m_params.hasParameter(name)) {
                this.setParameterInt(name, value);
                continue;
            }
            throw new ServletParseException("duplicate parameter [" + name + "] in URL [" + url + ']');
        }
        return i;
    }

    private static String token(String url, int position) {
        char c;
        int i;
        int length = url.length();
        for (i = position; i < length && ((c = url.charAt(i)) == '!' || '#' <= c && c <= '\'' || '*' <= c && c <= '+' || '-' <= c && c <= '.' || '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || '^' <= c && c <= 'z' || c == '|' || c == '~'); ++i) {
        }
        if (i == position) {
            return null;
        }
        return url.substring(position, i);
    }

    private int parsePhoneNumber(String url, int position, boolean isGlobal) throws ServletParseException {
        int i;
        int length = url.length();
        block4: for (i = position; i < length; ++i) {
            char c = url.charAt(i);
            switch (c) {
                case '#': 
                case '(': 
                case ')': 
                case '*': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'P': 
                case 'W': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'p': 
                case 'w': {
                    continue block4;
                }
                case 'E': 
                case 'F': 
                case 'e': 
                case 'f': {
                    if (!isGlobal) continue block4;
                    throw new ServletParseException("invalid number in tel URL [" + url + ']');
                }
            }
        }
        if (i == position) {
            throw new ServletParseException("invalid number in tel URL [" + url + ']');
        }
        this.m_phoneNumber = url.substring(position, i);
        return i;
    }

    private int parseIsGlobal(String url) throws ServletParseException {
        boolean bl = this.m_isGlobal = url.charAt(0) == '+';
        if (this.m_isGlobal) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getPhoneNumber() {
        return this.m_phoneNumber;
    }

    @Override
    public boolean isGlobal() {
        return this.m_isGlobal;
    }

    @Override
    public String getParameter(String key) {
        super.getParameter(key);
        return this.m_params.getParameter(key);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return this.m_params.getParameters();
    }

    @Override
    public String getScheme() {
        return this.getJainURI().getScheme();
    }

    @Override
    public boolean isSipURI() {
        return false;
    }

    @Override
    public javax.servlet.sip.URI clone() {
        TelURLImpl cloned = null;
        cloned = (TelURLImpl)super.clone();
        cloned.m_isGlobal = this.m_isGlobal;
        cloned.m_phoneNumber = this.m_phoneNumber;
        cloned.m_params = (ParametersImpl)this.m_params.clone();
        return cloned;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return this.getJainURI().toString();
    }

    @Override
    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj instanceof TelURLImpl) {
            TelURLImpl tel = (TelURLImpl)obj;
            if (this.getJainURI().getScheme().equals(tel.getJainURI().getScheme()) && tel.m_isGlobal == this.m_isGlobal && this.m_phoneNumber.equals(tel.m_phoneNumber) && this.m_params.equals(tel.m_params)) {
                rc = true;
            }
        }
        return rc;
    }

    public static boolean isSchemeSupported(String scheme) {
        boolean rc = false;
        if (scheme.equalsIgnoreCase(TEL) || scheme.equalsIgnoreCase(FAX) || scheme.equalsIgnoreCase(MODEM)) {
            rc = true;
        }
        return rc;
    }

    private void setParameterInt(String name, String value) throws IllegalArgumentException {
        try {
            this.m_params.setParameter(name, value);
        }
        catch (SipParseException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public void setParameter(String name, String value) throws IllegalArgumentException {
        super.setParameter(name, value);
        this.setParameterInt(name, value);
        this.writeChangesToJain();
    }

    @Override
    public void removeParameter(String name) {
        this.m_params.removeParameter(name);
        this.writeChangesToJain();
    }

    private void setPhoneNumberInt(String number, boolean global) throws IllegalArgumentException {
        try {
            int position = this.parseIsGlobal(number);
            if (this.isGlobal() != global) {
                throw new IllegalArgumentException("invalid number in tel URL [" + number + ']');
            }
            position = this.parsePhoneNumber(number, position, global);
            this.m_isGlobal = global;
            if (position < number.length()) {
                throw new IllegalArgumentException("invalid number in tel URL [" + number + ']');
            }
        }
        catch (ServletParseException e2) {
            throw new IllegalArgumentException("invalid number in tel URL [" + number + ']');
        }
    }

    @Override
    public String getPhoneContext() {
        return this.getParameter("phone-context");
    }

    @Override
    public void setPhoneNumber(String number, String phoneContext) throws IllegalArgumentException {
        this.setPhoneNumberInt(number, false);
        this.setParameterInt("phone-context", phoneContext);
        this.writeChangesToJain();
    }

    @Override
    public void setPhoneNumber(String number) throws IllegalArgumentException {
        this.setPhoneNumberInt(number, true);
        this.writeChangesToJain();
    }

    private void writeChangesToJain() throws IllegalArgumentException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "writeChangesToJain");
        }
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        try {
            if (this.m_phoneNumber != null) {
                if (this.isGlobal()) {
                    buffer.append('+');
                }
                buffer.append(this.m_phoneNumber);
                if (this.m_params != null && this.m_params.size() > 0) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "writeChangesToJain", "adds ';' separator sign after phone number");
                    }
                    buffer.append(';');
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "writeChangesToJain", "no params in list");
                }
            }
            this.m_params.encode(buffer, ';', false);
            String str = buffer.toString();
            this.getJainURI().setSchemeData(str);
        }
        catch (SipParseException e2) {
            throw new IllegalArgumentException(e2);
        }
        finally {
            CharsBuffersPool.putBufferBack(buffer);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "writeChangesToJain", this);
        }
    }
}

