/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl.netty;

import com.ibm.ws.sip.channel.resolver.dns.impl.netty.Dns;
import com.ibm.ws.sip.channel.resolver.dns.impl.netty.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.netty.ResourceRecord;
import io.netty.buffer.ByteBuf;

public class OPTRecord
extends ResourceRecord {
    private short _UDPpayloadSize;
    private byte _extendedRCODE;
    private byte _version;
    private short _Z;
    private short _optionCode;
    private short _optionLength;
    private byte[] _optionData;
    public static final short DEFAULT_UDP_PAYLOAD_SIZE = 1280;

    protected OPTRecord() {
        this._UDPpayloadSize = (short)1280;
        this._extendedRCODE = 0;
        this._version = 0;
        this._Z = 0;
        this._optionCode = 0;
        this._optionLength = 0;
        this._optionData = new byte[0];
        super.setName(new Name(""));
        super.setClassType(this._UDPpayloadSize);
        super.setrdLength((short)0);
    }

    protected OPTRecord(ByteBuf buffer) {
        super(buffer);
        this._UDPpayloadSize = super.getClassType();
        this._extendedRCODE = (byte)((super.getTTL() & 0xFF000000) >>> 24);
        this._version = (byte)((super.getTTL() & 0xFF000000) >>> 16);
        if (super.getrdLength() > 0) {
            this._optionCode = buffer.readShort();
            this._optionLength = buffer.readShort();
            this._optionData = new byte[this._optionLength];
        } else {
            this._optionCode = 0;
            this._optionLength = 0;
            this._optionData = null;
        }
    }

    @Override
    protected void toBuffer(ByteBuf buffer) {
        super.toBuffer(buffer);
        if (super.getrdLength() > 0) {
            buffer.writeShort((int)this._optionCode);
            buffer.writeShort((int)this._optionLength);
            if (this._optionLength > 0) {
                buffer.writeBytes(this._optionData);
            }
        }
    }

    public short calcrdLength() {
        int length = 0;
        length = 4 + this._optionData.length;
        return (short)length;
    }

    public void setUdpPayloadSize(short size) {
        this._UDPpayloadSize = size;
        super.setClassType(this._UDPpayloadSize);
    }

    @Override
    public String toString() {
        String s = new String();
        s = "    Resource Record: " + Dns.TYPESTRING[41] + "\n      domain name: " + super.getName().toString() + "\n";
        s = s + "      udp payload size:  " + this._UDPpayloadSize + "\n      extended RCODE: " + this._extendedRCODE + "\n      version: " + this._version + "\n      Z: " + this._Z + "\n      rdlength: " + super.getrdLength() + "\n";
        if (this._optionLength > 0) {
            s = s + "      option code: " + this._optionCode + "\n      option length: " + this._optionLength + "\n      option data : " + this._optionData.toString() + "\n";
        }
        return s;
    }
}

