/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.endpoint.JaxWsPublisherContext;
import com.ibm.ws.jaxws.metadata.AddressingFeatureInfo;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.MTOMFeatureInfo;
import com.ibm.ws.jaxws.metadata.RespectBindingFeatureInfo;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.jaxws.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxWsImplementorInfo
extends JaxWsImplementorInfo {
    private static final TraceComponent tc = Tr.register(LibertyJaxWsImplementorInfo.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    private final JaxWsPublisherContext publisherContext;
    private final Class<?> implementorClass;
    private final Class<?> seiClass;
    private final EndpointInfo endpointInfo;
    private String wsdlLocation;
    private QName interfaceName;
    static final long serialVersionUID = 8601842450353450976L;

    public LibertyJaxWsImplementorInfo(Class<?> implClass, EndpointInfo edpInfo, JaxWsPublisherContext publisherContext) throws ClassNotFoundException {
        super(implClass);
        this.endpointInfo = edpInfo;
        this.publisherContext = publisherContext;
        this.implementorClass = implClass;
        String seiClassName = this.endpointInfo.getServiceEndpointInterface();
        if (null == seiClassName || seiClassName.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("the service enpoint interface class of " + this.implementorClass + " is undefined."), (Object[])new Object[0]);
            }
            this.seiClass = null;
        } else {
            this.seiClass = this.publisherContext.getPublisherModuleInfo().getClassLoader().loadClass(seiClassName);
        }
    }

    public String getBindingType() {
        String bindingType = this.endpointInfo.getProtocolBinding();
        if (StringUtils.isEmpty(bindingType)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        MTOMFeatureInfo mtomFeatureInfo = this.endpointInfo.getMTOMFeatureInfo();
        if (mtomFeatureInfo != null && !mtomFeatureInfo.isEnabled()) {
            if (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
                return "http://schemas.xmlsoap.org/wsdl/soap/http";
            }
            if (bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
                return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
            }
        }
        return bindingType;
    }

    public Class<?> getEndpointClass() {
        return this.seiClass == null ? this.implementorClass : this.seiClass;
    }

    public QName getEndpointName() {
        return this.endpointInfo.getWsdlPort();
    }

    public Class<?> getImplementorClass() {
        return this.implementorClass;
    }

    public QName getInterfaceName() {
        if (null != this.interfaceName) {
            return this.interfaceName;
        }
        String name = null;
        if (this.seiClass != null) {
            WebService service = this.seiClass.getAnnotation(WebService.class);
            if (null != service && !StringUtils.isEmpty(service.name())) {
                name = service.name();
            }
        } else {
            WebService service = this.implementorClass.getAnnotation(WebService.class);
            if (null != service && !StringUtils.isEmpty(service.name())) {
                name = service.name();
            }
        }
        if (name == null) {
            if (this.seiClass != null) {
                name = this.seiClass.getSimpleName();
            } else if (this.implementorClass != null) {
                name = this.implementorClass.getSimpleName();
            }
        }
        this.interfaceName = new QName(this.endpointInfo.getInterfaceTragetNameSpaceURL(), name);
        return this.interfaceName;
    }

    public Class<?> getSEIClass() {
        return this.seiClass;
    }

    public Service.Mode getServiceMode() {
        return this.endpointInfo.getServiceModeInfo().getValue();
    }

    public QName getServiceName() {
        return this.endpointInfo.getWsdlService();
    }

    public String getWsdlLocation() {
        if (null != this.wsdlLocation) {
            return this.wsdlLocation;
        }
        URL wsdlUrl = JaxWsUtils.resolve(this.endpointInfo.getWsdlLocation(), this.publisherContext.getModuleMetaData().getModuleContainer());
        this.wsdlLocation = null == wsdlUrl ? this.endpointInfo.getWsdlLocation() : wsdlUrl.toString();
        return this.wsdlLocation;
    }

    public MTOMFeature getMTOMFeature() {
        MTOMFeatureInfo featureInfo = this.endpointInfo.getMTOMFeatureInfo();
        if (featureInfo != null) {
            return (MTOMFeature)featureInfo.getWebServiceFeature();
        }
        if ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(this.endpointInfo.getProtocolBinding()) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(this.endpointInfo.getProtocolBinding())) {
            return new MTOMFeature(true);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public AddressingFeature getAddressingFeature() {
        AddressingFeatureInfo featureInfo = this.endpointInfo.getAddressingFeatureInfo();
        if (null != featureInfo) {
            try {
                AddressingFeature.Responses responses = featureInfo.getResponses();
                Constructor constructor = AddressingFeature.class.getConstructor(Boolean.TYPE, Boolean.TYPE, responses.getClass());
                return (AddressingFeature)constructor.newInstance(featureInfo.isEnabled(), featureInfo.isRequired(), responses);
            }
            catch (Exception responses) {
                FFDCFilter.processException((Throwable)responses, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsImplementorInfo", (String)"189", (Object)((Object)this), (Object[])new Object[0]);
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"could not use AddressingFeature(boolean, boolean, Responses) construction", (Object[])new Object[]{e});
                }
                return new AddressingFeature(featureInfo.isEnabled(), featureInfo.isRequired());
            }
        }
        return null;
    }

    public RespectBindingFeature getRespectBindingFeature() {
        RespectBindingFeatureInfo featureInfo = this.endpointInfo.getRespectBindingFeatureInfo();
        if (null != featureInfo) {
            return (RespectBindingFeature)featureInfo.getWebServiceFeature();
        }
        return null;
    }
}

