/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.springboot.container.ApplicationError;
import com.ibm.ws.app.manager.springboot.container.ApplicationTr;
import com.ibm.ws.app.manager.springboot.util.SpringBootManifest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SpringBootThinUtil
implements Closeable {
    public static final String SPRING_LIB_INDEX_FILE = "META-INF/spring.lib.index";
    private static final String SPRING_BOOT_LOADER_CLASSPATH = "org/springframework/boot/loader/";
    private static final String LIBERTY_EXEC_JAR_BSN = "wlp.lib.extract";
    private static final String LIBERTY_SERVER_NAME_HEADER = "Server-Name";
    private static final String LIBERTY_ARCHIVE_ROOT_HEADER = "Archive-Root";
    private static final String LIBERTY_LIB_CACHE_PATH = "usr/shared/resources/lib.index.cache/";
    private static final String LIBERTY_SERVERS_PATH = "usr/servers/";
    private static final String LIBERTY_SERVER_DROPINS_SPRING = "/dropins/spring/";
    private static final String LIBERTY_SERVER_DROPINS = "/dropins/";
    private static final String LIBERTY_SPRING_EXT = ".spring";
    private static final String LIBERTY_SERVER_APPS = "/apps/";
    private static final String[] appSearchRoots = new String[]{"/dropins/spring/", "/dropins/", "/apps/"};
    private static AtomicReference<String> springBootVersion = new AtomicReference();
    private final JarFile sourceFatJar;
    private final File targetThinJar;
    private final File libIndexCache;
    private final File libIndexCacheParent;
    private final String libertyServer;
    private final String libertyRoot;
    private final String springBootLibPath;
    private final String springBootLibProvidedPath;
    private final StarterFilter springStarterFilter;
    private final List<String> libEntries = new ArrayList<String>();
    private static final String[] ZIP_EXTENSIONS = new String[]{"jar", "zip", "ear", "war", "rar", "eba", "esa", "sar"};
    private static final String ZIP_EXTENSION_SPRING = "spring";
    private static final TraceComponent tc = Tr.register(SpringBootThinUtil.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil");
    private static String THE_UNKNOWN_STARTER = "";
    private static final Set<String> emptySet = new HashSet<String>(0);
    static final long serialVersionUID = -3407691858923060105L;

    public SpringBootThinUtil(File sourceFatJar, File targetThinJar, File libIndexCache) throws IOException {
        this(sourceFatJar, targetThinJar, libIndexCache, null);
    }

    public SpringBootThinUtil(File sourceFatJar, File targetThinJar, File libIndexCache, File libIndexCacheParent) throws IOException {
        this.validateNotNull(sourceFatJar, targetThinJar, libIndexCache);
        this.sourceFatJar = new JarFile(sourceFatJar);
        this.targetThinJar = targetThinJar;
        this.libIndexCache = libIndexCache;
        this.libIndexCacheParent = libIndexCacheParent;
        SpringBootManifest sbmf = null;
        Manifest mf = this.sourceFatJar.getManifest();
        String bsn = mf.getMainAttributes().getValue("Bundle-SymbolicName");
        if (LIBERTY_EXEC_JAR_BSN.equals(bsn)) {
            this.libertyServer = mf.getMainAttributes().getValue(LIBERTY_SERVER_NAME_HEADER);
            this.libertyRoot = mf.getMainAttributes().getValue(LIBERTY_ARCHIVE_ROOT_HEADER);
            this.springBootLibPath = null;
            this.springBootLibProvidedPath = null;
            this.springStarterFilter = null;
        } else {
            String springBootLibProvidedPath;
            sbmf = new SpringBootManifest(this.sourceFatJar.getManifest());
            String springBootLibPath = sbmf.getSpringBootLib();
            if (!springBootLibPath.endsWith("/")) {
                springBootLibPath = springBootLibPath + "/";
            }
            if ((springBootLibProvidedPath = sbmf.getSpringBootLibProvided()) != null && !springBootLibProvidedPath.endsWith("/")) {
                springBootLibProvidedPath = springBootLibProvidedPath + "/";
            }
            this.libertyServer = null;
            this.libertyRoot = null;
            this.springBootLibPath = springBootLibPath;
            this.springBootLibProvidedPath = springBootLibProvidedPath;
            this.springStarterFilter = SpringBootThinUtil.getStarterFilter(this.sourceFatJar, sbmf);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sourceFatJar: " + sourceFatJar.getAbsolutePath()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("targetThinJar: " + targetThinJar.getAbsolutePath()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("libIndexCache: " + libIndexCache.getAbsolutePath()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"libIndexCacheParent: ", (Object[])new Object[]{Objects.toString(libIndexCacheParent)});
            Tr.debug((TraceComponent)tc, (String)("libertyServer: " + this.libertyServer), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("libertyRoot: " + this.libertyRoot), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("springBootLibPath: " + this.springBootLibPath), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("springBootLibProvidedPath: " + this.springBootLibProvidedPath), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("springStarterFilter: " + Objects.toString(this.springStarterFilter)), (Object[])new Object[0]);
        }
    }

    private void validateNotNull(File sourceFatJar, File targetThinJar, File libIndexCache) {
        if (sourceFatJar == null) {
            throw new IllegalStateException("Spring Boot source archive cannot be null");
        }
        if (targetThinJar == null) {
            throw new IllegalStateException("Target thin archive cannot be null");
        }
        if (libIndexCache == null) {
            throw new IllegalStateException("Library cache cannot be null");
        }
    }

    public void execute() throws IOException, NoSuchAlgorithmException {
        if (this.springStarterFilter == null) {
            this.executeExtractFromExecutableJar();
        } else {
            this.executeThin();
        }
    }

    private void executeExtractFromExecutableJar() throws IOException {
        if (this.libertyServer == null) {
            throw new ApplicationError(ApplicationTr.Type.ERROR_INVALID_PACKAGED_LIBERTY_JAR, new Object[0]);
        }
        String root = this.libertyRoot;
        if (root == null) {
            root = "";
        }
        String libCachePath = root + LIBERTY_LIB_CACHE_PATH;
        String serverPath = root + LIBERTY_SERVERS_PATH + this.libertyServer;
        PreThinnedApp preThinned = new PreThinnedApp(libCachePath, serverPath, this.sourceFatJar);
        preThinned.discover();
        preThinned.store(this.libIndexCache, this.targetThinJar);
    }

    private void executeThin() throws IOException, NoSuchAlgorithmException {
        JarOutputStream thinJar = new JarOutputStream((OutputStream)new FileOutputStream(this.targetThinJar), this.sourceFatJar.getManifest());
        try {
            HashSet<String> entryNames = new HashSet<String>();
            Enumeration<JarEntry> entries = this.sourceFatJar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entryNames.add(entry.getName()) || "META-INF/MANIFEST.MF".equals(entry.getName()) || entry.getName().startsWith(SPRING_BOOT_LOADER_CLASSPATH)) continue;
                this.storeEntry(thinJar, entry);
            }
            this.addLibIndexFileToThinJar(thinJar);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"192", (Object)this, (Object[])new Object[0]);
            try {
                thinJar.close();
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"192", (Object)this, (Object[])new Object[0]);
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        thinJar.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeEntry(JarOutputStream thinJar, JarEntry entry) throws IOException, NoSuchAlgorithmException {
        String path = entry.getName();
        boolean isLibPath = this.isFromLibPath(path);
        boolean isLibProvidedPath = this.isFromLibProvidedPath(path);
        if (isLibPath || isLibProvidedPath) {
            if (this.springStarterFilter.apply(entry.getName()) != false) return;
            if (isLibProvidedPath) {
                if (!this.includeLibProvidedPaths()) return;
            }
            String hash = this.hash(this.sourceFatJar, entry);
            String hashPrefix = hash.substring(0, 2);
            String hashSuffix = hash.substring(2, hash.length());
            if (!this.isZip(entry)) throw new IllegalStateException("The entry " + path + " is not a valid zip.");
            if (!SpringBootThinUtil.hasZipExtension(path)) {
                path = path + ".jar";
            }
            this.storeLibraryInDir(entry, path, hashPrefix, hashSuffix);
            String libLine = "/" + path + '=' + hash;
            this.libEntries.add(libLine);
            return;
        }
        InputStream is = this.sourceFatJar.getInputStream(entry);
        try {
            SpringBootThinUtil.writeEntry(is, thinJar, path);
            if (is == null) return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"229", (Object)this, (Object[])new Object[]{thinJar, entry});
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"229", (Object)this, (Object[])new Object[]{thinJar, entry});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        is.close();
    }

    /*
     * Exception decompiling
     */
    private boolean isZip(JarEntry entry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean hasZipExtension(String name) {
        int nameLen = name.length();
        if (nameLen < 4) {
            return false;
        }
        if (nameLen >= 7 && name.charAt(nameLen - 7) == '.' && name.regionMatches(true, nameLen - 6, ZIP_EXTENSION_SPRING, 0, 6)) {
            return true;
        }
        if (name.charAt(nameLen - 4) != '.') {
            return false;
        }
        for (String ext : ZIP_EXTENSIONS) {
            if (!name.regionMatches(true, nameLen - 3, ext, 0, 3)) continue;
            return true;
        }
        return false;
    }

    private boolean includeLibProvidedPaths() {
        return springBootVersion.get() != null && springBootVersion.get().compareTo("4.0.0") >= 0;
    }

    boolean isFromLibPath(String entryName) {
        return entryName.startsWith(this.springBootLibPath) && !entryName.endsWith("/");
    }

    boolean isFromLibProvidedPath(String entryName) {
        if (this.springBootLibProvidedPath != null) {
            return entryName.startsWith(this.springBootLibProvidedPath) && !entryName.endsWith("/");
        }
        return false;
    }

    protected String hash(JarFile jf, ZipEntry entry) throws IOException, NoSuchAlgorithmException {
        InputStream eis = jf.getInputStream(entry);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] buffer = new byte[4096];
        int read = -1;
        while ((read = eis.read(buffer)) != -1) {
            digest.update(buffer, 0, read);
        }
        byte[] digested = digest.digest();
        return SpringBootThinUtil.convertToHexString(digested);
    }

    private static String convertToHexString(byte[] digested) {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < digested.length; ++i) {
            stringBuffer.append(Integer.toString((digested[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeLibraryInDir(JarEntry entry, String path, String hashPrefix, String hashSuffix) throws IOException, NoSuchAlgorithmException {
        File libDir;
        File libFile;
        File libDirParent;
        File libFileParent;
        String hashPath = hashPrefix + '/' + hashSuffix;
        String libName = path;
        int lastSlash = libName.lastIndexOf(47);
        if (lastSlash >= 0) {
            libName = libName.substring(lastSlash + 1);
        }
        if (this.libIndexCacheParent != null && (libFileParent = new File(libDirParent = new File(this.libIndexCacheParent, hashPath), libName)).exists()) {
            return;
        }
        if (!this.libIndexCache.exists()) {
            this.libIndexCache.mkdirs();
        }
        if (!(libFile = new File(libDir = new File(this.libIndexCache, hashPath), libName)).exists()) {
            if (!libDir.exists()) {
                libDir.mkdirs();
            }
            try (InputStream is = this.sourceFatJar.getInputStream(entry);){
                FileOutputStream libJar = new FileOutputStream(libFile);
                try {
                    SpringBootThinUtil.copyStream(is, libJar);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"365", (Object)this, (Object[])new Object[]{entry, path, hashPrefix, hashSuffix});
                    try {
                        ((OutputStream)libJar).close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil", (String)"365", (Object)this, (Object[])new Object[]{entry, path, hashPrefix, hashSuffix});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ((OutputStream)libJar).close();
            }
        }
    }

    private static void writeEntry(InputStream is, ZipOutputStream zos, String entryName) throws IOException {
        try {
            zos.putNextEntry(new ZipEntry(entryName));
            SpringBootThinUtil.copyStream(is, zos);
        }
        finally {
            zos.closeEntry();
        }
    }

    static void copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int read = -1;
        while ((read = is.read(buffer)) != -1) {
            os.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibIndexFileToThinJar(JarOutputStream thinJar) throws IOException {
        thinJar.putNextEntry(new ZipEntry(SPRING_LIB_INDEX_FILE));
        try {
            for (String libEntry : this.libEntries) {
                thinJar.write(libEntry.getBytes(StandardCharsets.UTF_8));
                thinJar.write(10);
            }
        }
        finally {
            thinJar.closeEntry();
        }
    }

    public static StarterFilter getStarterFilter(JarFile jarFile, SpringBootManifest sbmf) {
        return SpringBootThinUtil.getStarterFilter(SpringBootThinUtil.stringStream(jarFile), sbmf);
    }

    public static Stream<String> stringStream(JarFile jarFile) {
        Stream<String> stream = StreamSupport.stream(jarFile.stream().spliterator(), false).map(entry -> entry.getName());
        return stream;
    }

    public static StarterFilter getStarterFilter(Stream<String> entries, SpringBootManifest sbmf) {
        AtomicReference<String> starterRef = new AtomicReference<String>();
        AtomicReference embeddedContainer = new AtomicReference();
        AtomicReference<String> version = new AtomicReference<String>(sbmf.getSpringBootVersion());
        AtomicReference container = new AtomicReference();
        String springBootLibPath = sbmf.getSpringBootLib();
        if (!springBootLibPath.endsWith("/")) {
            springBootLibPath = springBootLibPath + "/";
        }
        String libPath = springBootLibPath;
        entries.forEach(entry -> {
            if ((version.get() == null || container.get() == null) && entry.endsWith(".jar")) {
                String path = entry;
                if (version.get() == null && path.contains(libPath + "spring-boot-")) {
                    String extractedVersion = SpringBootThinUtil.extractVersion(path);
                    version.set(extractedVersion);
                } else if (container.get() == null) {
                    for (Container c : Container.values()) {
                        if (!path.contains(c.getCoreContainerJar())) continue;
                        container.set(c);
                        break;
                    }
                    if (container.get() != null) {
                        switch ((Container)((Object)((Object)container.get()))) {
                            case TOMCAT: {
                                embeddedContainer.set("tomcat");
                                break;
                            }
                            case JETTY: {
                                embeddedContainer.set("jetty");
                                break;
                            }
                            case UNDERTOW: {
                                embeddedContainer.set("undertow");
                                break;
                            }
                            case NETTY: {
                                embeddedContainer.set("netty");
                                break;
                            }
                        }
                    }
                }
            }
        });
        if (version.get() != null) {
            springBootVersion.set(version.get());
        }
        String embeddedConatinerPrefix = embeddedContainer.get() != null ? (String)embeddedContainer.get() : "";
        embeddedConatinerPrefix = version.get() != null ? embeddedConatinerPrefix + "-" + version.get() : embeddedConatinerPrefix;
        for (String supportedStarter : EmbeddedContainer.getSupportedStarters()) {
            if (!embeddedConatinerPrefix.contains(supportedStarter)) continue;
            starterRef.set(supportedStarter);
            break;
        }
        String springBootStarter = starterRef.get() != null ? (String)starterRef.get() : THE_UNKNOWN_STARTER;
        Set<String> starterArtifactIds = EmbeddedContainer.getStarterArtifactIds(springBootStarter);
        return new StarterFilter(springBootStarter, starterArtifactIds);
    }

    private static String extractVersion(String path) {
        String version = "";
        String regex = "(\\d+\\.\\d+\\.\\d+)";
        Matcher m = Pattern.compile(regex).matcher(path);
        if (m.find()) {
            version = m.group(1);
        }
        return version;
    }

    public static String getArtifactId(String jarName) {
        int idxEndAid;
        int idxBegAid = jarName.lastIndexOf(47) + 1;
        return idxBegAid <= (idxEndAid = jarName.lastIndexOf(45) - 1) && jarName.endsWith(".jar") ? jarName.substring(idxBegAid, idxEndAid + 1).toLowerCase() : "";
    }

    @Override
    public void close() throws IOException {
        this.sourceFatJar.close();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class StarterFilter
    implements Function<String, Boolean> {
        final String starterName;
        final Set<String> starterArtifactIds;
        static final long serialVersionUID = 911768199016734835L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StarterFilter(String starterName, Set<String> starterArtifactIds) {
            this.starterName = starterName;
            this.starterArtifactIds = starterArtifactIds;
        }

        @Override
        public Boolean apply(String jarName) {
            return this.starterArtifactIds.contains(SpringBootThinUtil.getArtifactId(jarName));
        }

        public String toString() {
            return this.starterName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StarterFilter.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$StarterFilter");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class PreThinnedApp {
        private final String libCachePath;
        private final String serverPath;
        private final JarFile jarFile;
        private final Map<String, Map<String, List<JarEntry>>> applicationEntries = new HashMap<String, Map<String, List<JarEntry>>>();
        private final List<JarEntry> libCacheEntries = new ArrayList<JarEntry>();
        private boolean appLocationConfigured;
        static final long serialVersionUID = -6334053432929671280L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PreThinnedApp(String libCachePath, String serverPath, JarFile jarFile) {
            this.libCachePath = libCachePath;
            this.serverPath = serverPath;
            this.jarFile = jarFile;
        }

        void discover() throws IOException {
            if (this.jarFile.getJarEntry(this.libCachePath) == null) {
                throw new ApplicationError(ApplicationTr.Type.ERROR_INVALID_PACKAGED_LIBERTY_JAR, new Object[0]);
            }
            if (this.jarFile.getJarEntry(this.serverPath) == null) {
                throw new ApplicationError(ApplicationTr.Type.ERROR_INVALID_PACKAGED_LIBERTY_JAR, new Object[0]);
            }
            Enumeration<JarEntry> entries = this.jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String fullEntryPath = entry.getName();
                if (!fullEntryPath.equals(this.libCachePath) && fullEntryPath.startsWith(this.libCachePath)) {
                    this.libCacheEntries.add(entry);
                }
                if (fullEntryPath.equals(this.serverPath + "/server.xml")) {
                    this.parseServerXML(this.jarFile, entry);
                }
                for (String appsRoot : appSearchRoots) {
                    if (this.addAppEntry(fullEntryPath, appsRoot, entry)) break;
                }
            }
            if (this.libCacheEntries.isEmpty()) {
                throw new ApplicationError(ApplicationTr.Type.ERROR_INVALID_PACKAGED_LIBERTY_JAR, new Object[0]);
            }
            if (this.applicationEntries.isEmpty()) {
                throw new ApplicationError(ApplicationTr.Type.ERROR_APP_NOT_FOUND_INSIDE_PACKAGED_LIBERTY_JAR, new Object[0]);
            }
            this.applicationEntries.forEach((k1, m) -> m.forEach((k2, l) -> l.sort((e1, e2) -> e1.getName().compareTo(e2.getName()))));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void parseServerXML(JarFile jarFile, JarEntry entry) throws IOException {
            InputStream is = jarFile.getInputStream(entry);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!line.contains("<springBootApplication")) continue;
                        this.appLocationConfigured = true;
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"560", (Object)this, (Object[])new Object[]{jarFile, entry});
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"560", (Object)this, (Object[])new Object[]{jarFile, entry});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                reader.close();
                if (is == null) return;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"559", (Object)this, (Object[])new Object[]{jarFile, entry});
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"559", (Object)this, (Object[])new Object[]{jarFile, entry});
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            is.close();
        }

        private boolean addAppEntry(String fullEntryPath, String appsRoot, JarEntry entry) {
            String fullAppsRoot = this.serverPath + appsRoot;
            if (fullEntryPath.startsWith(fullAppsRoot)) {
                if (!fullEntryPath.equals(fullAppsRoot)) {
                    String appName = fullEntryPath.substring(fullAppsRoot.length());
                    int slash = appName.indexOf(47);
                    if (slash >= 0) {
                        appName.substring(0, slash);
                    }
                    Map apps = this.applicationEntries.computeIfAbsent(appsRoot, k -> new LinkedHashMap());
                    apps.computeIfAbsent(appName, k -> new ArrayList()).add(entry);
                }
                return true;
            }
            return false;
        }

        void store(File libCache, File thinApp) throws IOException {
            this.storeApp(thinApp);
            this.storeLibCache(libCache);
        }

        private void storeApp(File thinApp) throws IOException {
            Map<String, List<JarEntry>> found = this.applicationEntries.get(SpringBootThinUtil.LIBERTY_SERVER_DROPINS_SPRING);
            if (found != null) {
                this.storeApp(thinApp, found.values().iterator().next());
                return;
            }
            found = this.applicationEntries.get(SpringBootThinUtil.LIBERTY_SERVER_DROPINS);
            if (found != null) {
                for (Map.Entry<String, List<JarEntry>> app : found.entrySet()) {
                    if (!app.getKey().endsWith(SpringBootThinUtil.LIBERTY_SPRING_EXT)) continue;
                    this.storeApp(thinApp, app.getValue());
                    return;
                }
            }
            if ((found = this.applicationEntries.get(SpringBootThinUtil.LIBERTY_SERVER_APPS)) != null) {
                for (Map.Entry<String, List<JarEntry>> app : found.entrySet()) {
                    if (!this.appLocationConfigured) continue;
                    this.storeApp(thinApp, app.getValue());
                    return;
                }
            }
            throw new ApplicationError(ApplicationTr.Type.ERROR_APP_NOT_FOUND_INSIDE_PACKAGED_LIBERTY_JAR, new Object[0]);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void storeApp(File thinApp, List<JarEntry> entries) throws IOException {
            JarEntry firstAppEntry = entries.get(0);
            if (!firstAppEntry.isDirectory()) {
                SpringBootThinUtil.copyStream(this.jarFile.getInputStream(firstAppEntry), new FileOutputStream(thinApp));
            } else {
                String dirAppRoot = firstAppEntry.getName();
                String dirAppRootManifest = dirAppRoot + "META-INF/MANIFEST.MF";
                JarEntry manifestEntry = this.jarFile.getJarEntry(dirAppRootManifest);
                if (manifestEntry == null) {
                    throw new ApplicationError(ApplicationTr.Type.ERROR_INVALID_PACKAGED_LIBERTY_JAR, new Object[0]);
                }
                Manifest mf = new Manifest(this.jarFile.getInputStream(manifestEntry));
                JarOutputStream thinJar = new JarOutputStream((OutputStream)new FileOutputStream(thinApp), mf);
                try {
                    for (JarEntry appEntry : entries.subList(1, entries.size())) {
                        String entryName = appEntry.getName();
                        if (!entryName.startsWith(dirAppRoot) || entryName.equals(dirAppRootManifest)) continue;
                        String path = appEntry.getName().substring(dirAppRoot.length());
                        InputStream is = this.jarFile.getInputStream(appEntry);
                        try {
                            SpringBootThinUtil.writeEntry(is, thinJar, path);
                            if (is == null) continue;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"642", (Object)this, (Object[])new Object[]{thinApp, entries});
                            if (is == null) throw throwable;
                            try {
                                is.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"642", (Object)this, (Object[])new Object[]{thinApp, entries});
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"637", (Object)this, (Object[])new Object[]{thinApp, entries});
                    try {
                        thinJar.close();
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"637", (Object)this, (Object[])new Object[]{thinApp, entries});
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                thinJar.close();
            }
            JarFile verifyThinJar = new JarFile(thinApp);
            try {
                if (verifyThinJar.getEntry(SpringBootThinUtil.SPRING_LIB_INDEX_FILE) == null) {
                    throw new IOException(SpringBootThinUtil.SPRING_LIB_INDEX_FILE);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"649", (Object)this, (Object[])new Object[]{thinApp, entries});
                try {
                    verifyThinJar.close();
                    throw throwable;
                }
                catch (Throwable throwable4) {
                    FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"649", (Object)this, (Object[])new Object[]{thinApp, entries});
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            verifyThinJar.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeLibCache(File libCache) throws IOException {
            for (JarEntry libEntry : this.libCacheEntries) {
                String path;
                File libFile;
                if (libEntry.isDirectory() || (libFile = new File(libCache, path = libEntry.getName().substring(this.libCachePath.length()))).exists()) continue;
                if (!libFile.getParentFile().exists()) {
                    libFile.getParentFile().mkdirs();
                }
                try (InputStream is = this.jarFile.getInputStream(libEntry);){
                    FileOutputStream libJar = new FileOutputStream(libFile);
                    try {
                        SpringBootThinUtil.copyStream(is, libJar);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"667", (Object)this, (Object[])new Object[]{libCache});
                        try {
                            ((OutputStream)libJar).close();
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp", (String)"667", (Object)this, (Object[])new Object[]{libCache});
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    ((OutputStream)libJar).close();
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PreThinnedApp.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$PreThinnedApp");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class EmbeddedContainer {
        private static final List<String> mvnSpringBoot15TomcatStarterDeps;
        private static final List<String> mvnSpringBoot20TomcatStarterDeps;
        private static final List<String> mvnSpringBoot21TomcatStarterDeps;
        private static final List<String> mvnSpringBoot22TomcatStarterDeps;
        private static final List<String> mvnSpringBoot23TomcatStarterDeps;
        private static final List<String> mvnSpringBoot24TomcatStarterDeps;
        private static final List<String> mvnSpringBoot25TomcatStarterDeps;
        private static final List<String> mvnSpringBoot26TomcatStarterDeps;
        private static final List<String> mvnSpringBoot27TomcatStarterDeps;
        private static final List<String> mvnSpringBoot30TomcatStarterDeps;
        private static final List<String> mvnSpringBoot31TomcatStarterDeps;
        private static final List<String> mvnSpringBoot32TomcatStarterDeps;
        private static final List<String> mvnSpringBoot33TomcatStarterDeps;
        private static final List<String> mvnSpringBoot34TomcatStarterDeps;
        private static final List<String> mvnSpringBoot35TomcatStarterDeps;
        private static final List<String> mvnSpringBoot40TomcatStarterDeps;
        private static final List<String> mvnSpringBoot15JettyStarterDeps;
        private static final List<String> mvnSpringBoot20JettyStarterDeps;
        private static final List<String> mvnSpringBoot21JettyStarterDeps;
        private static final List<String> mvnSpringBoot22JettyStarterDeps;
        private static final List<String> mvnSpringBoot23JettyStarterDeps;
        private static final List<String> mvnSpringBoot24JettyStarterDeps;
        private static final List<String> mvnSpringBoot25JettyStarterDeps;
        private static final List<String> mvnSpringBoot26JettyStarterDeps;
        private static final List<String> mvnSpringBoot27JettyStarterDeps;
        private static final List<String> mvnSpringBoot30JettyStarterDeps;
        private static final List<String> mvnSpringBoot31JettyStarterDeps;
        private static final List<String> mvnSpringBoot32JettyStarterDeps;
        private static final List<String> mvnSpringBoot33JettyStarterDeps;
        private static final List<String> mvnSpringBoot34JettyStarterDeps;
        private static final List<String> mvnSpringBoot35JettyStarterDeps;
        private static final List<String> mvnSpringBoot40JettyStarterDeps;
        private static final List<String> mvnSpringBoot15UndertowStarterDeps;
        private static final List<String> mvnSpringBoot20UndertowStarterDeps;
        private static final List<String> mvnSpringBoot21UndertowStarterDeps;
        private static final List<String> mvnSpringBoot22UndertowStarterDeps;
        private static final List<String> mvnSpringBoot23UndertowStarterDeps;
        private static final List<String> mvnSpringBoot24UndertowStarterDeps;
        private static final List<String> mvnSpringBoot25UndertowStarterDeps;
        private static final List<String> mvnSpringBoot26UndertowStarterDeps;
        private static final List<String> mvnSpringBoot27UndertowStarterDeps;
        private static final List<String> mvnSpringBoot30UndertowStarterDeps;
        private static final List<String> mvnSpringBoot31UndertowStarterDeps;
        private static final List<String> mvnSpringBoot32UndertowStarterDeps;
        private static final List<String> mvnSpringBoot33UndertowStarterDeps;
        private static final List<String> mvnSpringBoot34UndertowStarterDeps;
        private static final List<String> mvnSpringBoot35UndertowStarterDeps;
        private static final List<String> mvnSpringBoot40UndertowStarterDeps;
        private static final List<String> mvnSpringBoot20NettyStarterDeps;
        private static final List<String> mvnSpringBoot21NettyStarterDeps;
        private static final List<String> mvnSpringBoot22NettyStarterDeps;
        private static final List<String> mvnSpringBoot23NettyStarterDeps;
        private static final List<String> mvnSpringBoot24NettyStarterDeps;
        private static final List<String> mvnSpringBoot25NettyStarterDeps;
        private static final List<String> mvnSpringBoot26NettyStarterDeps;
        private static final List<String> mvnSpringBoot27NettyStarterDeps;
        private static final List<String> mvnSpringBoot30NettyStarterDeps;
        private static final List<String> mvnSpringBoot31NettyStarterDeps;
        private static final List<String> mvnSpringBoot32NettyStarterDeps;
        private static final List<String> mvnSpringBoot33NettyStarterDeps;
        private static final List<String> mvnSpringBoot34NettyStarterDeps;
        private static final List<String> mvnSpringBoot35NettyStarterDeps;
        private static final List<String> mvnSpringBoot40NettyStarterDeps;
        public static final String TOMCAT = "tomcat";
        public static final String JETTY = "jetty";
        public static final String UNDERTOW = "undertow";
        public static final String LIBERTY = "liberty";
        public static final String NETTY = "netty";
        public static final String SPRING_BOOT_STARTER = "spring-boot-starter";
        public static final String SPRING_BOOT_STARTER_REACTOR = "spring-boot-starter-reactor";
        private static final Map<String, Set<String>> startersToDependentArtifactIdsMap;
        static final long serialVersionUID = 594196147850258047L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EmbeddedContainer() {
        }

        public static Set<String> getSupportedStarters() {
            return EmbeddedContainer.getStartersToDependentArtifactIdsMap().keySet();
        }

        public static Set<String> getStarterArtifactIds(String starter) {
            Set starterArtifactIds = EmbeddedContainer.getStartersToDependentArtifactIdsMap().getOrDefault(starter, null);
            if (null == starterArtifactIds) {
                return emptySet;
            }
            return starterArtifactIds;
        }

        public static Map<String, Set<String>> getStartersToDependentArtifactIdsMap() {
            return startersToDependentArtifactIdsMap;
        }

        private static String starterJarNamePrefix(String embeddedContainer, String versionInfo) {
            return embeddedContainer + "-" + versionInfo;
        }

        public static Set<String> loadStarterMvnDeps(List<String> mvnStarterDeps) {
            HashSet starterArtifactIds = new HashSet();
            mvnStarterDeps.forEach(mvnDep -> starterArtifactIds.add(mvnDep.split(":")[1].toLowerCase()));
            return Collections.unmodifiableSet(starterArtifactIds);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EmbeddedContainer.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.util.SpringBootThinUtil$EmbeddedContainer");
            mvnSpringBoot15TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:1.5.10.RELEASE:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:8.5.27:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:8.5.27:compile", "org.apache.tomcat:tomcat-annotations-api:jar:8.5.27:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:8.5.27:compile");
            mvnSpringBoot20TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:2.0.1.RELEASE:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.2:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:8.5.29:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:8.5.29:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:8.5.29:compile");
            mvnSpringBoot21TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:2.1.2.RELEASE:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.2:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:9.0.14:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.14:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:9.0.14:compile");
            mvnSpringBoot22TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:2.2.6.RELEASE:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.5:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:9.0.33:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.33:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:9.0.33:compile");
            mvnSpringBoot23TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:2.3.0.RELEASE:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.5:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:9.0.35:compile", "org.glassfish:jakarta.el:jar:3.0.3:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:9.0.35:compile");
            mvnSpringBoot24TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:2.4.0:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.5:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:9.0.39:compile", "org.glassfish:jakarta.el:jar:3.0.3:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:9.0.39:compile");
            mvnSpringBoot25TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:2.5.0:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.5:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:9.0.46:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.46:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:9.0.46:compile");
            mvnSpringBoot26TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:2.6.6:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.5:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:9.0.60:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.60:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:9.0.60:compile");
            mvnSpringBoot27TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:2.7.1:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.5:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:9.0.64:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.64:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:9.0.64:compile");
            mvnSpringBoot30TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:3.0.0:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:10.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:10.1.1:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile");
            mvnSpringBoot31TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:3.1.7:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:10.1.17:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.17:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:10.1.17:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile");
            mvnSpringBoot32TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:3.2.1:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:10.1.17:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.17:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:10.1.17:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile");
            mvnSpringBoot33TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:3.3.0:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:10.1.24:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.24:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:10.1.24:compile");
            mvnSpringBoot34TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:3.4.0:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:10.1.33:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.33:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:10.1.33:compile");
            mvnSpringBoot35TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:3.5.3:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:10.1.42:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.42:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:10.1.42:compile");
            mvnSpringBoot40TomcatStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-tomcat:jar:4.0.0-M1:compile", "org.springframework.boot:spring-boot-tomcat:jar:4.0.0-M1:compile", "org.apache.tomcat.embed:tomcat-embed-core:jar:11.0.9:compile", "jakarta.annotation:jakarta.annotation-api:jar:3.0.0:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:11.0.9:compile", "org.apache.tomcat.embed:tomcat-embed-websocket:jar:11.0.9:compile");
            mvnSpringBoot15JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:1.5.10.RELEASE:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.8.v20171121:compile", "org.ow2.asm:asm-tree:jar:6.0:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.8.v20171121:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-server:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-io:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-security:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.8.v20171121:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.8.v20171121:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.8.v20171121:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.2:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.8.v20171121:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-util:jar:9.4.8.v20171121:compile", "org.ow2.asm:asm-commons:jar:6.0:compile", "jakarta.servlet:jakarta.servlet-api:jar:3.1.0:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-client:jar:9.4.8.v20171121:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.0:compile", "org.mortbay.jasper:apache-el:jar:8.0.33:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.8.v20171121:compile", "org.eclipse.jetty:jetty-http:jar:9.4.8.v20171121:compile", "org.ow2.asm:asm:jar:6.0:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.8.v20171121:compile");
            mvnSpringBoot20JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:2.0.1.RELEASE:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-http:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-util:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-io:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-security:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-server:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-client:jar:9.4.9.v20180320:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.9.v20180320:compile", "jakarta.servlet:jakarta.servlet-api:jar:3.1.0:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.9.v20180320:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.9.v20180320:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.2:compile", "org.ow2.asm:asm:jar:6.0:compile", "org.ow2.asm:asm-commons:jar:6.0:compile", "org.ow2.asm:asm-tree:jar:6.0:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.9.v20180320:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.0:compile", "org.mortbay.jasper:apache-el:jar:8.5.24.2:compile");
            mvnSpringBoot21JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:2.1.2.RELEASE:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-http:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-util:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-io:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-security:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-server:jar:9.4.14.v20181114:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.14.v20181114:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.14.v20181114:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.14.v20181114:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-client:jar:9.4.14.v20181114:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.14.v20181114:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.1:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.14.v20181114:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.14.v20181114:compile", "jakarta.annotation:jakarta.annotation-api:jar:1.3.2:compile", "org.ow2.asm:asm:jar:7.0:compile", "org.ow2.asm:asm-commons:jar:7.0:compile", "org.ow2.asm:asm-tree:jar:7.0:compile", "org.ow2.asm:asm-analysis:jar:7.0:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.14.v20181114:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.1:compile", "org.mortbay.jasper:apache-el:jar:8.5.35.1:compile");
            mvnSpringBoot22JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:2.2.6.RELEASE:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.3:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.1.2:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-http:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-util:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-io:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-security:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-server:jar:9.4.27.v20200227:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.27.v20200227:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.27.v20200227:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.27.v20200227:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-client:jar:9.4.27.v20200227:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.27.v20200227:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.27.v20200227:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.27.v20200227:compile", "org.ow2.asm:asm:jar:7.2:compile", "org.ow2.asm:asm-commons:jar:7.2:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.27.v20200227:compile", "org.mortbay.jasper:apache-el:jar:8.5.49:compile");
            mvnSpringBoot23JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:2.3.0.RELEASE:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.3:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.1.2:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-http:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-util:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-io:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-security:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-server:jar:9.4.28.v20200408:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.28.v20200408:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.28.v20200408:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.28.v20200408:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-client:jar:9.4.28.v20200408:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.28.v20200408:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.28.v20200408:compile", "org.eclipse.jetty:jetty-jndi:jar:9.4.28.v20200408:compile", "org.ow2.asm:asm:jar:7.2:compile", "org.ow2.asm:asm-commons:jar:7.2:compile", "org.ow2.asm:asm-tree:jar:7.2:compile", "org.ow2.asm:asm-analysis:jar:7.2:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.28.v20200408:compile", "org.glassfish:jakarta.el:jar:3.0.3:compile");
            mvnSpringBoot24JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:2.4.0:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.4:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.1.2:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-http:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-util:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-io:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-security:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-server:jar:9.4.34.v20201102:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.34.v20201102:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.34.v20201102:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.34.v20201102:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-client:jar:9.4.34.v20201102:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.34.v20201102:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.34.v20201102:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.34.v20201102:compile", "org.ow2.asm:asm:jar:9.0:compile", "org.ow2.asm:asm-commons:jar:9.0:compile", "org.ow2.asm:asm-tree:jar:9.0:compile", "org.ow2.asm:asm-analysis:jar:9.0:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.34.v20201102:compile", "org.glassfish:jakarta.el:jar:3.0.3:compile");
            mvnSpringBoot25JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:2.5.0:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.4:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.1.2:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.46:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-http:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-util:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-io:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-security:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-server:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-util-ajax:jar:9.4.41.v20210516:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.41.v20210516:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.41.v20210516:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.41.v20210516:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-client:jar:9.4.41.v20210516:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.41.v20210516:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.41.v20210516:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.41.v20210516:compile", "org.ow2.asm:asm:jar:9.0:compile", "org.ow2.asm:asm-commons:jar:9.0:compile", "org.ow2.asm:asm-tree:jar:9.0:compile", "org.ow2.asm:asm-analysis:jar:9.0:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.41.v20210516:compile");
            mvnSpringBoot26JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:2.6.6:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.4:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.1.2:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.60:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-http:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-util:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-io:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-security:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-server:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-util-ajax:jar:9.4.45.v20220203:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.45.v20220203:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.45.v20220203:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.45.v20220203:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-client:jar:9.4.45.v20220203:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.45.v20220203:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.45.v20220203:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.45.v20220203:compile", "org.ow2.asm:asm:jar:9.2:compile", "org.ow2.asm:asm-commons:jar:9.2:compile", "org.ow2.asm:asm-tree:jar:9.2:compile", "org.ow2.asm:asm-analysis:jar:9.2:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.45.v20220203:compile");
            mvnSpringBoot27JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:2.7.1:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.4:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.1.2:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.64:compile", "org.eclipse.jetty:jetty-servlets:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-continuation:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-http:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-util:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-io:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-webapp:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-xml:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-servlet:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-security:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-server:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-util-ajax:jar:9.4.48.v20220622:compile", "org.eclipse.jetty.websocket:websocket-server:jar:9.4.48.v20220622:compile", "org.eclipse.jetty.websocket:websocket-common:jar:9.4.48.v20220622:compile", "org.eclipse.jetty.websocket:websocket-api:jar:9.4.48.v20220622:compile", "org.eclipse.jetty.websocket:websocket-client:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-client:jar:9.4.48.v20220622:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:9.4.48.v20220622:compile", "org.eclipse.jetty.websocket:javax-websocket-server-impl:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-annotations:jar:9.4.48.v20220622:compile", "org.eclipse.jetty:jetty-plus:jar:9.4.48.v20220622:compile", "org.ow2.asm:asm:jar:9.3:compile", "org.ow2.asm:asm-commons:jar:9.3:compile", "org.ow2.asm:asm-tree:jar:9.3:compile", "org.ow2.asm:asm-analysis:jar:9.3:compile", "org.eclipse.jetty.websocket:javax-websocket-client-impl:jar:9.4.48.v20220622:compile");
            mvnSpringBoot30JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:3.0.0:compile", "jakarta.transaction:jakarta.transaction-api:jar:2.0.0:compile", "org.eclipse.jetty:jetty-util:jar:11.0.12:compile", "org.eclipse.jetty:jetty-plus:jar:11.0.12:compile", "org.ow2.asm:asm-commons:jar:9.3:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.0:compile", "org.eclipse.jetty.websocket:websocket-jetty-api:jar:11.0.12:compile", "org.eclipse.jetty:jetty-client:jar:11.0.12:compile", "org.eclipse.jetty:jetty-jndi:jar:11.0.12:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.eclipse.jetty:jetty-annotations:jar:11.0.12:compile", "org.eclipse.jetty.websocket:websocket-core-client:jar:11.0.12:compile", "org.eclipse.jetty.websocket:websocket-jakarta-server:jar:11.0.12:compile", "org.ow2.asm:asm:jar:9.3:compile", "org.eclipse.jetty:jetty-http:jar:11.0.12:compile", "org.eclipse.jetty:jetty-servlets:jar:11.0.12:compile", "org.ow2.asm:asm-analysis:jar:9.3:compile", "org.slf4j:slf4j-api:jar:2.0.0:compile", "org.eclipse.jetty:jetty-alpn-client:jar:11.0.12:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.1:compile", "org.eclipse.jetty.websocket:websocket-core-server:jar:11.0.12:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:11.0.12:compile", "org.eclipse.jetty.websocket:websocket-core-common:jar:11.0.12:compile", "org.eclipse.jetty.websocket:websocket-jetty-server:jar:11.0.12:compile", "org.eclipse.jetty.websocket:websocket-jakarta-common:jar:11.0.12:compile", "org.eclipse.jetty:jetty-io:jar:11.0.12:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.0:compile", "org.eclipse.jetty:jetty-server:jar:11.0.12:compile", "org.eclipse.jetty:jetty-security:jar:11.0.12:compile", "org.eclipse.jetty:jetty-webapp:jar:11.0.12:compile", "org.eclipse.jetty.websocket:websocket-jetty-common:jar:11.0.12:compile", "org.eclipse.jetty.websocket:websocket-jakarta-client:jar:11.0.12:compile", "org.ow2.asm:asm-tree:jar:9.3:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "org.eclipse.jetty:jetty-xml:jar:11.0.12:compile", "org.eclipse.jetty:jetty-servlet:jar:11.0.12:compile");
            mvnSpringBoot31JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:3.1.0:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.0:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.0:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.8:compile", "org.eclipse.jetty:jetty-servlets:jar:11.0.15:compile", "org.eclipse.jetty:jetty-http:jar:11.0.15:compile", "org.eclipse.jetty:jetty-util:jar:11.0.15:compile", "org.eclipse.jetty:jetty-io:jar:11.0.15:compile", "org.slf4j:slf4j-api:jar:2.0.7:compile", "org.eclipse.jetty:jetty-webapp:jar:11.0.15:compile", "org.eclipse.jetty:jetty-servlet:jar:11.0.15:compile", "org.eclipse.jetty:jetty-security:jar:11.0.15:compile", "org.eclipse.jetty:jetty-server:jar:11.0.15:compile", "org.eclipse.jetty:jetty-xml:jar:11.0.15:compile", "org.eclipse.jetty.websocket:websocket-jakarta-server:jar:11.0.15:compile", "org.eclipse.jetty.websocket:websocket-jakarta-client:jar:11.0.15:compile", "org.eclipse.jetty.websocket:websocket-jakarta-common:jar:11.0.15:compile", "org.eclipse.jetty.websocket:websocket-core-client:jar:11.0.15:compile", "org.eclipse.jetty:jetty-client:jar:11.0.15:compile", "org.eclipse.jetty:jetty-alpn-client:jar:11.0.15:compile", "org.eclipse.jetty.websocket:websocket-servlet:jar:11.0.15:compile", "org.eclipse.jetty.websocket:websocket-core-server:jar:11.0.15:compile", "org.eclipse.jetty:jetty-annotations:jar:11.0.15:compile", "org.eclipse.jetty:jetty-plus:jar:11.0.15:compile", "jakarta.transaction:jakarta.transaction-api:jar:2.0.1:compile", "org.eclipse.jetty:jetty-jndi:jar:11.0.15:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.ow2.asm:asm:jar:9.5:compile", "org.ow2.asm:asm-commons:jar:9.5:compile", "org.ow2.asm:asm-tree:jar:9.5:compile", "org.eclipse.jetty.websocket:websocket-jetty-server:jar:11.0.15:compile", "org.eclipse.jetty.websocket:websocket-jetty-api:jar:11.0.15:compile", "org.eclipse.jetty.websocket:websocket-jetty-common:jar:11.0.15:compile", "org.eclipse.jetty.websocket:websocket-core-common:jar:11.0.15:compile");
            mvnSpringBoot32JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:3.2.1:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "jakarta.transaction:jakarta.transaction-api:jar:2.0.1:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.1:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.17:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-client:jar:12.0.5:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-common:jar:12.0.5:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-server:jar:12.0.5:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jetty-server:jar:12.0.5:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-servlet:jar:12.0.5:compile", "org.eclipse.jetty.ee10:jetty-ee10-annotations:jar:12.0.5:compile", "org.eclipse.jetty.ee10:jetty-ee10-plus:jar:12.0.5:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlet:jar:12.0.5:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlets:jar:12.0.5:compile", "org.eclipse.jetty.ee10:jetty-ee10-webapp:jar:12.0.5:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-client:jar:12.0.5:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-common:jar:12.0.5:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-server:jar:12.0.5:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-api:jar:12.0.5:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-common:jar:12.0.5:compile", "org.eclipse.jetty:jetty-alpn-client:jar:12.0.5:compile", "org.eclipse.jetty:jetty-client:jar:12.0.5:compile", "org.eclipse.jetty:jetty-http:jar:12.0.5:compile", "org.eclipse.jetty:jetty-io:jar:12.0.5:compile", "org.eclipse.jetty:jetty-jndi:jar:12.0.5:compile", "org.eclipse.jetty:jetty-plus:jar:12.0.5:compile", "org.eclipse.jetty:jetty-security:jar:12.0.5:compile", "org.eclipse.jetty:jetty-server:jar:12.0.5:compile", "org.eclipse.jetty:jetty-session:jar:12.0.5:compile", "org.eclipse.jetty:jetty-util:jar:12.0.5:compile", "org.eclipse.jetty:jetty-xml:jar:12.0.5:compile", "org.ow2.asm:asm-commons:jar:9.6:compile", "org.ow2.asm:asm-tree:jar:9.6:compile", "org.ow2.asm:asm:jar:9.6:compile", "org.slf4j:slf4j-api:jar:2.0.9:compile");
            mvnSpringBoot33JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:3.3.0:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.1:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.24:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlets:jar:12.0.9:compile", "org.eclipse.jetty:jetty-http:jar:12.0.9:compile", "org.eclipse.jetty:jetty-io:jar:12.0.9:compile", "org.eclipse.jetty:jetty-util:jar:12.0.9:compile", "org.slf4j:slf4j-api:jar:2.0.13:compile", "org.eclipse.jetty.ee10:jetty-ee10-webapp:jar:12.0.9:compile", "org.eclipse.jetty:jetty-ee:jar:12.0.9:compile", "org.eclipse.jetty:jetty-server:jar:12.0.9:compile", "org.eclipse.jetty:jetty-session:jar:12.0.9:compile", "org.eclipse.jetty:jetty-xml:jar:12.0.9:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlet:jar:12.0.9:compile", "org.eclipse.jetty:jetty-security:jar:12.0.9:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-server:jar:12.0.9:compile", "org.eclipse.jetty.ee10:jetty-ee10-annotations:jar:12.0.9:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.eclipse.jetty.ee10:jetty-ee10-plus:jar:12.0.9:compile", "jakarta.enterprise:jakarta.enterprise.cdi-api:jar:4.0.1:compile", "jakarta.inject:jakarta.inject-api:jar:2.0.1:compile", "jakarta.enterprise:jakarta.enterprise.lang-model:jar:4.0.1:compile", "jakarta.interceptor:jakarta.interceptor-api:jar:2.1.0:compile", "jakarta.transaction:jakarta.transaction-api:jar:2.0.1:compile", "org.eclipse.jetty:jetty-plus:jar:12.0.9:compile", "org.ow2.asm:asm:jar:9.7:compile", "org.ow2.asm:asm-commons:jar:9.7:compile", "org.ow2.asm:asm-tree:jar:9.7:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-client:jar:12.0.9:compile", "org.eclipse.jetty:jetty-client:jar:12.0.9:compile", "org.eclipse.jetty:jetty-alpn-client:jar:12.0.9:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-common:jar:12.0.9:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-client:jar:12.0.9:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-servlet:jar:12.0.9:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-server:jar:12.0.9:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jetty-server:jar:12.0.9:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-api:jar:12.0.9:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-common:jar:12.0.9:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-common:jar:12.0.9:compile");
            mvnSpringBoot34JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:3.4.0:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.1:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.33:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlets:jar:12.0.15:compile", "org.eclipse.jetty:jetty-http:jar:12.0.15:compile", "org.eclipse.jetty:jetty-io:jar:12.0.15:compile", "org.eclipse.jetty:jetty-util:jar:12.0.15:compile", "org.slf4j:slf4j-api:jar:2.0.16:compile", "org.eclipse.jetty.ee10:jetty-ee10-webapp:jar:12.0.15:compile", "org.eclipse.jetty:jetty-ee:jar:12.0.15:compile", "org.eclipse.jetty:jetty-server:jar:12.0.15:compile", "org.eclipse.jetty:jetty-session:jar:12.0.15:compile", "org.eclipse.jetty:jetty-xml:jar:12.0.15:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlet:jar:12.0.15:compile", "org.eclipse.jetty:jetty-security:jar:12.0.15:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-server:jar:12.0.15:compile", "org.eclipse.jetty.ee10:jetty-ee10-annotations:jar:12.0.15:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.eclipse.jetty.ee10:jetty-ee10-plus:jar:12.0.15:compile", "jakarta.enterprise:jakarta.enterprise.cdi-api:jar:4.0.1:compile", "jakarta.inject:jakarta.inject-api:jar:2.0.1:compile", "jakarta.enterprise:jakarta.enterprise.lang-model:jar:4.0.1:compile", "jakarta.interceptor:jakarta.interceptor-api:jar:2.1.0:compile", "jakarta.transaction:jakarta.transaction-api:jar:2.0.1:compile", "org.eclipse.jetty:jetty-plus:jar:12.0.15:compile", "org.ow2.asm:asm:jar:9.7.1:compile", "org.ow2.asm:asm-commons:jar:9.7.1:compile", "org.ow2.asm:asm-tree:jar:9.7.1:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-client:jar:12.0.15:compile", "org.eclipse.jetty:jetty-client:jar:12.0.15:compile", "org.eclipse.jetty:jetty-alpn-client:jar:12.0.15:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-common:jar:12.0.15:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-client:jar:12.0.15:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-servlet:jar:12.0.15:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-server:jar:12.0.15:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jetty-server:jar:12.0.15:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-api:jar:12.0.15:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-common:jar:12.0.15:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-common:jar:12.0.15:compile");
            mvnSpringBoot35JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:3.5.3:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.1:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.42:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlets:jar:12.0.22:compile", "org.eclipse.jetty:jetty-http:jar:12.0.22:compile", "org.eclipse.jetty:jetty-io:jar:12.0.22:compile", "org.eclipse.jetty:jetty-util:jar:12.0.22:compile", "org.slf4j:slf4j-api:jar:2.0.17:compile", "org.eclipse.jetty.ee10:jetty-ee10-webapp:jar:12.0.22:compile", "org.eclipse.jetty:jetty-ee:jar:12.0.22:compile", "org.eclipse.jetty:jetty-server:jar:12.0.22:compile", "org.eclipse.jetty:jetty-session:jar:12.0.22:compile", "org.eclipse.jetty:jetty-xml:jar:12.0.22:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlet:jar:12.0.22:compile", "org.eclipse.jetty:jetty-security:jar:12.0.22:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-server:jar:12.0.22:compile", "org.eclipse.jetty.ee10:jetty-ee10-annotations:jar:12.0.22:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.eclipse.jetty.ee10:jetty-ee10-plus:jar:12.0.22:compile", "jakarta.enterprise:jakarta.enterprise.cdi-api:jar:4.0.1:compile", "jakarta.inject:jakarta.inject-api:jar:2.0.1:compile", "jakarta.enterprise:jakarta.enterprise.lang-model:jar:4.0.1:compile", "jakarta.interceptor:jakarta.interceptor-api:jar:2.1.0:compile", "jakarta.transaction:jakarta.transaction-api:jar:2.0.1:compile", "org.eclipse.jetty:jetty-plus:jar:12.0.22:compile", "org.ow2.asm:asm:jar:9.8:compile", "org.ow2.asm:asm-commons:jar:9.8:compile", "org.ow2.asm:asm-tree:jar:9.8:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-client:jar:12.0.22:compile", "org.eclipse.jetty:jetty-client:jar:12.0.22:compile", "org.eclipse.jetty:jetty-alpn-client:jar:12.0.22:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-common:jar:12.0.22:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-client:jar:12.0.22:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-servlet:jar:12.0.22:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-server:jar:12.0.22:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jetty-server:jar:12.0.22:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-api:jar:12.0.22:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-common:jar:12.0.22:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-common:jar:12.0.22:compile");
            mvnSpringBoot40JettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-jetty:jar:4.0.0-M1:compile", "jakarta.annotation:jakarta.annotation-api:jar:3.0.0:compile", "org.springframework.boot:spring-boot-jetty:jar:4.0.0-M1:compile", "io.micrometer:micrometer-observation:jar:1.16.0-M1:compile", "io.micrometer:micrometer-commons:jar:1.16.0-M1:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlets:jar:12.0.23:compile", "org.eclipse.jetty:jetty-http:jar:12.0.23:compile", "org.eclipse.jetty:jetty-io:jar:12.0.23:compile", "org.eclipse.jetty:jetty-util:jar:12.0.23:compile", "org.eclipse.jetty.ee10:jetty-ee10-webapp:jar:12.0.23:compile", "org.eclipse.jetty:jetty-ee:jar:12.0.23:compile", "org.eclipse.jetty:jetty-session:jar:12.0.23:compile", "org.eclipse.jetty:jetty-xml:jar:12.0.23:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.1.0:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.2.0:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.2.0:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:11.0.9:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-server:jar:12.0.23:compile", "org.eclipse.jetty.ee10:jetty-ee10-annotations:jar:12.0.23:compile", "org.eclipse.jetty.ee10:jetty-ee10-plus:jar:12.0.23:compile", "jakarta.enterprise:jakarta.enterprise.cdi-api:jar:4.0.1:compile", "jakarta.inject:jakarta.inject-api:jar:2.0.1:compile", "jakarta.enterprise:jakarta.enterprise.lang-model:jar:4.0.1:compile", "jakarta.interceptor:jakarta.interceptor-api:jar:2.1.0:compile", "jakarta.transaction:jakarta.transaction-api:jar:2.0.1:compile", "org.eclipse.jetty:jetty-plus:jar:12.0.23:compile", "org.ow2.asm:asm:jar:9.8:compile", "org.ow2.asm:asm-commons:jar:9.8:compile", "org.ow2.asm:asm-tree:jar:9.8:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-client:jar:12.0.23:compile", "org.eclipse.jetty:jetty-client:jar:12.0.23:compile", "org.eclipse.jetty:jetty-alpn-client:jar:12.0.23:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jakarta-common:jar:12.0.23:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-client:jar:12.0.23:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-servlet:jar:12.0.23:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-server:jar:12.0.23:compile", "org.slf4j:slf4j-api:jar:2.0.17:compile", "org.eclipse.jetty.ee10.websocket:jetty-ee10-websocket-jetty-server:jar:12.0.23:compile", "org.eclipse.jetty.ee10:jetty-ee10-servlet:jar:12.0.23:compile", "org.eclipse.jetty:jetty-security:jar:12.0.23:compile", "org.eclipse.jetty:jetty-server:jar:12.0.23:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-api:jar:12.0.23:compile", "org.eclipse.jetty.websocket:jetty-websocket-jetty-common:jar:12.0.23:compile", "org.eclipse.jetty.websocket:jetty-websocket-core-common:jar:12.0.23:compile");
            mvnSpringBoot15UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:1.5.10.RELEASE:compile", "org.jboss.xnio:xnio-api:jar:3.3.8.Final:compile", "org.jboss.logging:jboss-logging:jar:3.3.1.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:3.1.0:compile", "org.jboss.spec.javax.annotation:jboss-annotations-api_1.2_spec:jar:1.0.0.Final:compile", "io.undertow:undertow-websockets-jsr:jar:1.4.22.Final:compile", "org.glassfish:jakarta.el:jar:3.0.0:compile", "org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec:jar:1.1.0.Final:compile", "io.undertow:undertow-core:jar:1.4.22.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.3.8.Final:runtime", "io.undertow:undertow-servlet:jar:1.4.22.Final:compile");
            mvnSpringBoot20UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:2.0.1.RELEASE:compile", "io.undertow:undertow-core:jar:1.4.23.Final:compile", "org.jboss.logging:jboss-logging:jar:3.3.2.Final:compile", "org.jboss.xnio:xnio-api:jar:3.3.8.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.3.8.Final:runtime", "io.undertow:undertow-servlet:jar:1.4.23.Final:compile", "org.jboss.spec.javax.annotation:jboss-annotations-api_1.2_spec:jar:1.0.2.Final:compile", "io.undertow:undertow-websockets-jsr:jar:1.4.23.Final:compile", "org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec:jar:1.1.3.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:3.1.0:compile", "org.glassfish:jakarta.el:jar:3.0.0:compile");
            mvnSpringBoot21UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:2.1.2.RELEASE:compile", "io.undertow:undertow-core:jar:2.0.16.Final:compile", "org.jboss.logging:jboss-logging:jar:3.3.2.Final:compile", "org.jboss.xnio:xnio-api:jar:3.3.8.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.3.8.Final:runtime", "io.undertow:undertow-servlet:jar:2.0.16.Final:compile", "org.jboss.spec.javax.annotation:jboss-annotations-api_1.2_spec:jar:1.0.2.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.0.16.Final:compile", "org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec:jar:1.1.3.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.1:compile", "org.glassfish:jakarta.el:jar:3.0.0:compile");
            mvnSpringBoot22UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:2.2.6.RELEASE:compile", "io.undertow:undertow-core:jar:2.0.30.Final:compile", "org.jboss.logging:jboss-logging:jar:3.4.1.Final:compile", "org.jboss.xnio:xnio-api:jar:3.3.8.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.3.8.Final:runtime", "io.undertow:undertow-servlet:jar:2.0.30.Final:compile", "org.jboss.spec.javax.annotation:jboss-annotations-api_1.2_spec:jar:1.0.2.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.0.30.Final:compile", "org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec:jar:1.1.4.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.3:compile", "org.glassfish:jakarta.el:jar:3.0.3:compile");
            mvnSpringBoot23UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:2.3.0.RELEASE:compile", "io.undertow:undertow-core:jar:2.1.0.Final:compile", "org.jboss.logging:jboss-logging:jar:3.4.1.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.0.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.2.Final:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.0.Final:runtime", "org.jboss.threads:jboss-threads:jar:3.1.0.Final:compile", "io.undertow:undertow-servlet:jar:2.1.0.Final:compile", "org.jboss.spec.javax.annotation:jboss-annotations-api_1.3_spec:jar:2.0.1.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.1.0.Final:compile", "org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec:jar:2.0.0.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.3:compile", "org.glassfish:jakarta.el:jar:3.0.3:compile");
            mvnSpringBoot24UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:2.4.0:compile", "io.undertow:undertow-core:jar:2.2.2.Final:compile", "org.jboss.logging:jboss-logging:jar:3.4.1.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.0.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.2.Final:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.0.Final:runtime", "org.jboss.threads:jboss-threads:jar:3.1.0.Final:compile", "io.undertow:undertow-servlet:jar:2.2.2.Final:compile", "org.jboss.spec.javax.annotation:jboss-annotations-api_1.3_spec:jar:2.0.1.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.2.2.Final:compile", "org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec:jar:2.0.0.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.4:compile", "org.glassfish:jakarta.el:jar:3.0.3:compile");
            mvnSpringBoot25UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:2.5.0:compile", "io.undertow:undertow-core:jar:2.2.7.Final:compile", "org.jboss.logging:jboss-logging:jar:3.4.1.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.0.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.2.Final:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.0.Final:runtime", "org.jboss.threads:jboss-threads:jar:3.1.0.Final:compile", "io.undertow:undertow-servlet:jar:2.2.7.Final:compile", "org.jboss.spec.javax.annotation:jboss-annotations-api_1.3_spec:jar:2.0.1.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.2.7.Final:compile", "org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec:jar:2.0.0.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.4:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.46:compile");
            mvnSpringBoot26UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:2.6.6:compile", "io.undertow:undertow-core:jar:2.2.16.Final:compile", "org.jboss.logging:jboss-logging:jar:3.4.3.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.6.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.4.Final:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.6.Final:runtime", "org.jboss.threads:jboss-threads:jar:3.1.0.Final:compile", "io.undertow:undertow-servlet:jar:2.2.16.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.2.16.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.4:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.1.2:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.60:compile");
            mvnSpringBoot27UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:2.7.1:compile", "io.undertow:undertow-core:jar:2.2.18.Final:compile", "org.jboss.logging:jboss-logging:jar:3.4.3.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.7.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.4.Final:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.7.Final:runtime", "org.jboss.threads:jboss-threads:jar:3.1.0.Final:compile", "io.undertow:undertow-servlet:jar:2.2.18.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.2.18.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:4.0.4:compile", "jakarta.websocket:jakarta.websocket-api:jar:1.1.2:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:9.0.64:compile");
            mvnSpringBoot30UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:3.0.0:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.8.Final:runtime", "org.jboss.xnio:xnio-api:jar:3.8.8.Final:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.1:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.0:compile", "org.jboss.logging:jboss-logging:jar:3.4.3.Final:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.0:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.wildfly.common:wildfly-common:jar:1.5.4.Final:compile", "io.undertow:undertow-core:jar:2.3.0.Final:compile", "org.jboss.threads:jboss-threads:jar:3.5.0.Final:compile", "io.undertow:undertow-servlet:jar:2.3.0.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.3.0.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile");
            mvnSpringBoot31UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:3.1.7:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.8.Final:runtime", "org.jboss.xnio:xnio-api:jar:3.8.8.Final:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.17:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.1:compile", "org.jboss.logging:jboss-logging:jar:3.5.3.Final:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.1:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "org.wildfly.common:wildfly-common:jar:1.5.4.Final:compile", "io.undertow:undertow-core:jar:2.3.10.Final:compile", "org.jboss.threads:jboss-threads:jar:3.5.0.Final:compile", "io.undertow:undertow-servlet:jar:2.3.10.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.3.10.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile");
            mvnSpringBoot32UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:3.2.1:compile", "io.undertow:undertow-core:jar:2.3.10.Final:compile", "io.undertow:undertow-servlet:jar:2.3.10.Final:compile", "io.undertow:undertow-websockets-jsr:jar:2.3.10.Final:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.1:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.1:compile", "org.jboss.logging:jboss-logging:jar:3.5.3.Final:compile", "org.jboss.threads:jboss-threads:jar:3.5.0.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.8.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.8.Final:runtime", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.4.Final:compile");
            mvnSpringBoot33UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:3.3.0:compile", "io.undertow:undertow-core:jar:2.3.13.Final:compile", "org.jboss.logging:jboss-logging:jar:3.5.3.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.8.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.4.Final:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.8.Final:runtime", "org.jboss.threads:jboss-threads:jar:3.5.0.Final:compile", "io.undertow:undertow-servlet:jar:2.3.13.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "io.undertow:undertow-websockets-jsr:jar:2.3.13.Final:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.1:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.24:compile");
            mvnSpringBoot34UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:3.4.0:compile", "io.undertow:undertow-core:jar:2.3.18.Final:compile", "org.jboss.logging:jboss-logging:jar:3.6.1.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.16.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.4.Final:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.16.Final:runtime", "org.jboss.threads:jboss-threads:jar:3.5.0.Final:compile", "io.undertow:undertow-servlet:jar:2.3.18.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "io.undertow:undertow-websockets-jsr:jar:2.3.18.Final:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.1:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.33:compile");
            mvnSpringBoot35UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:3.5.3:compile", "io.undertow:undertow-core:jar:2.3.18.Final:compile", "org.jboss.logging:jboss-logging:jar:3.6.1.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.16.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.4.Final:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.16.Final:runtime", "org.jboss.threads:jboss-threads:jar:3.5.0.Final:compile", "io.undertow:undertow-servlet:jar:2.3.18.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "jakarta.annotation:jakarta.annotation-api:jar:2.1.1:compile", "io.undertow:undertow-websockets-jsr:jar:2.3.18.Final:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.1:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.1:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:10.1.42:compile");
            mvnSpringBoot40UndertowStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-undertow:jar:4.0.0-M1:compile", "jakarta.annotation:jakarta.annotation-api:jar:3.0.0:compile", "org.springframework.boot:spring-boot-undertow:jar:4.0.0-M1:compile", "io.micrometer:micrometer-observation:jar:1.16.0-M1:compile", "io.micrometer:micrometer-commons:jar:1.16.0-M1:compile", "io.undertow:undertow-servlet:jar:2.3.18.Final:compile", "io.undertow:undertow-core:jar:2.3.18.Final:compile", "org.jboss.logging:jboss-logging:jar:3.4.3.Final:compile", "org.jboss.xnio:xnio-api:jar:3.8.16.Final:compile", "org.wildfly.common:wildfly-common:jar:1.5.4.Final:compile", "org.wildfly.client:wildfly-client-config:jar:1.0.1.Final:compile", "org.jboss.xnio:xnio-nio:jar:3.8.16.Final:runtime", "org.jboss.threads:jboss-threads:jar:3.5.0.Final:compile", "jakarta.servlet:jakarta.servlet-api:jar:6.0.0:compile", "io.undertow:undertow-websockets-jsr:jar:2.3.18.Final:compile", "jakarta.websocket:jakarta.websocket-api:jar:2.1.0:compile", "jakarta.websocket:jakarta.websocket-client-api:jar:2.1.0:compile", "org.apache.tomcat.embed:tomcat-embed-el:jar:11.0.9:compile");
            mvnSpringBoot20NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:2.0.1.RELEASE:compile");
            mvnSpringBoot21NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:2.1.2.RELEASE:compile");
            mvnSpringBoot22NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:2.2.6.RELEASE:compile");
            mvnSpringBoot23NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:2.3.0.RELEASE:compile");
            mvnSpringBoot24NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:2.4.0:compile");
            mvnSpringBoot25NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:2.5.0:compile");
            mvnSpringBoot26NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:2.6.6:compile");
            mvnSpringBoot27NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:2.7.1:compile");
            mvnSpringBoot30NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:3.0.0:compile");
            mvnSpringBoot31NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:3.1.0:compile");
            mvnSpringBoot32NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:3.2.1:compile");
            mvnSpringBoot33NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:3.3.0:compile");
            mvnSpringBoot34NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:3.4.0:compile");
            mvnSpringBoot35NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:3.5.3:compile");
            mvnSpringBoot40NettyStarterDeps = Arrays.asList("org.springframework.boot:spring-boot-starter-reactor-netty:jar:4.0.0-M1:compile");
            HashMap<String, Set<String>> theMap = new HashMap<String, Set<String>>();
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "1.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot15TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "2.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot20TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "2.1"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot21TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "2.2"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot22TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "2.3"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot23TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "2.4"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot24TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "2.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot25TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "2.6"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot26TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "2.7"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot27TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "3.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot30TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "3.1"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot31TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "3.2"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot32TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "3.3"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot33TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "3.4"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot34TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "3.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot35TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(TOMCAT, "4.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot40TomcatStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "1.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot15JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "2.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot20JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "2.1"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot21JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "2.2"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot22JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "2.3"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot23JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "2.4"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot24JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "2.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot25JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "2.6"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot26JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "2.7"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot27JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "3.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot30JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "3.1"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot31JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "3.2"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot32JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "3.3"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot33JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "3.4"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot34JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "3.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot35JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(JETTY, "4.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot40JettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "1.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot15UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "2.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot20UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "2.1"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot21UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "2.2"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot22UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "2.3"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot23UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "2.4"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot24UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "2.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot25UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "2.6"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot26UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "2.7"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot27UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "3.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot30UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "3.1"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot31UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "3.2"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot32UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "3.3"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot33UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "3.4"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot34UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "3.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot35UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(UNDERTOW, "4.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot40UndertowStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "2.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot20NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "2.1"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot21NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "2.2"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot22NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "2.3"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot23NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "2.4"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot24NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "2.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot25NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "2.6"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot26NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "2.7"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot27NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "3.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot30NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "3.1"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot31NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "3.2"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot32NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "3.3"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot33NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "3.4"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot34NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "3.5"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot35NettyStarterDeps));
            theMap.put(EmbeddedContainer.starterJarNamePrefix(NETTY, "4.0"), EmbeddedContainer.loadStarterMvnDeps(mvnSpringBoot40NettyStarterDeps));
            startersToDependentArtifactIdsMap = Collections.unmodifiableMap(theMap);
        }
    }

    public static enum Container {
        TOMCAT("tomcat-embed-core"),
        JETTY("jetty-io"),
        UNDERTOW("undertow-core"),
        NETTY("netty");

        public final String coreContainerJar;

        private Container(String coreContainerJar) {
            this.coreContainerJar = coreContainerJar;
        }

        public String getCoreContainerJar() {
            return this.coreContainerJar;
        }
    }
}

