/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest.v1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ui.internal.rest.AdminCenterRestHandler;
import com.ibm.ws.ui.internal.rest.CommonJSONRESTHandler;
import com.ibm.ws.ui.internal.rest.exceptions.MethodNotSupportedException;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.rest.exceptions.UserNotAuthorizedException;
import com.ibm.ws.ui.internal.rest.v1.V1Constants;
import com.ibm.ws.ui.internal.v1.IFeatureToolService;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IconRestHandler
extends CommonJSONRESTHandler
implements V1Constants {
    private static final TraceComponent tc = Tr.register(IconRestHandler.class);
    private static final String defaultIconPath = "/images/tools/";
    private static final String defaultIconPrefix = "defaultTool_";
    private static final String defaultIconSuffix = "png";
    private static final int defaultIconSize = 142;
    private static final String defaultFeatureRestURI = "default";
    private static final String sizesRestURI = "sizes";
    private static final Set<Integer> defaultIconSizes = new HashSet<Integer>(Arrays.asList(142, 78, 52, 28));
    private transient IFeatureToolService featureToolService = null;
    private static final Set<String> validIconTypes = new HashSet<String>(Arrays.asList("png", "jpg", "jpeg", "gif"));

    public IconRestHandler(IFeatureToolService featureToolService) {
        super("/adminCenter/v1/icons", true, true);
        this.featureToolService = featureToolService;
    }

    @Override
    public Object getBase(RESTRequest request, RESTResponse response) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public Object getChild(RESTRequest request, RESTResponse response, String childResource) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        return this.processChild(request, false);
    }

    @Override
    public Object getGrandchild(RESTRequest request, RESTResponse response, String child, String grandchild) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        return this.processChild(request, true);
    }

    private Object processChild(RESTRequest request, boolean isGrandChild) {
        Object responseResult = null;
        String[] urlElements = request.getPath().split("/");
        String featureOrEndpointName = urlElements[urlElements.length - 1];
        String featureName = isGrandChild ? urlElements[urlElements.length - 2] + "/" + featureOrEndpointName : featureOrEndpointName;
        String queryString = request.getQueryString();
        if (queryString != null && sizesRestURI.equalsIgnoreCase(queryString)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Finding icon sizes for " + featureName), (Object[])new Object[0]);
            }
            responseResult = this.getSizes(featureName);
        } else if (queryString != null && queryString.toLowerCase().startsWith("size=")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Finding icon size " + queryString.substring(5) + " for " + featureName), (Object[])new Object[0]);
            }
            responseResult = this.getIcon(featureName, queryString.substring(5));
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Finding default icon for " + featureName), (Object[])new Object[0]);
            }
            responseResult = this.getIcon(featureName, "0");
        }
        return responseResult;
    }

    private Set<Integer> getSizes(String featureName) {
        HashSet<Integer> sizes = new HashSet<Integer>();
        if (defaultFeatureRestURI.equals(featureName)) {
            sizes.addAll(defaultIconSizes);
        } else {
            sizes.addAll(this.getFeatureToolIconInfo(featureName).keySet());
        }
        return sizes;
    }

    private Map<Integer, String> processIconHeader(String iconHeader, String featureSymbolicName, String iconLocation) {
        HashMap<Integer, String> iconMapping = new HashMap<Integer, String>();
        if (iconHeader != null) {
            String[] icons;
            if (iconLocation == null) {
                iconLocation = "";
            }
            for (String iconDirective : icons = iconHeader.split(",")) {
                String[] iconDirectives = iconDirective.split(";");
                String relativeIconURI = iconDirectives[0].trim();
                Integer iconSize = 0;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Icon URI " + relativeIconURI), (Object[])new Object[0]);
                }
                if (iconDirectives.length > 1) {
                    String iconSizeString = iconDirectives[1].trim();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Icon Directive " + iconSizeString), (Object[])new Object[0]);
                    }
                    if (iconSizeString != null && iconSizeString.startsWith("size=")) {
                        try {
                            iconSize = new Integer(iconSizeString.substring(5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                File installPrefix = new File(iconLocation, featureSymbolicName);
                File iconURL = new File(installPrefix, relativeIconURI.trim());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Icon Absolute URL " + iconURL.getAbsolutePath()), (Object[])new Object[0]);
                }
                if (iconURL.getAbsolutePath().startsWith(installPrefix.getAbsolutePath())) {
                    iconMapping.put(iconSize, iconURL.getAbsolutePath());
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Icon URL " + iconURL.getAbsolutePath() + " is not mapping to the Standard Icons Dir. We will not be adding the url to the map, and so feature + " + featureSymbolicName + " will use the default icons."), (Object[])new Object[0]);
            }
        }
        return iconMapping;
    }

    private synchronized Map<Integer, String> getFeatureToolIconInfo(String featureName) {
        Map<Integer, String> iconInfo = new HashMap<Integer, String>();
        if (this.featureToolService != null) {
            Map<String, String> allIconMap = this.featureToolService.getIconMap();
            String iconHeader = allIconMap.get(featureName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Icon header for " + featureName + ": " + iconHeader), (Object[])new Object[0]);
            }
            if (iconHeader != null) {
                String iconInstallLocation = this.featureToolService.getFeatureIconInstallDir(featureName);
                iconInfo = this.processIconHeader(iconHeader, featureName, iconInstallLocation);
            }
        }
        return iconInfo;
    }

    private IconImage getIcon(String featureName, String sizeString) {
        IconImage image = null;
        Integer size = 0;
        try {
            size = Integer.valueOf(sizeString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (size < 0) {
            size = 0;
        }
        final Integer iconSize = size;
        if (defaultFeatureRestURI.equals(featureName)) {
            image = this.getDefaultIcon(size);
        } else {
            Map<Integer, String> iconInfo = this.getFeatureToolIconInfo(featureName);
            final String iconFileName = iconInfo.get(size) != null ? iconInfo.get(size) : iconInfo.get(142);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Icon FileName: " + iconFileName), (Object[])new Object[0]);
            }
            image = iconFileName != null ? AccessController.doPrivileged(new PrivilegedAction<IconImage>(){

                @Override
                public IconImage run() {
                    IconImage returnImage = null;
                    File iconFile = new File(iconFileName);
                    String iconType = iconFile.getName().substring(iconFile.getName().lastIndexOf(".") + 1);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Icon FileName: " + iconFile.getAbsolutePath() + " - Exists?: " + iconFile.exists() + " - IsFile: " + iconFile.isFile() + " - IconType: " + iconType), (Object[])new Object[0]);
                    }
                    if (iconFile.exists() && iconFile.isFile() && validIconTypes.contains(iconType)) {
                        byte[] iconBytes = IconRestHandler.this.readIconFile(iconFile);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("IconBytes length: " + iconBytes.length), (Object[])new Object[0]);
                        }
                        returnImage = iconBytes != null && iconBytes.length > 0 ? new IconImage(iconType, iconBytes) : IconRestHandler.this.getDefaultIcon(iconSize);
                    } else {
                        returnImage = IconRestHandler.this.getDefaultIcon(iconSize);
                    }
                    return returnImage;
                }
            }) : this.getDefaultIcon(iconSize);
        }
        return image;
    }

    private IconImage getDefaultIcon(Integer size) {
        Integer sizeToUse = 142;
        if (defaultIconSizes.contains(size)) {
            sizeToUse = size;
        }
        final String iconPath = "/images/tools/defaultTool_" + sizeToUse + "x" + sizeToUse + "." + defaultIconSuffix;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("IconPath: " + iconPath), (Object[])new Object[0]);
        }
        byte[] imageBytes = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] run() {
                byte[] imageBytes = null;
                InputStream iconIS = null;
                try {
                    iconIS = this.getClass().getResourceAsStream(iconPath);
                    imageBytes = IconRestHandler.this.readIconFile(iconIS);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("imageBytes length: " + imageBytes.length), (Object[])new Object[0]);
                    }
                }
                finally {
                    block10: {
                        if (iconIS != null) {
                            try {
                                iconIS.close();
                            }
                            catch (IOException ioe) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                                Tr.debug((TraceComponent)tc, (String)("Exception thrown closing inputStream : " + ioe), (Object[])new Object[0]);
                            }
                        }
                    }
                }
                return imageBytes;
            }
        });
        return new IconImage(defaultIconSuffix, imageBytes);
    }

    private byte[] readIconFile(final File iconFile) {
        byte[] bytes = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] run() {
                FileInputStream fis = null;
                byte[] bytes = new byte[]{};
                try {
                    fis = new FileInputStream(iconFile);
                    bytes = IconRestHandler.this.readIconFile(fis);
                }
                catch (FileNotFoundException fnfe) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to find file " + iconFile.getAbsolutePath() + ": " + fnfe), (Object[])new Object[0]);
                    }
                }
                finally {
                    block14: {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException ioe) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                                Tr.debug((TraceComponent)tc, (String)("Exception thrown closing inputStream : " + ioe), (Object[])new Object[0]);
                            }
                        }
                    }
                }
                return bytes;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bytes length: " + bytes.length), (Object[])new Object[0]);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readIconFile(InputStream iconFileStream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (iconFileStream != null) {
            try {
                byte[] bytes = new byte[4096];
                int bytesRead = 0;
                while ((bytesRead = iconFileStream.read(bytes)) >= 0) {
                    bos.write(bytes, 0, bytesRead);
                }
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown reading inputStream : " + e), (Object[])new Object[0]);
                }
            }
            finally {
                block15: {
                    try {
                        bos.flush();
                        bos.close();
                    }
                    catch (IOException ioe) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                        Tr.debug((TraceComponent)tc, (String)("Exception thrown closing outputStream : " + ioe), (Object[])new Object[0]);
                    }
                }
            }
        }
        return bos.toByteArray();
    }

    @Override
    protected final void delegateMethod(RESTRequest request, RESTResponse response) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        String method = request.getMethod();
        if ("GET".equals(method)) {
            Object responseResult = this.doGET(request, response);
            if (responseResult instanceof IconImage) {
                this.setOutputResponse(response, (IconImage)responseResult, 200);
            } else {
                this.setJSONResponse(response, responseResult, 200);
            }
        } else {
            throw new MethodNotSupportedException();
        }
    }

    final void setOutputResponse(RESTResponse response, IconImage image, int status) {
        String mediaType = null;
        if (defaultIconSuffix.equals(image.getImageType())) {
            mediaType = "image/png";
        } else if ("gif".equals(image.getImageType())) {
            mediaType = "image/gif";
        } else if ("jpg".equals(image.getImageType()) || "jpeg".equals(image.getImageType())) {
            mediaType = "image/jpeg";
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unsupported Icon type. PNG, GIF or JPG are supported.", (Object[])new Object[0]);
            }
            response.setStatus(500);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Media Type:" + mediaType), (Object[])new Object[0]);
        }
        if (mediaType != null) {
            response.setResponseHeader("Content-Type", mediaType);
            try {
                response.setStatus(status);
                response.getOutputStream().write(image.getImageBytes());
            }
            catch (IOException e) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected IOException while writing out POJO response", (Object[])new Object[]{e});
                }
                response.setStatus(500);
            }
        }
    }

    @Override
    public AdminCenterRestHandler.POSTResponse postBase(RESTRequest request, RESTResponse response) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public AdminCenterRestHandler.POSTResponse postChild(RESTRequest request, RESTResponse response, String childResource) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public Object putBase(RESTRequest request, RESTResponse response) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public Object putChild(RESTRequest request, RESTResponse response, String childResource) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public Object deleteBase(RESTRequest request, RESTResponse response) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public Object deleteChild(RESTRequest request, RESTResponse response, String childResource) throws RESTException {
        throw new MethodNotSupportedException();
    }

    private static class IconImage {
        private byte[] imageBytes = null;
        private String imageType = null;

        public IconImage(String imageType, byte[] imageBytes) {
            this.imageBytes = imageBytes;
            this.imageType = imageType;
        }

        public byte[] getImageBytes() {
            return this.imageBytes;
        }

        public String getImageType() {
            return this.imageType;
        }
    }
}

