/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Filter {
    public Object applyFieldFilter(String filter, Object object) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        if (object == null) {
            return null;
        }
        if (filter == null) {
            return object;
        }
        Vector<String> vsa = this.getFilterVector(filter, ",");
        if (vsa.isEmpty()) {
            return object;
        }
        Map<Object, Object> kvPair = this.convertBeanObjectToMap(object);
        return this.filterMap(vsa, "", kvPair);
    }

    private Vector<String> getFilterVector(String in, String separator) {
        String[] sa = in.split(separator);
        Vector<String> vsa = new Vector<String>();
        for (int i = 0; i < sa.length; ++i) {
            String thisFilter = sa[i].trim();
            if (thisFilter.isEmpty()) continue;
            vsa.add(thisFilter);
        }
        return vsa;
    }

    private Map<Object, Object> convertBeanObjectToMap(Object object) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        if (object instanceof Map) {
            return (Map)object;
        }
        LinkedHashMap<Object, Object> lhm = new LinkedHashMap<Object, Object>();
        BeanInfo testBeanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
        for (PropertyDescriptor propertyDescriptor : testBeanInfo.getPropertyDescriptors()) {
            Method getter = propertyDescriptor.getReadMethod();
            if (getter == null) continue;
            Object val = getter.invoke(object, new Object[0]);
            lhm.put(propertyDescriptor.getName(), val);
        }
        return lhm;
    }

    private Map<Object, Object> filterMap(Vector<String> vsa, String name, Map<Object, Object> sourceMap) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        LinkedHashMap<Object, Object> lhm = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : sourceMap.entrySet()) {
            String key = entry.getKey().toString();
            if (!this.checkField(vsa, name, key)) continue;
            Object value = entry.getValue();
            if (value != null && value instanceof List) {
                List list = (List)value;
                ArrayList<Map<Object, Object>> arrayList = new ArrayList<Map<Object, Object>>();
                for (Object obj : list) {
                    Map<Object, Object> kvPair = this.convertBeanObjectToMap(obj);
                    String newKey = name.isEmpty() ? key : name + "." + key;
                    arrayList.add(this.filterMap(vsa, newKey, kvPair));
                }
                lhm.put(key, arrayList);
                continue;
            }
            if (value != null && value instanceof Map) {
                Map map = (Map)value;
                String newKey = name.isEmpty() ? key : name + "." + key;
                lhm.put(key, this.filterMap(vsa, newKey, map));
                continue;
            }
            if (value == null) continue;
            lhm.put(key, value);
        }
        return lhm;
    }

    public boolean checkField(Vector<String> vsa, String name, String key) {
        String keyToCheck = name.isEmpty() ? key : name + "." + key;
        String parentKeyToCheck = name.isEmpty() ? "" : name;
        boolean ret = false;
        Iterator<String> iterator = vsa.iterator();
        while (iterator.hasNext() && !ret) {
            String me = iterator.next();
            if (me.equalsIgnoreCase(keyToCheck) || me.equalsIgnoreCase(parentKeyToCheck)) {
                ret = true;
                continue;
            }
            Vector<String> v = new Vector<String>();
            StringTokenizer st = new StringTokenizer(me, ".");
            while (st.hasMoreTokens() && !ret) {
                String s = st.nextToken();
                String ps = v.isEmpty() ? s : (String)v.lastElement() + "." + s;
                v.add(ps);
                if (!ps.equalsIgnoreCase(keyToCheck)) continue;
                ret = true;
            }
        }
        return ret;
    }
}

