/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.jose4j.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcTokenImplBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(OidcTokenImplBase.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    protected static final String CLIENT_ID = "azp2";
    private static final String BEARER = "Bearer";
    private transient JwtClaims jwtClaims = null;
    private String access_token = null;
    private String refresh_token = null;
    private String client_id = null;
    private String tokenTypeNoSpace = null;
    private final short serializationVersion = 1;

    public OidcTokenImplBase(JwtClaims jwtClaims, String access_token, String refresh_token, String client_id, String tokenTypeNoSpace) {
        this.jwtClaims = jwtClaims;
        this.access_token = access_token;
        this.refresh_token = refresh_token;
        this.client_id = client_id;
        if (tokenTypeNoSpace == null) {
            tokenTypeNoSpace = "IDToken";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provided token type is null; defaulting to " + tokenTypeNoSpace), (Object[])new Object[0]);
            }
        }
        this.tokenTypeNoSpace = tokenTypeNoSpace;
    }

    public String getTokenTypeNoSpace() {
        return this.tokenTypeNoSpace;
    }

    public JwtClaims getJwtClaims() {
        return this.jwtClaims;
    }

    public String getJwtId() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getJwtId();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"100", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getType() {
        return BEARER;
    }

    public String getIssuer() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getIssuer();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"115", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getSubject() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getSubject();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"126", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public List<String> getAudience() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getAudience();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"137", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getClientId() {
        return this.client_id;
    }

    public long getExpirationTimeSeconds() {
        if (this.jwtClaims == null) {
            return 0L;
        }
        try {
            return this.jwtClaims.getExpirationTime().getValue();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"152", (Object)this, (Object[])new Object[0]);
            return 0L;
        }
    }

    public long getNotBeforeTimeSeconds() {
        if (this.jwtClaims == null) {
            return 0L;
        }
        try {
            return this.jwtClaims.getNotBefore().getValue();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"163", (Object)this, (Object[])new Object[0]);
            return 0L;
        }
    }

    public long getIssuedAtTimeSeconds() {
        if (this.jwtClaims == null) {
            return 0L;
        }
        try {
            return this.jwtClaims.getIssuedAt().getValue();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"174", (Object)this, (Object[])new Object[0]);
            return 0L;
        }
    }

    public long getAuthorizationTimeSeconds() {
        return 0L;
    }

    public String getNonce() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getStringClaimValue("nonce");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"189", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getAccessTokenHash() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getStringClaimValue("at_hash");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"200", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getClassReference() {
        return null;
    }

    public List<String> getMethodsReferences() {
        return null;
    }

    public String getAuthorizedParty() {
        return null;
    }

    public Object getClaim(String key) {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getClaimValue(key);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"223", (Object)this, (Object[])new Object[]{key});
            return null;
        }
    }

    public Map<String, Object> getAllClaims() {
        if (this.jwtClaims == null) {
            return null;
        }
        return new HashMap<String, Object>(this.jwtClaims.getClaimsMap());
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getRefreshToken() {
        return this.refresh_token;
    }

    public String getAllClaimsAsJson() {
        try {
            if (this.jwtClaims == null) {
                return null;
            }
            return this.jwtClaims.toJson();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"249", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getRawIdToken() throws WSSecurityException {
        Subject subj = WSSubject.getRunAsSubject();
        Set<Object> privCredentials = subj.getPrivateCredentials();
        for (Object credentialObj : privCredentials) {
            Object value;
            if (!(credentialObj instanceof Map) || (value = ((Map)credentialObj).get("id_token")) == null) continue;
            return (String)value;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.tokenTypeNoSpace);
        String claimsString = this.getAllClaimsAsJson();
        if (claimsString == null) {
            return sb.toString();
        }
        sb.append(":").append(claimsString);
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        try {
            this.jwtClaims = JwtClaims.parse((String)((String)input.readObject()), null);
        }
        catch (InvalidJwtException invalidJwtException) {
            void e;
            FFDCFilter.processException((Throwable)invalidJwtException, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"295", (Object)this, (Object[])new Object[]{input});
            throw new IOException("Error deserializing JWT claims.", (Throwable)e);
        }
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeObject(this.jwtClaims.toJson());
    }
}

