/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.tx.util.alarm.AlarmManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.PrintWriter;
import java.io.StringWriter;

public class TimeoutManager {
    private static final TraceComponent tc = Tr.register(TimeoutManager.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int CANCEL_TIMEOUT = 0;
    public static final int NO_TIMEOUT = 0;
    public static final int ACTIVE_TIMEOUT = 1;
    public static final int IN_DOUBT_TIMEOUT = 2;
    public static final int REPEAT_TIMEOUT = 3;
    public static final int INACTIVITY_TIMEOUT = 4;
    public static final int SR_TERMINATION_TIMEOUT = 5;

    public static void setTimeout(TransactionImpl tran, int timeoutType, int seconds) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeout", (Object[])new Object[]{tran, timeoutType, seconds});
        }
        switch (timeoutType) {
            case 1: 
            case 2: 
            case 3: {
                TimeoutInfo info = tran.setTimeoutInfo(new TimeoutInfo(tran, seconds, timeoutType));
                if (!tc.isDebugEnabled() || info == null || timeoutType == 3) break;
                Tr.debug((TraceComponent)tc, (String)("Found existing timeout for transaction: " + info), (Object[])new Object[0]);
                break;
            }
            default: {
                TimeoutInfo info = tran.getTimeoutInfo();
                if (null != info) {
                    tran.setTimeoutInfo(null);
                    info.cancelAlarm();
                    break;
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("Failed to find existing timeout for transaction: " + tran), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTimeout");
        }
    }

    public static class TimeoutInfo
    implements AlarmListener {
        protected final TransactionImpl _tran;
        protected final int _duration;
        protected final int _timeoutType;
        private Alarm _alarm;
        private final AlarmManager _alarmManager = ConfigurationProviderManager.getConfigurationProvider().getAlarmManager();

        protected TimeoutInfo(TransactionImpl tran, int duration, int type) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"TimeoutInfo", (Object[])new Object[]{tran});
            }
            this._tran = tran;
            this._duration = duration;
            this._timeoutType = type;
            this._alarm = this._alarmManager.scheduleAlarm((long)this._duration * 1000L, (AlarmListener)this, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"TimeoutInfo");
            }
        }

        public void alarm(Object alarmContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"alarm", (Object[])new Object[]{this._tran});
            }
            switch (this._timeoutType) {
                case 1: {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction timeout", (Object[])new Object[]{this._tran});
                    }
                    Tr.info((TraceComponent)tc, (String)"WTRN0006_TRANSACTION_HAS_TIMED_OUT", (Object[])new Object[]{this._tran.getTranName(), new Integer(this._duration)});
                    Thread thread = this._tran.getMostRecentThread();
                    if (thread != null) {
                        StackTraceElement[] stack = thread.getStackTrace();
                        StringWriter writer = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(writer);
                        printWriter.println();
                        for (StackTraceElement element : stack) {
                            printWriter.println("\t" + element);
                        }
                        Tr.info((TraceComponent)tc, (String)"WTRN0124_TIMED_OUT_TRANSACTION_STACK", (Object[])new Object[]{thread, writer.getBuffer()});
                    }
                    this._tran.timeoutTransaction(true);
                    break;
                }
                case 3: {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction repeat timeout", (Object[])new Object[]{this._tran});
                    }
                    this._tran.timeoutTransaction(false);
                    break;
                }
                case 2: {
                    this._tran.setTimeoutInfo(null);
                    this._tran.recover();
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"alarm");
            }
        }

        public void cancelAlarm() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"cancelAlarm", (Object[])new Object[]{this._alarm});
            }
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cancelAlarm");
            }
        }

        public String toString() {
            switch (this._timeoutType) {
                case 0: {
                    return "CANCEL/NO_TIMEOUT " + this._duration;
                }
                case 1: {
                    return "ACTIVE_TIMEOUT " + this._duration;
                }
                case 2: {
                    return "IN_DOUBT_TIMEOUT " + this._duration;
                }
                case 3: {
                    return "REPEAT_TIMEOUT " + this._duration;
                }
                case 4: {
                    return "INACTIVITY_TIMEOUT " + this._duration;
                }
            }
            return "INVALID_TIMEOUT (" + this._timeoutType + ") " + this._duration;
        }
    }
}

