/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility;

import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandConsoleFacade;
import com.ibm.ws.product.utility.CommandTaskRegistry;
import com.ibm.ws.product.utility.ExecutionContext;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ExecutionContextImpl
implements ExecutionContext {
    private final CommandConsoleFacade console;
    private final String[] arguments;
    private final CommandTaskRegistry commandTaskRegistry;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> optionNameValueMap = new HashMap<String, String>();

    public ExecutionContextImpl(CommandConsole console, String[] arguments, CommandTaskRegistry commandTaskRegistry) {
        this.console = new CommandConsoleFacade(console);
        this.arguments = arguments;
        this.commandTaskRegistry = commandTaskRegistry;
        this.parseArguments();
    }

    @Override
    public CommandConsole getCommandConsole() {
        return this.console;
    }

    @Override
    public String[] getArguments() {
        return this.arguments;
    }

    @Override
    public Set<String> getOptionNames() {
        return this.optionNameValueMap.keySet();
    }

    @Override
    public String getOptionValue(String option) {
        return this.optionNameValueMap.get(option);
    }

    @Override
    public boolean optionExists(String option) {
        return this.optionNameValueMap.containsKey(option);
    }

    @Override
    public CommandTaskRegistry getCommandTaskRegistry() {
        return this.commandTaskRegistry;
    }

    @Override
    public <T> T getAttribute(String name, Class<T> cls) {
        return cls.cast(this.attributes.get(name));
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    private void parseArguments() {
        for (int index = 0; index < this.arguments.length; ++index) {
            String argument = this.arguments[index];
            String[] splits = argument.split("=");
            String optionName = splits[0];
            String optionValue = "";
            if (splits.length > 1) {
                optionValue = argument.substring(argument.indexOf("=") + 1);
            }
            this.optionNameValueMap.put(optionName, optionValue);
        }
    }

    @Override
    public void setOverrideOutputStream(PrintStream outputStream) {
        this.console.setOverrideOutputStream(outputStream);
    }
}

