/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.Objects;
import org.eclipse.microprofile.metrics.DefaultMetadata;
import org.eclipse.microprofile.metrics.Metadata;

public class MetadataBuilder {
    private String name;
    private String description;
    private String unit;

    MetadataBuilder(Metadata metadata) {
        this.name = metadata.getName();
        metadata.description().ifPresent(this::withDescription);
        metadata.unit().ifPresent(this::withUnit);
    }

    public MetadataBuilder() {
    }

    public MetadataBuilder withName(String name) {
        this.name = Objects.requireNonNull(name, "name is required");
        if ("".equals(name)) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        return this;
    }

    public MetadataBuilder withDescription(String description) {
        this.description = "".equals(description) ? null : description;
        return this;
    }

    public MetadataBuilder withUnit(String unit) {
        this.unit = "none".equals(unit) ? null : unit;
        return this;
    }

    public Metadata build() {
        if (Objects.isNull(this.name)) {
            throw new IllegalStateException("Name is required");
        }
        return new DefaultMetadata(this.name, this.description, this.unit);
    }
}

