/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.jandex.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.jandex.internal.Singleton;
import com.ibm.ws.annocache.jandex.internal.SparseAnnotationHolder;
import com.ibm.ws.annocache.jandex.internal.SparseDotName;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class SparseClassInfo {
    private final SparseDotName name;
    private final short flags;
    private final SparseDotName[] interfaceNames;
    private final SparseDotName superClassName;
    private ArrayList<SparseDotName> classAnnotations;
    private List<SparseDotName> fieldAnnotations;
    private List<SparseDotName> methodAnnotations;
    static final long serialVersionUID = -1831770736891238572L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    SparseClassInfo(SparseDotName name, SparseDotName superClassName, short flags, SparseDotName[] interfaceNames) {
        this.name = name;
        this.flags = flags;
        this.superClassName = superClassName;
        this.interfaceNames = interfaceNames;
        this.classAnnotations = null;
        this.fieldAnnotations = null;
        this.methodAnnotations = null;
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SparseClassInfo)) {
            return false;
        }
        SparseClassInfo otherClassInfo = (SparseClassInfo)other;
        return this.name().equals(otherClassInfo.name());
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public SparseDotName name() {
        return this.name;
    }

    public short flags() {
        return this.flags;
    }

    public SparseDotName superName() {
        return this.superClassName;
    }

    public SparseDotName[] interfaceNames() {
        return this.interfaceNames;
    }

    public void addField(SparseDotName fieldName) {
    }

    public void addMethod(SparseDotName methodName) {
    }

    public List<SparseDotName> classAnnotations() {
        if (this.classAnnotations == null) {
            return Collections.emptyList();
        }
        return this.classAnnotations;
    }

    public void addClassAnnotation(SparseDotName classAnnotation) {
        if (this.classAnnotations == null) {
            this.classAnnotations = new ArrayList(1);
        }
        this.classAnnotations.add(classAnnotation);
    }

    public void addClassAnnotations(List<SparseDotName> annotationClassNames) {
        if (annotationClassNames == null) {
            return;
        }
        int numAnnotations = annotationClassNames.size();
        if (numAnnotations == 0) {
            return;
        }
        if (this.classAnnotations == null) {
            this.classAnnotations = new ArrayList(numAnnotations);
        } else {
            this.classAnnotations.ensureCapacity(this.classAnnotations.size() + numAnnotations);
        }
        this.classAnnotations.addAll(annotationClassNames);
    }

    public List<SparseDotName> fieldAnnotations() {
        if (this.fieldAnnotations == null) {
            return Collections.emptyList();
        }
        return this.fieldAnnotations;
    }

    public void addFieldAnnotation(SparseDotName fieldAnnotation) {
        if (this.fieldAnnotations == null) {
            this.fieldAnnotations = new ArrayList<SparseDotName>(1);
        }
        this.fieldAnnotations.add(fieldAnnotation);
    }

    public void allocateFieldAnnotations(int numAnnotations) {
        if (numAnnotations == 0 || numAnnotations == 1) {
            return;
        }
        this.fieldAnnotations = new ArrayList<SparseDotName>(numAnnotations);
    }

    public void addAllocatedFieldAnnotations(SparseDotName[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return;
        }
        if (this.fieldAnnotations == null) {
            this.fieldAnnotations = new Singleton<SparseDotName>(annotations[0]);
        } else {
            for (SparseDotName annotation : annotations) {
                this.fieldAnnotations.add(annotation);
            }
        }
    }

    public void recordFieldEntry(SparseAnnotationHolder fieldAndAnnotations) {
        this.addAllocatedFieldAnnotations(fieldAndAnnotations.getAnnotations());
    }

    public List<SparseDotName> methodAnnotations() {
        if (this.methodAnnotations == null) {
            return Collections.emptyList();
        }
        return this.methodAnnotations;
    }

    public void addMethodAnnotation(SparseDotName methodAnnotation) {
        if (this.methodAnnotations == null) {
            this.methodAnnotations = new ArrayList<SparseDotName>(1);
        }
        this.methodAnnotations.add(methodAnnotation);
    }

    public void allocateMethodAnnotations(int numAnnotations) {
        if (numAnnotations == 0 || numAnnotations == 1) {
            return;
        }
        this.methodAnnotations = new ArrayList<SparseDotName>(numAnnotations);
    }

    public void addAllocatedMethodAnnotations(SparseDotName[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return;
        }
        if (this.methodAnnotations == null) {
            this.methodAnnotations = new Singleton<SparseDotName>(annotations[0]);
        } else {
            for (SparseDotName annotation : annotations) {
                this.methodAnnotations.add(annotation);
            }
        }
    }

    public void recordMethodEntry(SparseAnnotationHolder methodAndAnnotations) {
        this.addAllocatedMethodAnnotations(methodAndAnnotations.getAnnotations());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.jandex.internal.SparseClassInfo", SparseClassInfo.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }
}

