/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.metrics.impl.CounterImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MonitorCounter
extends CounterImpl {
    private static final TraceComponent tc = Tr.register(MonitorCounter.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
    MBeanServer mbs;
    String objectName;
    String attribute;
    String subAttribute;
    boolean isComposite = false;
    static final long serialVersionUID = -2572620728560287589L;

    public MonitorCounter(MBeanServer mbs, String objectName, String attribute) {
        this.mbs = mbs;
        this.objectName = objectName;
        this.attribute = attribute;
    }

    public MonitorCounter(MBeanServer mbs, String objectName, String attribute, String subAttribute) {
        this.mbs = mbs;
        this.objectName = objectName;
        this.attribute = attribute;
        this.subAttribute = subAttribute;
        this.isComposite = true;
    }

    /*
     * WARNING - void declaration
     */
    public long getCount() {
        try {
            if (this.isComposite) {
                CompositeData value = (CompositeData)this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
                Number numValue = (Number)value.get(this.subAttribute);
                return numValue.longValue();
            }
            Number value = (Number)this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
            return value.longValue();
        }
        catch (Exception value) {
            FFDCFilter.processException((Throwable)value, (String)"io.openliberty.microprofile.metrics.internal.monitor.MonitorCounter", (String)"57", (Object)((Object)this), (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"getCount exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCount:Exception");
            }
            return 0L;
        }
    }
}

