/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.model;

import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.Type;

public class MethodInfo {
    private final String methodName;
    private final String methodDescriptor;
    private boolean trivial;
    private boolean resultSensitive;
    private boolean[] argIsSensitive;
    private Set<Type> ffdcIgnoreExceptions = new LinkedHashSet<Type>();

    public MethodInfo(String name, String descriptor) {
        this.methodName = name;
        this.methodDescriptor = descriptor;
        this.argIsSensitive = new boolean[Type.getArgumentTypes((String)descriptor).length];
    }

    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void addFFDCIgnoreException(Type exceptionType) {
        this.ffdcIgnoreExceptions.add(exceptionType);
    }

    public Set<Type> getFFDCIgnoreExceptions() {
        return this.ffdcIgnoreExceptions;
    }

    public boolean isResultSensitive() {
        return this.resultSensitive;
    }

    public void setResultSensitive(boolean sensitive) {
        this.resultSensitive = sensitive;
    }

    public boolean isTrivial() {
        return this.trivial;
    }

    public void setTrivial(boolean trivial) {
        this.trivial = trivial;
    }

    public boolean isArgSensitive(int index) {
        if (index < this.argIsSensitive.length) {
            return this.argIsSensitive[index];
        }
        return false;
    }

    public void setArgIsSensitive(int index, boolean isSensitive) {
        this.argIsSensitive[index] = isSensitive;
    }

    public void updateDefaultValuesFromClassInfo(ClassInfo classInfo) {
        if (!this.trivial) {
            this.trivial = classInfo.isTrivial();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";methodName=").append(this.methodName);
        sb.append(",methodDescriptor=").append(this.methodDescriptor);
        sb.append(",trivial=").append(this.trivial);
        sb.append(",resultSensitive=").append(this.resultSensitive);
        sb.append(",argIsSensitive=").append(Arrays.toString(this.argIsSensitive));
        sb.append(",ffdcIgnoreExceptions=").append(this.ffdcIgnoreExceptions);
        return sb.toString();
    }
}

