/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bootstrap.events.AbstractProcessInjectionTarget;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public class ProcessBeanInjectionTarget<X>
extends AbstractProcessInjectionTarget<X>
implements ProcessInjectionTarget<X> {
    private final AbstractClassBean<X> classBean;

    public ProcessBeanInjectionTarget(BeanManagerImpl beanManager, AbstractClassBean<X> bean) {
        super(beanManager, bean.getAnnotated());
        this.classBean = bean;
    }

    public InjectionTarget<X> getInjectionTarget() {
        this.checkWithinObserverNotification();
        return this.classBean.getProducer();
    }

    public void setInjectionTarget(InjectionTarget<X> injectionTarget) {
        this.checkWithinObserverNotification();
        BootstrapLogger.LOG.setInjectionTargetCalled(this.getReceiver(), this.getInjectionTarget(), injectionTarget);
        this.classBean.setProducer(injectionTarget);
    }
}

