/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi;

import com.ibm.ejs.ras.Traceable;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer.VirtualHostConfiguration;
import com.ibm.wsspi.http.HttpContainer;
import com.ibm.wsspi.http.VirtualHost;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class DynamicVirtualHostConfiguration
extends VirtualHostConfiguration
implements Traceable {
    private static final TraceComponent tc = Tr.register(DynamicVirtualHostConfiguration.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    final String name;
    final HashSet<String> activeContexts = new HashSet();
    private AtomicInteger appStartingCount;

    public DynamicVirtualHostConfiguration(String name) {
        super(name);
        this.name = name;
        this.appStartingCount = new AtomicInteger(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DynamicVirtualHostConfiguration", (Object[])new Object[]{"name ->" + this.name});
        }
    }

    public DynamicVirtualHostConfiguration(VirtualHost config) {
        super(config);
        this.name = config.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DynamicVirtualHostConfiguration", (Object[])new Object[]{"config name ->" + this.name});
        }
    }

    synchronized void addContextRoot(String contextRoot, HttpContainer container) {
        VirtualHost local;
        if (contextRoot != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"addContextRoot", (Object[])new Object[]{"contextRoot-> [" + contextRoot + "]"});
            }
            this.activeContexts.add(contextRoot);
        }
        if ((local = this.config) != null) {
            local.addContextRoot(contextRoot, container);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Context root added " + contextRoot), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addContextRoot", (Object[])new Object[]{"local VH config is null"});
        }
    }

    synchronized void removeContextRoot(String contextRoot, HttpContainer container) {
        VirtualHost local;
        if (contextRoot != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removeContextRoot", (Object[])new Object[]{"contextRoot-> [" + contextRoot + "]"});
            }
            this.activeContexts.remove(contextRoot);
        }
        if ((local = this.config) != null) {
            local.removeContextRoot(contextRoot, container);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Context root removed " + contextRoot), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"removeContextRoot", (Object[])new Object[]{"local VH config is null"});
        }
    }

    public synchronized Iterator<String> getActiveContext() {
        HashSet<String> copy = new HashSet<String>(this.activeContexts);
        return copy.iterator();
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String toTraceString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + "," + this.config + "]";
    }

    protected void incrementAppStartingCount() {
        int count = this.appStartingCount.incrementAndGet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"incrementAppStartingCount new count:", (Object[])new Object[]{count});
        }
    }

    protected void decrementAppStartingCount() {
        int count = this.appStartingCount.decrementAndGet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"decrementAppStartingCount new count:", (Object[])new Object[]{count});
        }
    }

    protected int getAppStartingCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getAppStartingCount count:", (Object[])new Object[]{this.appStartingCount.get()});
        }
        return this.appStartingCount.get();
    }
}

