/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipUtils {
    private static final TraceComponent tc = Tr.register(ZipUtils.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.war.internal.ZipUtils");
    public static final int RETRY_COUNT;
    public static final long RETRY_AMOUNT = 50L;
    public static final int RETRY_LIMIT = 1000;
    public static final boolean IS_EAR = true;
    public static final boolean IS_NOT_EAR = false;
    private static final String WAR_EXTENSION = ".war";
    static final long serialVersionUID = 5256489971379627693L;

    @Trivial
    public static File deleteWithRetry(File file) {
        int tryNo;
        String filePath;
        String methodName = "deleteWithRetry";
        if (tc.isDebugEnabled()) {
            filePath = file.getAbsolutePath();
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Recursively delete [ " + filePath + " ]"), (Object[])new Object[0]);
        } else {
            filePath = null;
        }
        File firstFailure = ZipUtils.delete(file);
        if (firstFailure == null) {
            if (filePath != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Successful first delete [ " + filePath + " ]"), (Object[])new Object[0]);
            }
            return null;
        }
        if (filePath != null) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Failed first delete [ " + filePath + " ]: Sleep up to 50 ms and retry"), (Object[])new Object[0]);
        }
        File retryFailure = firstFailure;
        for (tryNo = 0; retryFailure != null && tryNo < RETRY_COUNT; ++tryNo) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.app.manager.war.internal.ZipUtils", (String)"146", null, (Object[])new Object[]{file});
            }
            retryFailure = ZipUtils.delete(file);
        }
        if (retryFailure == null) {
            if (filePath != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Successful delete of [ " + filePath + " ] after [ " + tryNo + " ] retries"), (Object[])new Object[0]);
            }
            return null;
        }
        if (filePath != null) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Failed to delete [ " + filePath + " ]. Tried [ " + (tryNo + 1) + " ] times."), (Object[])new Object[0]);
        }
        return retryFailure;
    }

    /*
     * WARNING - void declaration
     */
    public static File delete(File file) {
        File[] failedFile;
        block8: {
            final String methodName = "delete";
            if (file == null) {
                throw new IllegalArgumentException("File must not be null");
            }
            final Path path = file.toPath();
            if (Files.isSymbolicLink(path)) {
                if (!file.delete()) {
                    return file;
                }
                return null;
            }
            failedFile = new File[1];
            if (file.isDirectory()) {
                try {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                        static final long serialVersionUID = -6003911486366461565L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public FileVisitResult visitFile(Path subPath, BasicFileAttributes attrs) {
                            File f = subPath.toFile();
                            if (!f.delete() && failedFile[0] == null) {
                                failedFile[0] = f;
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                            File d;
                            if (exc != null && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(methodName + ": Exception while visiting directory [ " + dir + " ]: " + exc.getMessage()), (Object[])new Object[0]);
                            }
                            if (!dir.equals(path) && !(d = dir.toFile()).delete() && failedFile[0] == null) {
                                failedFile[0] = d;
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) {
                            if (failedFile[0] == null) {
                                failedFile[0] = file.toFile();
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.war.internal.ZipUtils$1");
                        }
                    });
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.war.internal.ZipUtils", (String)"240", null, (Object[])new Object[]{file});
                    if (failedFile[0] == null) {
                        failedFile[0] = file;
                    }
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)(methodName + ": Exception walking file tree - " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        if (!file.delete() && failedFile[0] == null) {
            failedFile[0] = file;
        }
        return failedFile[0];
    }

    public static void unzip(File source, File target, boolean isEar, long lastModified) throws IOException {
        byte[] transferBuffer = new byte[16384];
        ZipUtils.unzip(source, target, isEar, lastModified, transferBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public static void unzip(File source, File target, boolean isEar, long lastModified, byte[] transferBuffer) throws IOException {
        String methodName = "unzip";
        String sourcePath = source.getAbsolutePath();
        String targetPath = target.getAbsolutePath();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Source [ " + sourcePath + " ] Size [ " + source.length() + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Target [ " + targetPath + " ]"), (Object[])new Object[0]);
        }
        if (!source.exists()) {
            throw new IOException("Source [ " + sourcePath + " ] does not exist");
        }
        if (!source.isFile()) {
            throw new IOException("Source [ " + sourcePath + " ] is not a simple file");
        }
        if (!target.exists()) {
            throw new IOException("Target [ " + targetPath + " ] does not exist");
        }
        if (!target.isDirectory()) {
            throw new IOException("Target [ " + targetPath + " ] is not a directory");
        }
        ArrayList<Object[]> warData = isEar ? new ArrayList<Object[]>() : null;
        try (ZipFile sourceZip = new ZipFile(source);){
            Enumeration<? extends ZipEntry> sourceEntries = sourceZip.entries();
            while (sourceEntries.hasMoreElements()) {
                long entryModified;
                Object[] nextWarData;
                String targetFileName;
                ZipEntry sourceEntry = sourceEntries.nextElement();
                String sourceEntryName = sourceEntry.getName();
                if (ZipUtils.reachesOut(sourceEntryName)) {
                    Tr.error((TraceComponent)tc, (String)"error.file.outside.archive", (Object[])new Object[]{sourceEntryName, sourcePath});
                    continue;
                }
                if (isEar && !sourceEntry.isDirectory() && sourceEntryName.endsWith(WAR_EXTENSION)) {
                    int tmpNo = 0;
                    while (sourceZip.getEntry(targetFileName = sourceEntryName + ".tmp" + tmpNo) != null) {
                        ++tmpNo;
                    }
                    nextWarData = new Object[]{sourceEntryName, targetFileName, null};
                } else {
                    targetFileName = sourceEntryName;
                    nextWarData = null;
                }
                File targetFile = new File(target, targetFileName);
                if (sourceEntry.isDirectory()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + ": Directory [ " + sourceEntryName + " ]"), (Object[])new Object[0]);
                    }
                    if (!targetFile.exists() && !targetFile.mkdirs()) {
                        throw new IOException("Failed to create directory [ + " + targetFile.getAbsolutePath() + " ]");
                    }
                } else {
                    File targetParent;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + ": Simple file [ " + sourceEntryName + " ] [ " + sourceEntry.getSize() + " ]"), (Object[])new Object[0]);
                    }
                    if (!(targetParent = targetFile.getParentFile()).mkdirs() && !targetParent.exists()) {
                        throw new IOException("Failed to create directory [ " + targetParent.getAbsolutePath() + " ]");
                    }
                    ZipUtils.transfer(sourceZip, sourceEntry, targetFile, transferBuffer);
                }
                if ((entryModified = sourceEntry.getTime()) == -1L) {
                    entryModified = lastModified;
                }
                targetFile.setLastModified(entryModified);
                if (nextWarData == null) continue;
                nextWarData[2] = entryModified;
                warData.add(nextWarData);
            }
        }
        if (isEar) {
            for (Object[] nextWarData : warData) {
                String unpackedWarName = (String)nextWarData[0];
                String packedWarName = (String)nextWarData[1];
                long warLastModified = (Long)nextWarData[2];
                File unpackedWarFile = new File(target, unpackedWarName);
                if (!unpackedWarFile.exists() && !unpackedWarFile.mkdirs()) {
                    throw new IOException("Failed to create [ " + unpackedWarFile.getAbsolutePath() + " ]");
                }
                File packedWarFile = new File(target, packedWarName);
                ZipUtils.unzip(packedWarFile, unpackedWarFile, false, warLastModified, transferBuffer);
                if (packedWarFile.delete() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Failed to delete temporary WAR [ " + packedWarFile.getAbsolutePath() + " ]"), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Set last modified [ " + lastModified + " ]"), (Object[])new Object[0]);
        }
        target.setLastModified(lastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private static void transfer(ZipFile sourceZip, ZipEntry sourceEntry, File targetFile, byte[] transferBuffer) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int lastRead;
            inputStream = sourceZip.getInputStream(sourceEntry);
            outputStream = new FileOutputStream(targetFile);
            while ((lastRead = inputStream.read(transferBuffer)) != -1) {
                outputStream.write(transferBuffer, 0, lastRead);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private static boolean reachesOut(String entryPath) {
        if (!entryPath.contains("..")) {
            return false;
        }
        String normalizedPath = PathUtils.normalizeUnixStylePath((String)entryPath);
        return PathUtils.isNormalizedPathAbsolute((String)normalizedPath);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        if (ZipCachingProperties.ZIP_CACHE_REAPER_MAX_PENDING == 0) {
            RETRY_COUNT = 1;
        } else {
            long totalAmount = ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX * 2L;
            if (totalAmount <= 0L) {
                RETRY_COUNT = 1;
            } else {
                if (totalAmount > 1000L) {
                    totalAmount = 1000L;
                }
                int retryCount = (int)(totalAmount / 50L);
                if (totalAmount % 50L > 0L) {
                    ++retryCount;
                }
                RETRY_COUNT = retryCount;
            }
        }
    }
}

