/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.basic.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.X509CertificateMapper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.CustomRegistryException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.LDAPUtils;
import com.ibm.ws.security.registry.NotImplementedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.basic.internal.BasicPassword;
import com.ibm.ws.security.registry.basic.internal.BasicRegistryConfig;
import com.ibm.ws.security.registry.basic.internal.Group;
import com.ibm.ws.security.registry.basic.internal.Member;
import com.ibm.ws.security.registry.basic.internal.User;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.ext.annotation.DSExt;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.security.registry.basic.config"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM", "com.ibm.ws.security.registry.type=Basic"})
@DSExt.ConfigureWithInterfaces
public class BasicRegistry
implements UserRegistry {
    private static final TraceComponent tc = Tr.register(BasicRegistry.class, (String[])new String[]{"UserRegistry", "BasicRegistry"}, (String)"com.ibm.ws.security.registry.basic.internal.resources.LoggingMessages", (String)"com.ibm.ws.security.registry.basic.internal.BasicRegistry");
    protected static final String DEFAULT_REALM_NAME = "BasicRegistry";
    static final String TYPE = "Basic";
    private volatile State state;
    private String certificateMapMode = null;
    private final AtomicReference<X509CertificateMapper> iCertificateMapperRef = new AtomicReference();
    private static final String REGEX_IGNORE_CASE_CONTROL = "(?i)";
    static final long serialVersionUID = 2804906874371582872L;

    @Activate
    @Modified
    protected void activate(BasicRegistryConfig config) {
        Map<String, BasicPassword> users = BasicRegistry.users(config.user());
        this.state = new State(config.realm(), config.ignoreCaseForAuthentication(), users, BasicRegistry.group(config.group(), users));
        if (this.state.users.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"BASIC_REGISTRY_NO_USERS_DEFINED", (Object[])new Object[]{config.config_id()});
        }
        this.certificateMapMode = config.certificateMapMode();
    }

    private static Map<String, BasicPassword> users(User[] users) {
        HashSet<String> bad = new HashSet<String>();
        HashMap<String, BasicPassword> result = new HashMap<String, BasicPassword>(users.length);
        for (User user : users) {
            String name = user.name().trim();
            if (name.isEmpty()) {
                String message = TraceNLS.getStringFromBundle(BasicRegistry.class, (String)"com.ibm.ws.security.registry.basic.internal.resources.LoggingMessages", (String)"USER_MUST_DEFINE_NAME", (String)"A user element must define a name.");
                Tr.error((TraceComponent)tc, (String)"BASIC_REGISTRY_INVALID_USER_DEFINITION", (Object[])new Object[]{message});
                continue;
            }
            if (result.containsKey(name) || bad.contains(name)) {
                bad.add(name);
                result.remove(name);
                Tr.error((TraceComponent)tc, (String)"BASIC_REGISTRY_SAME_USER_DEFINITION", (Object[])new Object[]{name});
                continue;
            }
            String decodedString = new String(user.password().getChars()).trim();
            if (decodedString.isEmpty()) {
                bad.add(name);
                String message = TraceNLS.getFormattedMessage(BasicRegistry.class, (String)"com.ibm.ws.security.registry.basic.internal.resources.LoggingMessages", (String)"USER_MUST_DEFINE_PASSWORD", (Object[])new Object[]{name}, (String)"The user element with name ''{0}'' must define a password.");
                Tr.error((TraceComponent)tc, (String)"BASIC_REGISTRY_INVALID_USER_DEFINITION", (Object[])new Object[]{message});
                continue;
            }
            boolean isHashed = PasswordUtil.isHashed((String)decodedString);
            if (!isHashed) {
                decodedString = PasswordUtil.passwordDecode((String)decodedString);
            }
            BasicPassword decodedPassword = new BasicPassword(decodedString, isHashed);
            result.put(name, decodedPassword);
        }
        return result;
    }

    private static Map<String, List<String>> group(Group[] groups, Map<String, BasicPassword> users) {
        HashSet<String> bad = new HashSet<String>();
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(groups.length);
        for (Group group : groups) {
            String groupName = group.name().trim();
            if (groupName.isEmpty()) {
                String message = TraceNLS.getStringFromBundle(BasicRegistry.class, (String)"com.ibm.ws.security.registry.basic.internal.resources.LoggingMessages", (String)"GROUP_MUST_DEFINE_NAME", (String)"A group element must define a name.");
                Tr.error((TraceComponent)tc, (String)"BASIC_REGISTRY_INVALID_GROUP_DEFINITION", (Object[])new Object[]{message});
                continue;
            }
            if (result.containsKey(groupName) || bad.contains(groupName)) {
                bad.add(groupName);
                result.remove(groupName);
                Tr.error((TraceComponent)tc, (String)"BASIC_REGISTRY_SAME_GROUP_DEFINITION", (Object[])new Object[]{groupName});
                continue;
            }
            ArrayList<String> members = new ArrayList<String>(group.member().length);
            for (Member member : group.member()) {
                String memberName = member.name().trim();
                if (memberName.isEmpty()) {
                    String message = TraceNLS.getStringFromBundle(BasicRegistry.class, (String)"com.ibm.ws.security.registry.basic.internal.resources.LoggingMessages", (String)"MEMBER_MUST_DEFINE_NAME", (String)"A member element must define a name.");
                    Tr.error((TraceComponent)tc, (String)"BASIC_REGISTRY_INVALID_MEMBER_DEFINITION", (Object[])new Object[]{message});
                    continue;
                }
                if (members.contains(memberName)) {
                    Tr.warning((TraceComponent)tc, (String)"BASIC_REGISTRY_SAME_MEMBER_DEFINITION", (Object[])new Object[]{memberName, groupName});
                    continue;
                }
                members.add(memberName);
                if (users.containsKey(memberName)) continue;
                Tr.warning((TraceComponent)tc, (String)"BASIC_REGISTRY_UNKNOWN_MEMBER_DEFINITION", (Object[])new Object[]{memberName, groupName});
            }
            result.put(groupName, members);
        }
        return result;
    }

    @Deactivate
    protected void deactivate() {
        this.state = null;
    }

    public String getRealm() {
        return this.state.realm;
    }

    /*
     * WARNING - void declaration
     */
    public String checkPassword(String userSecurityName, @Sensitive String password) throws RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        if (userSecurityName.isEmpty()) {
            throw new IllegalArgumentException("userSecurityName is an empty String");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        if (password.trim().isEmpty()) {
            throw new IllegalArgumentException("password is an empty String");
        }
        boolean valid = false;
        BasicPassword storedPassObj = null;
        if (this.state.ignoreCaseForAuthentication) {
            for (Map.Entry<String, BasicPassword> entry : this.state.users.entrySet()) {
                String keyUserName = entry.getKey();
                if (!keyUserName.equalsIgnoreCase(userSecurityName)) continue;
                storedPassObj = entry.getValue();
            }
        } else {
            storedPassObj = this.state.users.get(userSecurityName);
        }
        if (storedPassObj != null) {
            if (!storedPassObj.isHashed()) {
                ProtectedString inPass = new ProtectedString(password.toCharArray());
                ProtectedString storedPass = storedPassObj.getPassword();
                if (storedPass != null && storedPass.equals((Object)inPass)) {
                    valid = true;
                }
            } else {
                String storedPass = storedPassObj.getHashedPassword();
                if (storedPass != null) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("hash.encoded", storedPass);
                    String inPass = null;
                    try {
                        inPass = PasswordUtil.encode((String)password, (String)PasswordUtil.getCryptoAlgorithm((String)storedPass), props);
                    }
                    catch (Exception exception) {
                        void e;
                        Object[] objectArray = new Object[2];
                        objectArray[0] = userSecurityName;
                        objectArray[1] = "<sensitive java.lang.String>";
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.basic.internal.BasicRegistry", (String)"341", (Object)this, (Object[])objectArray);
                        throw new IllegalArgumentException("password encoding failure : " + e.getMessage());
                    }
                    if (storedPass.equals(inPass)) {
                        valid = true;
                    }
                }
            }
        }
        if (valid) {
            return userSecurityName;
        }
        return null;
    }

    @FFDCIgnore(value={com.ibm.websphere.security.CertificateMapNotSupportedException.class, com.ibm.websphere.security.CertificateMapFailedException.class})
    public String mapCertificate(X509Certificate[] chain) throws CertificateMapNotSupportedException, CertificateMapFailedException, RegistryException {
        if ("NOT_SUPPORTED".equalsIgnoreCase(this.certificateMapMode)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Certificate authentication has been disabled for this basic registry.", (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"BASIC_REGISTRY_CERT_IGNORED", (Object[])new Object[0]);
            throw new CertificateMapNotSupportedException(msg);
        }
        if ("CUSTOM".equalsIgnoreCase(this.certificateMapMode)) {
            if (chain == null || chain.length == 0) {
                throw new IllegalArgumentException("cert is null");
            }
            try {
                X509CertificateMapper mapper = this.iCertificateMapperRef.get();
                if (mapper == null) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"BASIC_REGISTRY_MAPPER_NOT_BOUND", (Object[])new Object[0]);
                    throw new CertificateMapFailedException(msg);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Using custom X.509 certificate mapper: " + mapper.getClass()), (Object[])new Object[0]);
                }
                String name = mapper.mapCertificate(chain);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The custom X.509 certificate mapper returned the following mapping: " + name), (Object[])new Object[0]);
                }
                if (name == null || !this.isValidUser(name)) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"BASIC_REGISTRY_MAPPED_NAME_NOT_FOUND", (Object[])new Object[]{name});
                    throw new CertificateMapFailedException(msg);
                }
                return name;
            }
            catch (com.ibm.websphere.security.CertificateMapNotSupportedException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"BASIC_REGISTRY_CUSTOM_MAPPER_NOT_SUPPORTED", (Object[])new Object[0]);
                throw new CertificateMapNotSupportedException(msg, (Throwable)e);
            }
            catch (com.ibm.websphere.security.CertificateMapFailedException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"BASIC_REGISTRY_CUSTOM_MAPPER_FAILED", (Object[])new Object[0]);
                throw new CertificateMapFailedException(msg, (Throwable)e);
            }
        }
        if (chain == null || chain.length == 0 || chain[0] == null) {
            throw new IllegalArgumentException("cert is null");
        }
        String dn = chain[0].getSubjectX500Principal().getName();
        String name = LDAPUtils.getCNFromDN((String)dn);
        if (name == null || !this.isValidUser(name)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"BASIC_REGISTRY_NAME_NOT_FOUND", (Object[])new Object[]{dn});
            throw new CertificateMapFailedException(msg);
        }
        return name;
    }

    public boolean isValidUser(String userSecurityName) throws RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        String userName = userSecurityName.trim();
        if (userName.isEmpty()) {
            throw new IllegalArgumentException("userSecurityName is an empty String");
        }
        if (this.state.ignoreCaseForAuthentication) {
            for (Map.Entry<String, BasicPassword> entry : this.state.users.entrySet()) {
                String keyUserName = entry.getKey();
                if (!keyUserName.equalsIgnoreCase(userSecurityName)) continue;
                return true;
            }
            return false;
        }
        return this.state.users.containsKey(userName);
    }

    public SearchResult getUsers(String pattern, int limit) throws RegistryException {
        if (this.state.ignoreCaseForAuthentication) {
            pattern = REGEX_IGNORE_CASE_CONTROL + pattern;
        }
        return this.searchMap(this.state.users, pattern, limit);
    }

    private String convertToRegex(String pattern) {
        boolean ignoreCase = pattern.startsWith(REGEX_IGNORE_CASE_CONTROL);
        if (ignoreCase) {
            pattern = pattern.replace(REGEX_IGNORE_CASE_CONTROL, "");
        }
        pattern = pattern.replace("*", ".*");
        pattern = pattern.replace("\\", "\\\\");
        pattern = pattern.replace("(", "\\(").replace(")", "\\)");
        pattern = pattern.replace("{", "\\{").replace("}", "\\}");
        if (ignoreCase) {
            pattern = REGEX_IGNORE_CASE_CONTROL + pattern;
        }
        return pattern;
    }

    private SearchResult searchMap(Map<String, ?> map, String pattern, int limit) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("pattern is an empty String");
        }
        String regexPattern = this.convertToRegex(pattern);
        if (limit < 0) {
            return new SearchResult();
        }
        if (map.size() == 0) {
            return new SearchResult();
        }
        int count = 0;
        int stoppingPoint = limit == 0 ? 0 : limit + 1;
        boolean hasMore = false;
        ArrayList<String> matched = new ArrayList<String>();
        Set<String> userNames = map.keySet();
        for (String name : userNames) {
            if (!name.matches(regexPattern)) continue;
            matched.add(name);
            if (++count != stoppingPoint) continue;
            matched.remove(name);
            hasMore = true;
            break;
        }
        if (count > 0) {
            return new SearchResult(matched, hasMore);
        }
        return new SearchResult();
    }

    public String getUserDisplayName(String userSecurityName) throws EntryNotFoundException, RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        if (userSecurityName.isEmpty()) {
            throw new IllegalArgumentException("userSecurityName is an empty String");
        }
        if (!this.isValidUser(userSecurityName)) {
            throw new EntryNotFoundException(userSecurityName + " does not exist");
        }
        return userSecurityName;
    }

    public String getUniqueUserId(String userSecurityName) throws EntryNotFoundException, RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        if (userSecurityName.isEmpty()) {
            throw new IllegalArgumentException("userSecurityName is an empty String");
        }
        if (!this.isValidUser(userSecurityName)) {
            throw new EntryNotFoundException(userSecurityName + " does not exist");
        }
        return userSecurityName;
    }

    public String getUserSecurityName(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        if (uniqueUserId == null) {
            throw new IllegalArgumentException("uniqueUserId is null");
        }
        if (uniqueUserId.isEmpty()) {
            throw new IllegalArgumentException("uniqueUserId is an empty String");
        }
        if (!this.isValidUser(uniqueUserId)) {
            throw new EntryNotFoundException(uniqueUserId + " does not exist");
        }
        return uniqueUserId;
    }

    public boolean isValidGroup(String groupSecurityName) throws RegistryException {
        if (groupSecurityName == null) {
            throw new IllegalArgumentException("groupSecurityName is null");
        }
        if (groupSecurityName.isEmpty()) {
            throw new IllegalArgumentException("groupSecurityName is an empty String");
        }
        return this.state.groups.containsKey(groupSecurityName);
    }

    public SearchResult getGroups(String pattern, int limit) throws RegistryException {
        return this.searchMap(this.state.groups, pattern, limit);
    }

    public String getGroupDisplayName(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        if (groupSecurityName == null) {
            throw new IllegalArgumentException("groupSecurityName is null");
        }
        if (groupSecurityName.isEmpty()) {
            throw new IllegalArgumentException("groupSecurityName is an empty String");
        }
        if (!this.isValidGroup(groupSecurityName)) {
            throw new EntryNotFoundException(groupSecurityName + " does not exist");
        }
        return groupSecurityName;
    }

    public String getUniqueGroupId(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        if (groupSecurityName == null) {
            throw new IllegalArgumentException("groupSecurityName is null");
        }
        if (groupSecurityName.isEmpty()) {
            throw new IllegalArgumentException("groupSecurityName is an empty String");
        }
        if (!this.isValidGroup(groupSecurityName)) {
            throw new EntryNotFoundException(groupSecurityName + " does not exist");
        }
        return groupSecurityName;
    }

    public String getGroupSecurityName(String uniqueGroupId) throws EntryNotFoundException, RegistryException {
        if (uniqueGroupId == null) {
            throw new IllegalArgumentException("uniqueGroupId is null");
        }
        if (uniqueGroupId.isEmpty()) {
            throw new IllegalArgumentException("uniqueGroupId is an empty String");
        }
        if (!this.isValidGroup(uniqueGroupId)) {
            throw new EntryNotFoundException(uniqueGroupId + " does not exist");
        }
        return uniqueGroupId;
    }

    public List<String> getUniqueGroupIdsForUser(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        return this.getGroupsForUser(uniqueUserId);
    }

    public List<String> getGroupsForUser(String userSecurityName) throws EntryNotFoundException, RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        if (userSecurityName.isEmpty()) {
            throw new IllegalArgumentException("userSecurityName is an empty String");
        }
        if (!this.isValidUser(userSecurityName)) {
            throw new EntryNotFoundException(userSecurityName + " does not exist");
        }
        ArrayList<String> matched = new ArrayList<String>();
        Set<String> groupNames = this.state.groups.keySet();
        for (String groupName : groupNames) {
            if (!this.state.groups.get(groupName).contains(userSecurityName)) continue;
            matched.add(groupName);
        }
        return matched;
    }

    public SearchResult getUsersForGroup(String groupSecurityName, int limit) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException, RegistryException {
        if (groupSecurityName == null) {
            throw new IllegalArgumentException("groupSecurityName is null");
        }
        if (groupSecurityName.isEmpty()) {
            throw new IllegalArgumentException("groupSecurityName is an empty String");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is less than zero");
        }
        if (!this.isValidGroup(groupSecurityName)) {
            throw new EntryNotFoundException(groupSecurityName + " does not exist");
        }
        ArrayList members = new ArrayList(this.state.groups.get(groupSecurityName));
        if (limit == 0) {
            return new SearchResult(members, Boolean.FALSE.booleanValue());
        }
        Iterator iter = members.iterator();
        ArrayList<String> limitMembers = new ArrayList<String>();
        for (int numberToReturn = 0; iter.hasNext() && numberToReturn < limit; ++numberToReturn) {
            limitMembers.add((String)iter.next());
        }
        if (iter.hasNext()) {
            return new SearchResult(limitMembers, Boolean.TRUE.booleanValue());
        }
        return new SearchResult(limitMembers, Boolean.FALSE.booleanValue());
    }

    public String getType() {
        return TYPE;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setCertificateMapper(X509CertificateMapper reference) {
        this.iCertificateMapperRef.set(reference);
    }

    protected void unsetCertificateMapper(X509CertificateMapper reference) {
        this.iCertificateMapperRef.compareAndSet(reference, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class State {
        final String realm;
        final boolean ignoreCaseForAuthentication;
        final Map<String, BasicPassword> users;
        final Map<String, List<String>> groups;
        static final long serialVersionUID = 5710178692591493678L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public State(String realm, boolean ignoreCaseForAuthentication, Map<String, BasicPassword> users, Map<String, List<String>> groups) {
            this.realm = realm;
            this.ignoreCaseForAuthentication = ignoreCaseForAuthentication;
            this.users = users;
            this.groups = groups;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(State.class, (String[])new String[]{"UserRegistry", BasicRegistry.DEFAULT_REALM_NAME}, (String)"com.ibm.ws.security.registry.basic.internal.resources.LoggingMessages", (String)"com.ibm.ws.security.registry.basic.internal.BasicRegistry$State");
        }
    }
}

