/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.reader.GenericFile;
import com.ibm.ws.logging.hpel.LogRepositoryBrowser;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBaseImpl;
import com.ibm.ws.logging.object.hpel.RepositoryPointerImpl;
import java.io.File;
import java.io.FileFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class LogRepositoryBrowserImpl
extends LogRepositoryBaseImpl
implements LogRepositoryBrowser {
    private final String pid;
    private final String label;
    private long timestamp;
    private final String[] ids;

    public LogRepositoryBrowserImpl(File directory, String[] ids) {
        super(directory);
        this.timestamp = LogRepositoryBrowserImpl.parseTimeStamp(directory.getName());
        this.pid = LogRepositoryBrowserImpl.parseProcessID(directory.getName());
        this.label = LogRepositoryBrowserImpl.parseLabel(directory.getName());
        this.ids = ids;
    }

    private File getChild(String name) {
        File result = this.getLocation() instanceof GenericFile ? ((GenericFile)((Object)this.getLocation())).getChild(name) : new File(this.getLocation(), name);
        return result;
    }

    @Override
    public File findFile(RepositoryPointerImpl location) {
        File result = this.getChild(location.getFileId());
        return this.isFile(result) ? result : null;
    }

    private boolean isFile(final File result) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return result.isFile();
            }
        });
    }

    @Override
    public File findNext(RepositoryPointerImpl location, long timelimit) {
        return this.findNext(this.getChild(location.getFileId()), timelimit);
    }

    @Override
    public File findByMillis(long timestamp) {
        File[] files = this.listFiles(this.filter);
        File result = null;
        long max = Long.MIN_VALUE;
        for (File file : files) {
            long time = this.getLogFileTimestamp(file);
            if (max >= time || time > timestamp) continue;
            max = time;
            result = file;
        }
        return result;
    }

    @Override
    public File findNext(File current, long timelimit) {
        File[] files = this.listFiles(this.filter);
        File result = null;
        long min = Long.MAX_VALUE;
        long cur = current == null ? Long.MIN_VALUE : this.getLogFileTimestamp(current);
        for (File file : files) {
            long time = this.getLogFileTimestamp(file);
            if (cur >= time || time >= min) continue;
            min = time;
            result = file;
        }
        return timelimit > 0L && timelimit < min ? null : result;
    }

    @Override
    public File findPrev(File current, long timelimit) {
        long cur;
        long l = current == null ? (timelimit < 0L ? Long.MAX_VALUE : timelimit) : (cur = this.getLogFileTimestamp(current));
        if (timelimit >= 0L && cur < timelimit) {
            return null;
        }
        File[] files = this.listFiles(this.filter);
        File result = null;
        long max = Long.MIN_VALUE;
        for (File file : files) {
            long time = this.getLogFileTimestamp(file);
            if (cur <= time || time <= max) continue;
            max = time;
            result = file;
        }
        return result;
    }

    @Override
    public int count(File first, File last) {
        File[] files = this.listFiles(this.filter);
        if (first == null && last == null) {
            return files.length;
        }
        int count = 0;
        long min = first == null ? Long.MIN_VALUE : this.getLogFileTimestamp(first);
        long max = last == null ? Long.MAX_VALUE : this.getLogFileTimestamp(last);
        for (File file : files) {
            long time = this.getLogFileTimestamp(file);
            if (min > time || time > max) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Map<String, LogRepositoryBrowser> getSubProcesses() {
        HashMap<String, LogRepositoryBrowser> result = new HashMap<String, LogRepositoryBrowser>();
        for (File file : this.listFiles(this.subprocFilter)) {
            String id = this.getSubProcessId(file);
            String[] newIds = Arrays.copyOf(this.ids, this.ids.length + 1);
            newIds[this.ids.length] = id;
            result.put(id, new LogRepositoryBrowserImpl(file, newIds));
        }
        return result;
    }

    private File[] listFiles(final FileFilter subprocFilter) {
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return LogRepositoryBrowserImpl.this.getLocation().listFiles(subprocFilter);
            }
        });
    }

    private String getSubProcessId(File file) {
        return file.getName();
    }

    @Override
    public String[] getIds() {
        return this.ids;
    }

    @Override
    public String getProcessId() {
        return this.pid;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public long getTimestamp() {
        if (this.timestamp < 0L) {
            this.timestamp = this.getLogFileTimestamp(this.findNext((File)null, -1L));
        }
        return this.timestamp;
    }
}

