/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class AttachmentSerializer {
    private static final String DEFAULT_MULTIPART_TYPE = "multipart/related";
    private String contentTransferEncoding;
    private static final Logger LOG = LogUtils.getL7dLogger(AttachmentSerializer.class);
    private Message message;
    private String bodyBoundary;
    private OutputStream out;
    private String encoding;
    private String multipartType;
    private Map<String, List<String>> rootHeaders;
    private boolean xop;
    private boolean writeOptionalTypeParameters;
    private static boolean supportSeparateAction = false;
    static final long serialVersionUID = -2489879459227640036L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AttachmentSerializer(Message messageParam) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "<init>", new Object[]{messageParam});
        }
        this.contentTransferEncoding = "binary";
        this.rootHeaders = Collections.emptyMap();
        this.xop = true;
        this.writeOptionalTypeParameters = true;
        this.message = messageParam;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AttachmentSerializer(Message messageParam, String multipartType, boolean writeOptionalTypeParameters, Map<String, List<String>> headers) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "<init>", new Object[]{messageParam, multipartType, writeOptionalTypeParameters, headers});
        }
        this.contentTransferEncoding = "binary";
        this.rootHeaders = Collections.emptyMap();
        this.xop = true;
        this.writeOptionalTypeParameters = true;
        this.message = messageParam;
        this.multipartType = multipartType;
        this.writeOptionalTypeParameters = writeOptionalTypeParameters;
        this.rootHeaders = headers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeProlog() throws IOException {
        boolean xopOrMultipartRelated;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "writeProlog", new Object[0]);
        }
        this.bodyBoundary = AttachmentUtil.getUniqueBoundaryValue();
        String bodyCt = (String)this.message.get("Content-Type");
        String bodyCtParams = null;
        String bodyCtParamsEscaped = null;
        if (bodyCt.indexOf(59) != -1) {
            int pos = bodyCt.indexOf(59);
            bodyCtParams = bodyCt.substring(pos);
            bodyCtParamsEscaped = AttachmentSerializer.escapeQuotes(bodyCtParams);
            bodyCt = bodyCt.substring(0, pos);
        }
        String requestMimeType = this.multipartType == null ? DEFAULT_MULTIPART_TYPE : this.multipartType;
        StringBuilder ct = new StringBuilder(32);
        ct.append(requestMimeType);
        boolean bl = xopOrMultipartRelated = this.xop || DEFAULT_MULTIPART_TYPE.equalsIgnoreCase(requestMimeType) || DEFAULT_MULTIPART_TYPE.startsWith(requestMimeType);
        if (xopOrMultipartRelated && requestMimeType.indexOf("type=") == -1) {
            if (this.xop) {
                ct.append("; type=\"application/xop+xml\"");
            } else {
                ct.append("; type=\"").append(bodyCt).append('\"');
            }
        }
        ct.append("; boundary=\"").append(this.bodyBoundary).append('\"');
        String rootContentId = this.getHeaderValue("Content-ID", "root.message@cxf.apache.org");
        if (xopOrMultipartRelated) {
            ct.append("; start=\"<").append(AttachmentSerializer.checkAngleBrackets(rootContentId)).append(">\"");
        }
        if (this.writeOptionalTypeParameters || this.xop) {
            ct.append("; start-info=\"").append(bodyCt);
            if (supportSeparateAction) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Format Content-Type using separate action attribute");
                }
                if (bodyCtParams != null) {
                    ct.append("\"").append(bodyCtParams);
                }
            } else {
                if (bodyCtParamsEscaped != null) {
                    ct.append(bodyCtParamsEscaped);
                }
                ct.append('\"');
            }
        }
        this.message.put("Content-Type", ct.toString());
        this.out = this.message.getContent(OutputStream.class);
        this.encoding = (String)this.message.get(Message.ENCODING);
        if (this.encoding == null) {
            this.encoding = StandardCharsets.UTF_8.name();
        }
        StringWriter writer = new StringWriter();
        writer.write("\r\n");
        writer.write("--");
        writer.write(this.bodyBoundary);
        StringBuilder mimeBodyCt = new StringBuilder();
        String bodyType = this.getHeaderValue("Content-Type", null);
        if (bodyType == null) {
            mimeBodyCt.append(this.xop ? "application/xop+xml" : bodyCt).append("; charset=").append(this.encoding);
            if (this.xop) {
                mimeBodyCt.append("; type=\"").append(bodyCt);
                if (bodyCtParamsEscaped != null) {
                    mimeBodyCt.append(bodyCtParamsEscaped);
                }
                mimeBodyCt.append('\"');
            } else if (bodyCtParams != null) {
                mimeBodyCt.append(bodyCtParams);
            }
        } else {
            mimeBodyCt.append(bodyType);
        }
        this.writeHeaders(mimeBodyCt.toString(), rootContentId, this.rootHeaders, writer);
        this.out.write(writer.getBuffer().toString().getBytes(this.encoding));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "writeProlog");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String escapeQuotes(String s) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "escapeQuotes", new Object[]{s});
        }
        String string = s.indexOf(34) != 0 ? s.replace("\"", "\\\"") : s;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "escapeQuotes", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setContentTransferEncoding(String cte) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "setContentTransferEncoding", new Object[]{cte});
        }
        this.contentTransferEncoding = cte;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "setContentTransferEncoding");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getHeaderValue(String name, String defaultValue) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "getHeaderValue", new Object[]{name, defaultValue});
        }
        List<String> value = this.rootHeaders.get(name);
        if (value == null || value.isEmpty()) {
            String string = defaultValue;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "getHeaderValue", string);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.size(); ++i) {
            sb.append(value.get(i));
            if (i + 1 >= value.size()) continue;
            sb.append(',');
        }
        String string = sb.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "getHeaderValue", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void writeHeaders(String contentType, String attachmentId, Map<String, List<String>> headers, Writer writer) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "writeHeaders", new Object[]{contentType, attachmentId, headers, writer});
        }
        writer.write("\r\nContent-Type: ");
        writer.write(contentType);
        writer.write("\r\nContent-Transfer-Encoding: " + this.contentTransferEncoding + "\r\n");
        if (attachmentId != null) {
            attachmentId = AttachmentSerializer.checkAngleBrackets(attachmentId);
            writer.write("Content-ID: <");
            if (attachmentId.startsWith("cid:")) {
                writer.write(AttachmentSerializer.decode(attachmentId.substring(4), StandardCharsets.UTF_8));
            } else {
                String[] address = attachmentId.split("@", 2);
                if (address.length == 2) {
                    String decoded = AttachmentSerializer.tryDecode(address[1], StandardCharsets.UTF_8);
                    if (!decoded.equalsIgnoreCase(address[1])) {
                        writer.write(address[0] + "@" + decoded);
                    } else {
                        writer.write(attachmentId);
                    }
                } else {
                    writer.write(URLEncoder.encode(attachmentId, StandardCharsets.UTF_8.name()));
                }
            }
            writer.write(">\r\n");
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            if ("Content-Type".equalsIgnoreCase(name) || "Content-ID".equalsIgnoreCase(name) || "Content-Transfer-Encoding".equalsIgnoreCase(name)) continue;
            writer.write(name);
            writer.write(": ");
            List<String> values = entry.getValue();
            for (int i = 0; i < values.size(); ++i) {
                writer.write(values.get(i));
                if (i + 1 >= values.size()) continue;
                writer.write(",");
            }
            writer.write("\r\n");
        }
        writer.write("\r\n");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "writeHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String checkAngleBrackets(String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "checkAngleBrackets", new Object[]{value});
        }
        if (value.charAt(0) == '<' && value.charAt(value.length() - 1) == '>') {
            String string = value.substring(1, value.length() - 1);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "checkAngleBrackets", string);
            }
            return string;
        }
        String string = value;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "checkAngleBrackets", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeAttachments() throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "writeAttachments", new Object[0]);
        }
        if (this.message.getAttachments() != null) {
            for (Attachment a : this.message.getAttachments()) {
                Map<String, List<String>> headers;
                StringWriter writer = new StringWriter();
                writer.write("\r\n--");
                writer.write(this.bodyBoundary);
                Iterator<String> it = a.getHeaderNames();
                if (it.hasNext()) {
                    headers = new LinkedHashMap();
                    while (it.hasNext()) {
                        String key = it.next();
                        headers.put(key, Collections.singletonList(a.getHeader(key)));
                    }
                } else {
                    headers = Collections.emptyMap();
                }
                DataHandler handler = a.getDataHandler();
                handler.setCommandMap(AttachmentUtil.getCommandMap());
                this.writeHeaders(handler.getContentType(), a.getId(), headers, writer);
                this.out.write(writer.getBuffer().toString().getBytes(this.encoding));
                if ("base64".equals(this.contentTransferEncoding)) {
                    InputStream inputStream = handler.getInputStream();
                    try {
                        this.encodeBase64(inputStream, this.out, 4096);
                        continue;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        continue;
                    }
                }
                handler.writeTo(this.out);
            }
        }
        StringWriter writer = new StringWriter();
        writer.write("\r\n--");
        writer.write(this.bodyBoundary);
        writer.write("--");
        this.out.write(writer.getBuffer().toString().getBytes(this.encoding));
        this.out.flush();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "writeAttachments");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int encodeBase64(InputStream input, OutputStream output, int bufferSize) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "encodeBase64", new Object[]{input, output, bufferSize});
        }
        int avail = input.available();
        if (avail > 262143) {
            avail = 262143;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            int left;
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            if ((n -= (left = n % 3)) > 0) {
                Base64Utility.encodeAndStream(buffer, 0, n, output);
                total += n;
            }
            if (left != 0) {
                for (int x = 0; x < left; ++x) {
                    buffer[x] = buffer[n + x];
                }
                n = input.read(buffer, left, buffer.length - left);
                if (n != -1) continue;
                Base64Utility.encodeAndStream(buffer, 0, left, output);
                total += left;
                continue;
            }
            n = input.read(buffer);
        }
        int n2 = total;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n2 = n2;
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "encodeBase64", n2);
        }
        return n2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isXop() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "isXop", new Object[0]);
        }
        boolean bl = this.xop;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "isXop", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setXop(boolean xop) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "setXop", new Object[]{xop});
        }
        this.xop = xop;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "setXop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String decode(String s, Charset charset) throws UnsupportedEncodingException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "decode", new Object[]{s, charset});
        }
        String dString = URLDecoder.decode(s.replaceAll("([^%])[+]", "$1%2B"), charset.name());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("decode: Original string:  " + s + ", charset: " + charset + ", Decoded string: " + dString);
        }
        String string = dString;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "decode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String tryDecode(String s, Charset charset) {
        String string;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentSerializer", "tryDecode", new Object[]{s, charset});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        try {
            String dString = AttachmentSerializer.decode(s, charset);
            if (isFinestEnabled) {
                LOG.finest("tryDecode: Original string:  " + s + ", charset: " + charset + ", Decoded string: " + dString);
            }
            string = dString;
        }
        catch (IllegalArgumentException ex) {
            if (isFinestEnabled) {
                LOG.finest("tryDecode: IllegalArgumentException exception: " + ex);
            }
            String string2 = s;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string2 = string2;
                LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "tryDecode", string2);
            }
            return string2;
        }
        catch (UnsupportedEncodingException ex) {
            if (isFinestEnabled) {
                LOG.finest("tryDecode: UnsupportedEncodingException exception: " + ex);
            }
            String string3 = s;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string3 = string3;
                LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "tryDecode", string3);
            }
            return string3;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentSerializer", "tryDecode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        String unescapedAction = System.getProperty("cxf.support.unescaped.action");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "cxf.support.unescaped.action property is set to " + unescapedAction);
        }
        if (unescapedAction != null && unescapedAction.trim().length() > 0 && unescapedAction.trim().equalsIgnoreCase("true")) {
            supportSeparateAction = true;
        }
    }
}

