/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.PersistentTimer;
import com.ibm.ejs.container.PersistentTimerTaskHandler;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.concurrent.persistent.PersistentExecutor;
import com.ibm.websphere.concurrent.persistent.TaskState;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.ejb.TimerStatus;
import com.ibm.ws.concurrent.persistent.ejb.TimerTrigger;
import com.ibm.ws.concurrent.persistent.ejb.TimersPersistentExecutor;
import com.ibm.ws.ejbcontainer.osgi.EJBPersistentTimerRuntime;
import com.ibm.ws.ejbcontainer.osgi.EJBTimerRuntime;
import com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerImpl;
import com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerTaskHandlerImpl;
import com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.SGPersistentTimerTaskHandlerImpl;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ejb.AutomaticTimerBean;
import com.ibm.ws.metadata.ejb.TimerMethodData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.enterprise.concurrent.Trigger;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tcContainer", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EJBPersistentTimerRuntime.class, EJBPersistentTimerRuntimeImpl.class}, configurationPid={"com.ibm.ws.ejbcontainer.timer.runtime"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class EJBPersistentTimerRuntimeImpl
implements EJBPersistentTimerRuntime {
    private static final TraceComponent tcContainer = Tr.register(EJBPersistentTimerRuntimeImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String REFERENCE_EJB_TIMER_RUNTIME = "ejbTimerRuntime";
    private static final String REFERENCE_DEFAULT_PERSISTENT_EXECUTOR = "defaultEJBPersistentTimerExecutor";
    private static final String MISSED_TIMER_ACTION = "missedPersistentTimerAction";
    private final AtomicServiceReference<EJBTimerRuntime> ejbTimerRuntimeServiceRef = new AtomicServiceReference("ejbTimerRuntime");
    private final AtomicServiceReference<PersistentExecutor> defaultPersistentExecutorRef = new AtomicServiceReference("defaultEJBPersistentTimerExecutor");
    private boolean enabledDatabasePolling;
    private boolean hasSetupTimers;
    private volatile boolean serverStopping;
    private MissedTimerAction missedTimerAction;
    private volatile Map<String, Integer> allowCachedTimerDataMap;
    static final long serialVersionUID = -1877716176971059212L;

    @Reference(name="ejbTimerRuntime", service=EJBTimerRuntime.class)
    protected void setEJBTimerRuntime(ServiceReference<EJBTimerRuntime> ref) {
        this.ejbTimerRuntimeServiceRef.setReference(ref);
    }

    protected void unsetEJBTimerRuntime(ServiceReference<EJBTimerRuntime> ref) {
        this.ejbTimerRuntimeServiceRef.unsetReference(ref);
    }

    @Reference(name="defaultEJBPersistentTimerExecutor", service=PersistentExecutor.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, target="(id=defaultEJBPersistentTimerExecutor)")
    protected void setDefaultEJBPersistentTimerExecutor(ServiceReference<PersistentExecutor> ref) {
        this.defaultPersistentExecutorRef.setReference(ref);
    }

    protected void unsetDefaultEJBPersistentTimerExecutor(ServiceReference<PersistentExecutor> ref) {
        this.defaultPersistentExecutorRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.ejbTimerRuntimeServiceRef.activate(cc);
        this.defaultPersistentExecutorRef.activate(cc);
        this.updateConfiguration(properties);
        PersistentTimerTaskHandlerImpl.persistentTimerRuntime = this;
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> properties) {
        this.updateConfiguration(properties);
    }

    private void updateConfiguration(Map<String, Object> properties) {
        String missedTimerActionProperty = (String)properties.get(MISSED_TIMER_ACTION);
        MissedTimerAction missedTimerAction = this.missedTimerAction = missedTimerActionProperty != null ? MissedTimerAction.valueOf(missedTimerActionProperty) : null;
        if (TraceComponent.isAnyTracingEnabled() && tcContainer.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcContainer, (String)("MissedTimerAction = " + (Object)((Object)this.missedTimerAction)), (Object[])new Object[0]);
        }
        if (ContainerProperties.AllowCachedTimerDataFor != null) {
            HashMap<String, Integer> newAllowCachedTimerDataMap = new HashMap<String, Integer>();
            StringTokenizer st = new StringTokenizer(ContainerProperties.AllowCachedTimerDataFor, ":");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int assignmentPivot = token.indexOf(61);
                if (assignmentPivot > 0) {
                    String tokenName = token.substring(0, assignmentPivot).trim();
                    String tokenValue = token.substring(assignmentPivot + 1).trim();
                    try {
                        newAllowCachedTimerDataMap.put(tokenName, Integer.parseInt(tokenValue));
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl", (String)"161", (Object)this, (Object[])new Object[]{properties});
                    }
                    continue;
                }
                newAllowCachedTimerDataMap.put(token, -1);
            }
            this.allowCachedTimerDataMap = newAllowCachedTimerDataMap;
        } else {
            this.allowCachedTimerDataMap = null;
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.ejbTimerRuntimeServiceRef.deactivate(cc);
        this.defaultPersistentExecutorRef.deactivate(cc);
    }

    TimersPersistentExecutor getPersistentExecutor() {
        TimersPersistentExecutor pExecutor = (TimersPersistentExecutor)((EJBTimerRuntime)this.ejbTimerRuntimeServiceRef.getServiceWithException()).getPersistentExecutor();
        if (pExecutor == null && (pExecutor = (TimersPersistentExecutor)this.defaultPersistentExecutorRef.getService()) == null) {
            throw new IllegalStateException("The ejbPersistentTimer feature is enabled, but the defaultEJBPersistentTimerExecutor persistent executor cannot be resolved. The most likely cause is that the DefaultDataSource datasource has not been configured. Persistent EJB timers require a datasource configuration for persistence.");
        }
        return pExecutor;
    }

    public Timer createPersistentExpirationTimer(BeanId beanId, Date expiration, long interval, @Sensitive Serializable info) {
        J2EEName j2eeName = beanId.getJ2EEName();
        boolean singleton = beanId.getHome().isSingletonSessionHome();
        PersistentTimerTaskHandlerImpl tthandler = singleton ? new SGPersistentTimerTaskHandlerImpl(j2eeName, info, expiration, interval) : new PersistentTimerTaskHandlerImpl(j2eeName, info, expiration, interval);
        TimerStatus timerStatus = (TimerStatus)this.getPersistentExecutor().schedule((Runnable)((Object)tthandler), (Trigger)tthandler);
        return new PersistentTimerImpl(timerStatus.getTaskId(), j2eeName, beanId.getBeanMetaData().allowCachedTimerDataForMethods, tthandler, timerStatus, this);
    }

    public Timer createPersistentCalendarTimer(BeanId beanId, ParsedScheduleExpression parsedExpr, @Sensitive Serializable info) {
        J2EEName j2eeName = beanId.getJ2EEName();
        boolean singleton = beanId.getHome().isSingletonSessionHome();
        PersistentTimerTaskHandlerImpl tthandler = singleton ? new SGPersistentTimerTaskHandlerImpl(j2eeName, info, parsedExpr) : new PersistentTimerTaskHandlerImpl(j2eeName, info, parsedExpr);
        long firstTimeout = parsedExpr.getFirstTimeout();
        if (firstTimeout == -1L) {
            return new PersistentTimerImpl(null, j2eeName, beanId.getBeanMetaData().allowCachedTimerDataForMethods, tthandler, null, this);
        }
        TimerStatus timerStatus = (TimerStatus)this.getPersistentExecutor().schedule((Runnable)((Object)tthandler), (Trigger)tthandler);
        return new PersistentTimerImpl(timerStatus.getTaskId(), j2eeName, beanId.getBeanMetaData().allowCachedTimerDataForMethods, tthandler, timerStatus, this);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public int createPersistentAutomaticTimers(String appName, String moduleName, List<AutomaticTimerBean> timerBeans) throws RuntimeWarning {
        int numCreated;
        block20: {
            EmbeddableWebSphereTransactionManager transactionManager;
            TimersPersistentExecutor persistentExecutor;
            boolean commit;
            String modulePropertyName;
            block19: {
                modulePropertyName = PersistentTimerTaskHandlerImpl.getAutomaticTimerPropertyName(appName, moduleName);
                numCreated = 0;
                commit = true;
                persistentExecutor = this.getPersistentExecutor();
                transactionManager = EmbeddableTransactionManagerFactory.getTransactionManager();
                transactionManager.begin();
                if (persistentExecutor.createProperty(modulePropertyName, "0")) break block19;
                if (TraceComponent.isAnyTracingEnabled() && tcContainer.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tcContainer, (String)("Persistent Automatic Timers have already been created for " + appName + "#" + moduleName), (Object[])new Object[0]);
                }
                commit = false;
                int n = 0;
                try {
                    if (!commit) {
                        transactionManager.rollback();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl", (String)"286", (Object)this, (Object[])new Object[]{appName, moduleName, timerBeans});
                }
                return n;
            }
            for (AutomaticTimerBean timerBean : timerBeans) {
                if (timerBean.getNumPersistentTimers() == 0) continue;
                for (TimerMethodData timerMethod : timerBean.getMethods()) {
                    for (TimerMethodData.AutomaticTimer timer : timerMethod.getAutomaticTimers()) {
                        ParsedScheduleExpression parsedSchedule;
                        long firstTimeout;
                        if (!timer.isPersistent() || (firstTimeout = (parsedSchedule = timerBean.parseScheduleExpression(timer)).getFirstTimeout()) == -1L) continue;
                        String className = null;
                        if (!timer.isXML()) {
                            className = timerMethod.getMethod().getDeclaringClass().getName();
                        }
                        BeanId beanId = timerBean.getBeanId();
                        int methodId = timerMethod.getMethodId();
                        boolean singleton = timerBean.getBeanMetaData().isSingletonSessionBean();
                        PersistentTimerTaskHandlerImpl tthandler = singleton ? new SGPersistentTimerTaskHandlerImpl(beanId.getJ2EEName(), timer.getInfo(), parsedSchedule, methodId, timerMethod.getMethod().getName(), className) : new PersistentTimerTaskHandlerImpl(beanId.getJ2EEName(), timer.getInfo(), parsedSchedule, methodId, timerMethod.getMethod().getName(), className);
                        persistentExecutor.schedule((TimerTrigger)tthandler);
                        ++numCreated;
                    }
                }
            }
            persistentExecutor.setProperty(modulePropertyName, Integer.toString(numCreated));
            transactionManager.commit();
            try {
                if (!commit) {
                    transactionManager.rollback();
                }
                break block20;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl", (String)"286", (Object)this, (Object[])new Object[]{appName, moduleName, timerBeans});
            }
            break block20;
            catch (Throwable throwable) {
                try {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl", (String)"278", (Object)this, (Object[])new Object[]{appName, moduleName, timerBeans});
                    commit = false;
                    Tr.error((TraceComponent)tcContainer, (String)"AUTOMATIC_TIMER_CREATION_FAILURE_CNTR0218E", (Object[])new Object[]{moduleName, t});
                    throw new RuntimeWarning((Throwable)t);
                }
                catch (Throwable throwable2) {
                    try {
                        if (!commit) {
                            transactionManager.rollback();
                        }
                    }
                    catch (Throwable throwable3) {
                        FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl", (String)"286", (Object)this, (Object[])new Object[]{appName, moduleName, timerBeans});
                    }
                    throw throwable2;
                }
            }
        }
        return numCreated;
    }

    public PersistentTimer getPersistentTimer(long taskId, J2EEName j2eeName, PersistentTimerTaskHandler taskHandler) {
        return new PersistentTimerImpl(taskId, j2eeName, this.getAllowCachedTimerData(j2eeName), taskHandler, null, this);
    }

    public Timer getPersistentTimer(long taskId) {
        return new PersistentTimerImpl(taskId, null, 0, null, null, this);
    }

    /*
     * WARNING - void declaration
     */
    public Timer getPersistentTimerFromStore(long taskId) throws NoSuchObjectLocalException {
        TimerStatus timerStatus;
        PersistentTimerTaskHandler taskHandler = null;
        try {
            timerStatus = this.getPersistentExecutor().getTimerStatus(taskId);
            if (timerStatus != null) {
                taskHandler = (PersistentTimerTaskHandler)timerStatus.getTimer();
            }
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl", (String)"320", (Object)this, (Object[])new Object[]{taskId});
            String msg = "An error occurred accessing the persistent EJB timer with the " + taskId + " task identifier : " + ex.getMessage();
            throw new TimerServiceException(msg, (Throwable)ex);
        }
        if (taskHandler == null) {
            String msg = "Persistent EJB timer with the " + taskId + " task identifier no longer exists.";
            throw new NoSuchObjectLocalException(msg);
        }
        J2EEName j2eeName = taskHandler.getJ2EEName();
        int cachedTimerDataAllowed = this.getAllowCachedTimerData(j2eeName);
        return new PersistentTimerImpl(taskId, j2eeName, cachedTimerDataAllowed, taskHandler, timerStatus, this);
    }

    Date getNextExecutionTime(long taskId) throws Exception {
        return this.getPersistentExecutor().getNextExecutionTime(taskId);
    }

    TimerStatus<?> getTimerStatus(long taskId) throws Exception {
        return this.getPersistentExecutor().getTimerStatus(taskId);
    }

    boolean remove(long taskId) {
        return this.getPersistentExecutor().remove(taskId);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<Timer> getTimers(BeanId beanId) {
        HashSet<Timer> timers = new HashSet<Timer>();
        J2EEName j2eeName = beanId.getJ2EEName();
        String taskName = PersistentTimerTaskHandlerImpl.getTaskNameBeanPattern(j2eeName);
        int cachedTimerDataAllowed = beanId.getBeanMetaData().allowCachedTimerDataForMethods;
        try {
            if (cachedTimerDataAllowed != 0) {
                List tasks = this.getPersistentExecutor().findTimerStatus(j2eeName.getApplication(), taskName, Character.valueOf('\\'), TaskState.ANY, true, null, null);
                for (TimerStatus taskStatus : tasks) {
                    timers.add((Timer)new PersistentTimerImpl(taskStatus.getTaskId(), j2eeName, cachedTimerDataAllowed, null, taskStatus, this));
                }
            } else {
                List taskIds = this.getPersistentExecutor().findTaskIds(taskName, Character.valueOf('\\'), TaskState.ANY, true, null, null);
                for (Long taskId : taskIds) {
                    timers.add((Timer)new PersistentTimerImpl(taskId, j2eeName, cachedTimerDataAllowed, null, null, this));
                }
            }
        }
        catch (Throwable taskIds) {
            void ex;
            FFDCFilter.processException((Throwable)taskIds, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl", (String)"413", (Object)this, (Object[])new Object[]{beanId});
            String msg = "An error occurred accessing the persistent EJB timers for the " + j2eeName.getComponent() + " bean in the " + j2eeName.getModule() + " in the " + j2eeName.getApplication() + " application : " + ex.getMessage();
            throw new TimerServiceException(msg, (Throwable)ex);
        }
        return timers;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<Timer> getAllTimers(String appName, String moduleName, boolean allowsCachedTimerData) {
        HashSet<Timer> timers = new HashSet<Timer>();
        String taskName = PersistentTimerTaskHandlerImpl.getTaskNameModulePattern(moduleName);
        try {
            if (allowsCachedTimerData) {
                List tasks = this.getPersistentExecutor().findTimerStatus(appName, taskName, Character.valueOf('\\'), TaskState.ANY, true, null, null);
                for (TimerStatus taskStatus : tasks) {
                    timers.add((Timer)new PersistentTimerImpl(taskStatus.getTaskId(), null, 0, null, taskStatus, this));
                }
            } else {
                List taskIds = this.getPersistentExecutor().findTaskIds(taskName, Character.valueOf('\\'), TaskState.ANY, true, null, null);
                for (Long taskId : taskIds) {
                    timers.add((Timer)new PersistentTimerImpl(taskId, null, 0, null, null, this));
                }
            }
        }
        catch (Throwable taskIds) {
            void ex;
            FFDCFilter.processException((Throwable)taskIds, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl", (String)"456", (Object)this, (Object[])new Object[]{appName, moduleName, allowsCachedTimerData});
            String msg = "An error occurred accessing the persistent EJB timers for the " + moduleName + " in the " + appName + " application : " + ex.getMessage();
            throw new TimerServiceException(msg, (Throwable)ex);
        }
        return timers;
    }

    protected int getAllowCachedTimerData(J2EEName j2eeName) {
        Integer allowCachedTimerData = null;
        Map<String, Integer> localAllowCachedTimerDataMap = this.allowCachedTimerDataMap;
        if (localAllowCachedTimerDataMap != null && (allowCachedTimerData = localAllowCachedTimerDataMap.get(j2eeName.toString())) == null) {
            allowCachedTimerData = localAllowCachedTimerDataMap.get("*");
        }
        return allowCachedTimerData != null ? allowCachedTimerData : 0;
    }

    public void resetAndCheckDatabasePolling() {
        this.enabledDatabasePolling = false;
        this.checkStartPolling();
    }

    public void enableDatabasePolling() {
        this.hasSetupTimers = true;
        this.checkStartPolling();
    }

    private void checkStartPolling() {
        if (this.serverStopping) {
            return;
        }
        if (!this.enabledDatabasePolling && this.hasSetupTimers) {
            ServiceReference defaultPExecutorRef;
            EJBTimerRuntime timerRuntime = (EJBTimerRuntime)this.ejbTimerRuntimeServiceRef.getService();
            Long initialPollDelay = timerRuntime != null && timerRuntime.getPersistentExecutorRef() != null ? (Long)timerRuntime.getPersistentExecutorRef().getProperty("initialPollDelay") : ((defaultPExecutorRef = this.defaultPersistentExecutorRef.getReference()) != null ? (Long)defaultPExecutorRef.getProperty("initialPollDelay") : null);
            if (TraceComponent.isAnyTracingEnabled() && tcContainer.isDebugEnabled()) {
                if (initialPollDelay != null) {
                    Tr.debug((TraceComponent)tcContainer, (String)("initial: " + initialPollDelay), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tcContainer, (String)"Unable to determine which PersistentExecutor is being used", (Object[])new Object[0]);
                }
            }
            if (initialPollDelay == null || initialPollDelay == -1L) {
                this.getPersistentExecutor().startPolling();
                this.enabledDatabasePolling = true;
            }
        }
    }

    public void serverStopping() {
        this.serverStopping = true;
    }

    @Trivial
    public boolean isConfigured() {
        EJBTimerRuntime timerRuntime = (EJBTimerRuntime)this.ejbTimerRuntimeServiceRef.getService();
        if (timerRuntime != null && timerRuntime.getPersistentExecutorRef() != null) {
            if (TraceComponent.isAnyTracingEnabled() && tcContainer.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcContainer, (String)"isServiceConfigured : true : configured persistent executor", (Object[])new Object[0]);
            }
            return true;
        }
        ServiceReference defaultPExecutorRef = this.defaultPersistentExecutorRef.getReference();
        if (defaultPExecutorRef != null) {
            if (TraceComponent.isAnyTracingEnabled() && tcContainer.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcContainer, (String)"isServiceConfigured : true : default persistent executor", (Object[])new Object[0]);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tcContainer.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcContainer, (String)"isServiceConfigured : false : no persistent executor", (Object[])new Object[0]);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    MissedTimerAction getMissedTimerAction() {
        block7: {
            if (this.missedTimerAction != null) {
                if (TraceComponent.isAnyTracingEnabled() && tcContainer.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tcContainer, (String)("MissedTimerAction = " + (Object)((Object)this.missedTimerAction)), (Object[])new Object[0]);
                }
                return this.missedTimerAction;
            }
            try {
                if (this.getPersistentExecutor().isFailOverEnabled()) {
                    if (TraceComponent.isAnyTracingEnabled() && tcContainer.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tcContainer, (String)("MissedTimerAction = " + (Object)((Object)MissedTimerAction.ONCE)), (Object[])new Object[0]);
                    }
                    return MissedTimerAction.ONCE;
                }
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.EJBPersistentTimerRuntimeImpl", (String)"576", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tcContainer.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tcContainer, (String)("getMissedTimerAction : " + ex), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tcContainer.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcContainer, (String)("MissedTimerAction = " + (Object)((Object)MissedTimerAction.ALL)), (Object[])new Object[0]);
        }
        return MissedTimerAction.ALL;
    }

    static enum MissedTimerAction {
        ALL,
        ONCE;

    }
}

