/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.tls.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.openliberty.netty.internal.tls.NettyTlsProvider;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"io.openliberty.netty.internal.tls"}, immediate=true, service={NettyTlsProvider.class})
public class NettyTlsProviderImpl
implements NettyTlsProvider {
    private static final TraceComponent tc = Tr.register(NettyTlsProviderImpl.class, null, null);
    static final String ALIAS_KEY = "alias";
    static final long serialVersionUID = 6793959044782149586L;

    @Activate
    protected void activate(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("NettyTlsProviderImpl activate " + this), (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("NettyTlsProviderImpl modified " + this), (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("NettyTlsProviderImpl deactivate " + this), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SslContext getOutboundSSLContext(Map<String, Object> sslOptions, String host, String port) {
        SSLContext jdkContext;
        try {
            Properties props = NettyTlsProviderImpl.createProps(sslOptions);
            String alias = props.getProperty(ALIAS_KEY);
            jdkContext = NettyTlsProviderImpl.getSSLContext(alias, props, false, host, port, port, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getOutboundSSLContext SSLContext:", (Object[])new Object[]{jdkContext});
            }
        }
        catch (Exception props) {
            FFDCFilter.processException((Throwable)props, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"112", (Object)this, (Object[])new Object[]{sslOptions, host, port});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getOutboundSSLContext exception caught creating SSLContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        try {
            JdkSslContext nettyContext = new JdkSslContext(jdkContext, true, null, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, null, ClientAuth.OPTIONAL, null, false);
            return nettyContext;
        }
        catch (Exception nettyContext) {
            FFDCFilter.processException((Throwable)nettyContext, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"123", (Object)this, (Object[])new Object[]{sslOptions, host, port});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getOutboundSSLContext exception caught creating JdkSslContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SslContext getInboundSSLContext(Map<String, Object> sslOptions, String host, String port) {
        SSLContext jdkContext;
        try {
            jdkContext = NettyTlsProviderImpl.getSSLContext(port, NettyTlsProviderImpl.createProps(sslOptions), true, host, port, port, false);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"144", (Object)this, (Object[])new Object[]{sslOptions, host, port});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getInboundSSLContext exception caught creating SSLContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getInboundSSLContext SSLContext: " + jdkContext), (Object[])new Object[0]);
        }
        try {
            JdkSslContext nettyContext = new JdkSslContext(jdkContext, false, null, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, null, ClientAuth.OPTIONAL, null, false);
            return nettyContext;
        }
        catch (Exception nettyContext) {
            FFDCFilter.processException((Throwable)nettyContext, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"157", (Object)this, (Object[])new Object[]{sslOptions, host, port});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                void e;
                Tr.warning((TraceComponent)tc, (String)("getInboundSSLContext exception caught creating JdkSslContext: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static SSLContext getSSLContext(String alias, Properties properties, boolean isInbound, String host, String port, String endPoint, Boolean isZWebContainerChain) throws Exception {
        String sslType;
        boolean useJSSEHelper;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("host=" + host + " port=" + port + " endPoint=" + endPoint), (Object[])new Object[0]);
        }
        String direction = isInbound ? "inbound" : "outbound";
        final HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("com.ibm.ssl.direction", direction);
        connectionInfo.put("com.ibm.ssl.remoteHost", host);
        connectionInfo.put("com.ibm.ssl.remotePort", port);
        connectionInfo.put("com.ibm.ssl.endPointName", endPoint);
        Properties props = null;
        boolean bl = useJSSEHelper = null != alias;
        if (!useJSSEHelper) {
            block25: {
                try {
                    props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                        static final long serialVersionUID = 5971460751150327018L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Properties run() throws Exception {
                            return JSSEHelper.getInstance().getSSLPropertiesOnThread();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl$1", 1.class, null, null);
                        }
                    });
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"208", null, (Object[])new Object[]{alias, properties, isInbound, host, port, endPoint, isZWebContainerChain});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block25;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception looking for on-thread props; e=" + e), (Object[])new Object[0]);
                }
            }
            if (null == props || 0 == props.size()) {
                props = null;
                useJSSEHelper = !properties.containsKey("com.ibm.ssl.keyStore") || !properties.containsKey("com.ibm.ssl.trustStore");
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found on-thread ssl properties", (Object[])new Object[0]);
            }
        }
        if (useJSSEHelper) {
            try {
                final String aliasFinal = alias;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Querying security service for alias=[" + aliasFinal + "]"), (Object[])new Object[0]);
                }
                props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                    static final long serialVersionUID = -1083402093114087687L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Properties run() throws Exception {
                        return JSSEHelper.getInstance().getProperties(aliasFinal, connectionInfo, null);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl$2", 2.class, null, null);
                    }
                });
            }
            catch (Exception aliasFinal) {
                void e;
                FFDCFilter.processException((Throwable)aliasFinal, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"242", null, (Object[])new Object[]{alias, properties, isInbound, host, port, endPoint, isZWebContainerChain});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception getting SSL properties from alias: " + alias), (Object[])new Object[0]);
                }
                throw e;
            }
        }
        if (null != props) {
            Enumeration<?> names = properties.propertyNames();
            String key = null;
            String value = null;
            while (names.hasMoreElements()) {
                key = (String)names.nextElement();
                value = properties.getProperty(key);
                if (!(value instanceof String) || null == value || props.containsKey(key)) continue;
                props.put(key, value);
            }
        } else {
            props = properties;
        }
        if (null != (sslType = (String)props.get("com.ibm.ssl.sslType"))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SSLConfig type: " + sslType), (Object[])new Object[0]);
            }
            if (sslType.equals("SSSL")) {
                throw new Exception("Invalid SSLConfig type: " + sslType);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SSL configuration <null value means non-string>:", (Object[])new Object[0]);
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = props.getProperty(key);
                if (-1 == key.toLowerCase().indexOf("password")) {
                    Tr.debug((TraceComponent)tc, (String)("\t" + key + " = " + value), (Object[])new Object[0]);
                    continue;
                }
                StringBuilder output = new StringBuilder(4 + key.length() + value.length());
                output.append("\t").append(key).append(" = ");
                for (int i = 0; i < value.length(); ++i) {
                    output.append("*");
                }
                Tr.debug((TraceComponent)tc, (String)output.toString(), (Object[])new Object[0]);
            }
        }
        SSLContext context = null;
        try {
            SSLConfig config = new SSLConfig(props);
            context = JSSEHelper.getInstance().getSSLContext(connectionInfo, (Properties)config);
        }
        catch (Exception config) {
            void e;
            FFDCFilter.processException((Throwable)config, (String)"io.openliberty.netty.internal.tls.impl.NettyTlsProviderImpl", (String)"308", null, (Object[])new Object[]{alias, properties, isInbound, host, port, endPoint, isZWebContainerChain});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLContext from properties.", (Object[])new Object[]{e});
            }
            throw e;
        }
        return context;
    }

    private static Properties createProps(Map<String, Object> map) {
        Properties properties = new Properties();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }
}

