/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.example;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.ObjectWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.util.StringUtil;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.examples.Example;

public class ExampleWriter {
    private ExampleWriter() {
    }

    public static void writeExamples(ObjectNode parent, Map<String, Example> examples) {
        if (examples == null) {
            return;
        }
        ObjectNode examplesNode = parent.putObject("examples");
        for (Map.Entry<String, Example> entry : examples.entrySet()) {
            ExampleWriter.writeExample(examplesNode, entry.getValue(), entry.getKey());
        }
    }

    private static void writeExample(ObjectNode parent, Example model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        if (StringUtil.isNotEmpty(model.getRef())) {
            JsonUtil.stringProperty(node, "$ref", model.getRef());
        } else {
            JsonUtil.stringProperty(node, "summary", model.getSummary());
            JsonUtil.stringProperty(node, "description", model.getDescription());
            ObjectWriter.writeObject(node, "value", model.getValue());
            JsonUtil.stringProperty(node, "externalValue", model.getExternalValue());
            ExtensionWriter.writeExtensions(node, model);
        }
    }
}

