/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.ContainerClassLoader;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.util.Keyed;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.classloader.NameBasedClassLoaderLock;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ShadowClassLoader
extends LibertyLoader
implements Keyed<ClassLoaderIdentity> {
    static final TraceComponent tc;
    private static final Enumeration<URL> EMPTY_ENUMERATION;
    private final AppClassLoader shadowedLoader;
    private final Iterable<LibertyLoader> beforeAppDelegateLoaders;
    private final Iterable<LibertyLoader> afterAppDelegateLoaders;
    static final long serialVersionUID = -2271406406203749086L;

    ShadowClassLoader(AppClassLoader shadowed) {
        super(ShadowClassLoader.getShadow(shadowed.parent));
        this.shadowedLoader = shadowed;
        this.beforeAppDelegateLoaders = ShadowClassLoader.getShadows(shadowed.getBeforeAppDelegateLoaders());
        this.afterAppDelegateLoaders = ShadowClassLoader.getShadows(shadowed.getAfterAppDelegateLoaders());
    }

    private static ClassLoader getShadow(ClassLoader loader) {
        return loader instanceof AppClassLoader ? new ShadowClassLoader((AppClassLoader)loader) : loader;
    }

    private static LibertyLoader getShadow(LibertyLoader loader) {
        return loader instanceof AppClassLoader ? new ShadowClassLoader((AppClassLoader)loader) : loader;
    }

    private static List<LibertyLoader> getShadows(Iterable<? extends LibertyLoader> loaders) {
        ArrayList<LibertyLoader> result = new ArrayList<LibertyLoader>();
        for (LibertyLoader libertyLoader : loaders) {
            result.add(ShadowClassLoader.getShadow(libertyLoader));
        }
        return result;
    }

    @Override
    protected final Class<?> loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        return this.loadClass(className, resolveClass, LibertyLoader.DelegatePolicy.includeParent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> loadClass(String className, boolean resolveClass, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        ClassNotFoundException lastException = null;
        NameBasedClassLoaderLock nameBasedClassLoaderLock = this.getClassLoadingLock(className);
        synchronized (nameBasedClassLoaderLock) {
            Class<?> result = this.findLoadedClass(className);
            if (result != null) {
                return result;
            }
            block11: for (AppClassLoader.SearchLocation what : this.shadowedLoader.getSearchOrder()) {
                try {
                    switch (what) {
                        case BEFORE_DELEGATES: {
                            result = this.loadFrom(true, className, returnNull);
                            if (result == null) continue block11;
                            return result;
                        }
                        case PARENT: {
                            if (delegatePolicy != LibertyLoader.DelegatePolicy.includeParent || (result = this.loadFromParent(className, returnNull)) == null) continue block11;
                            return result;
                        }
                        case SELF: {
                            result = this.findClass(className, delegatePolicy, returnNull);
                            if (result == null) continue block11;
                            return result;
                        }
                        case AFTER_DELEGATES: {
                            result = this.loadFrom(false, className, returnNull);
                            if (result == null) continue block11;
                            return result;
                        }
                        default: {
                            throw new IllegalStateException("Unknown class loader search ordering element: " + (Object)((Object)what));
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    lastException = e;
                }
            }
        }
        if (returnNull) {
            return null;
        }
        if (lastException == null) {
            lastException = new ClassNotFoundException(className);
        }
        throw lastException;
    }

    @Trivial
    private Class<?> loadFromParent(String className, boolean returnNull) throws ClassNotFoundException {
        if (this.parent instanceof LibertyLoader) {
            return ((LibertyLoader)this.parent).loadClass(className, false, LibertyLoader.DelegatePolicy.includeParent, returnNull);
        }
        return this.parent.loadClass(className);
    }

    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    private Class<?> loadFrom(boolean beforeApp, String className, boolean returnNull) throws ClassNotFoundException {
        ClassNotFoundException lastException = null;
        LibertyLoader.DelegatePolicy delegatePolicy = beforeApp || this.shadowedLoader.isParentFirst() ? LibertyLoader.DelegatePolicy.excludeParent : LibertyLoader.DelegatePolicy.checkParent;
        Iterable<LibertyLoader> delegates = beforeApp ? this.beforeAppDelegateLoaders : this.afterAppDelegateLoaders;
        for (LibertyLoader delegate : delegates) {
            try {
                Class<?> result = delegate.loadClass(className, false, delegatePolicy, returnNull);
                if (result == null) continue;
                return result;
            }
            catch (ClassNotFoundException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return null;
    }

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findClass(String name, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        String packageName;
        int lastDotIndex;
        String resourceName = Util.convertClassNameToResourceName(name);
        ContainerClassLoader.ByteResourceInformation classBytesResourceInformation = this.shadowedLoader.findClassBytes(name, resourceName);
        if (classBytesResourceInformation == null) {
            if (returnNull) {
                return null;
            }
            throw new ClassNotFoundException(name);
        }
        if (delegatePolicy == LibertyLoader.DelegatePolicy.checkParent) {
            try {
                Class<?> checkParentResult = this.loadFromParent(name, returnNull);
                if (checkParentResult != null) {
                    return checkParentResult;
                }
            }
            catch (ClassNotFoundException checkParentResult) {
                // empty catch block
            }
        }
        if ((lastDotIndex = name.lastIndexOf(46)) != -1 && this.getPackage(packageName = name.substring(0, lastDotIndex)) == null) {
            classBytesResourceInformation.definePackage(packageName, this);
        }
        byte[] bytes = classBytesResourceInformation.getBytes();
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    @Override
    public URL getResource(String name) {
        return name == null ? null : this.shadowedLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return name == null ? null : this.shadowedLoader.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return name == null ? EMPTY_ENUMERATION : this.shadowedLoader.getResources(name);
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        return this.shadowedLoader.getApiTypeVisibility();
    }

    @Override
    public ClassLoaderIdentity getKey() {
        return this.shadowedLoader.getKey();
    }

    @Override
    public Bundle getBundle() {
        return this.shadowedLoader.getBundle();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        tc = Tr.register(ShadowClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        EMPTY_ENUMERATION = new Enumeration<URL>(){
            static final long serialVersionUID = 6781143533374470504L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public URL nextElement() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ShadowClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }
}

