/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.ClassLoadingConstants;
import com.ibm.ws.classloading.internal.ContainerClassLoader;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.NoClassNotFoundLoader;
import com.ibm.ws.classloading.internal.ShadowClassLoader;
import com.ibm.ws.classloading.internal.SpringLoader;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.providers.Providers;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.classloading.internal.util.FeatureSuggestion;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.classloader.NameBasedClassLoaderLock;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AppClassLoader
extends ContainerClassLoader
implements SpringLoader {
    static final TraceComponent tc = Tr.register(AppClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private static final AtomicBoolean issuedOverrideBetaMessage = new AtomicBoolean(false);
    private static final Set<String> forbiddenClassNames = Collections.unmodifiableSet(AppClassLoader.loadForbidden());
    private static final String FORBIDDEN_PROPERTIES = "forbidden.properties";
    public static final String NOTHING_FORBIDDEN_PROPERTY = "io.openliberty.classloading.nothing.forbidden";
    private static final PermissionCollection ALLPERMISSIONS;
    static final List<SearchLocation> PARENT_FIRST_SEARCH_ORDER;
    private final Set<String> packagesDefined = Collections.newSetFromMap(new ConcurrentHashMap());
    static final String CLASS_LOADING_TRACE_PREFIX = "com.ibm.ws.class.load.";
    static final String DEFAULT_PACKAGE = "default.package";
    final ConcurrentMap<String, TraceComponent> perPackageClassLoadingTraceComponents = new ConcurrentHashMap<String, TraceComponent>();
    protected final ClassLoaderConfiguration config;
    private final AtomicReference<List<Library>> overrideLibraries;
    private final AtomicReference<List<Library>> privateLibraries;
    private final Iterable<LibertyLoader> beforeAppDelegateLoaders;
    private final Iterable<LibertyLoader> afterAppDelegateLoaders;
    private final List<File> nativeLibraryFiles = new ArrayList<File>();
    private final List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();
    private final List<ClassFileTransformer> systemTransformers;
    private final DeclaredApiAccess apiAccess;
    private final ClassGenerator generator;
    private final ConcurrentHashMap<String, ProtectionDomain> protectionDomains = new ConcurrentHashMap();
    private final GlobalClassloadingConfiguration.LibraryPrecedence libraryPrecedence;
    static final long serialVersionUID = -2662042672468425614L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> loadForbidden() {
        HashSet<String> forbidden;
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Loading forbidden.properties", (Object[])new Object[0]);
            }
            if (Boolean.getBoolean(NOTHING_FORBIDDEN_PROPERTY)) {
                return Collections.emptySet();
            }
            forbidden = new HashSet<String>();
            try {
                InputStream inputStream = AppClassLoader.class.getResourceAsStream(FORBIDDEN_PROPERTIES);
                try {
                    Properties props = new Properties();
                    props.load(inputStream);
                    Properties castProps = props;
                    forbidden.addAll(castProps.keySet());
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"117", null, (Object[])new Object[0]);
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"117", null, (Object[])new Object[0]);
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"123", null, (Object[])new Object[0]);
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return forbidden;
        if (!tc.isDebugEnabled()) return forbidden;
        Tr.debug((TraceComponent)tc, (String)("Loaded Forbidden Set" + forbidden), (Object[])new Object[0]);
        return forbidden;
    }

    private TraceComponent getClassLoadingTraceComponent(String pkg) {
        TraceComponent tc = (TraceComponent)this.perPackageClassLoadingTraceComponents.get(pkg);
        if (tc == null) {
            tc = Tr.register((String)(CLASS_LOADING_TRACE_PREFIX + pkg), AppClassLoader.class, (String)null);
            this.perPackageClassLoadingTraceComponents.put(pkg, tc);
        }
        return tc;
    }

    AppClassLoader(ClassLoader parent, ClassLoaderConfiguration config, List<Container> containers, DeclaredApiAccess access, ClassRedefiner redefiner, ClassGenerator generator, GlobalClassloadingConfiguration globalConfig, List<ClassFileTransformer> systemTransformers) {
        super(containers, parent, redefiner, globalConfig);
        this.libraryPrecedence = globalConfig.libraryPrecedence();
        this.systemTransformers = systemTransformers;
        this.config = config;
        this.apiAccess = access;
        for (Container container : config.getNativeLibraryContainers()) {
            this.addNativeLibraryContainer(container);
        }
        List<Library> foundOverrideLibraries = Providers.getOverrideLibraries(config);
        if (foundOverrideLibraries != null && !foundOverrideLibraries.isEmpty()) {
            if (!ProductInfo.getBetaEdition()) {
                foundOverrideLibraries = Collections.emptyList();
                if (issuedOverrideBetaMessage.compareAndSet(false, true)) {
                    Tr.info((TraceComponent)tc, (String)"BETA: Override libraries can only be used with the Open Liberty BETA.", (Object[])new Object[0]);
                }
            } else if (issuedOverrideBetaMessage.compareAndSet(false, true)) {
                Tr.info((TraceComponent)tc, (String)"BETA: Override libraries are being used.", (Object[])new Object[0]);
            }
        }
        this.overrideLibraries = new AtomicReference<List<Library>>(foundOverrideLibraries);
        this.privateLibraries = new AtomicReference<List<Library>>(Providers.getPrivateLibraries(config));
        ArrayList<LibertyLoader> tmpBeforeApp = new ArrayList<LibertyLoader>();
        ArrayList<LibertyLoader> tmpAfterApp = new ArrayList<LibertyLoader>();
        for (Providers.LoaderInfo loaderInfo : Providers.getDelegateLoaders(config, this.apiAccess, this.libraryPrecedence)) {
            switch (loaderInfo.precedence) {
                case afterApp: {
                    tmpAfterApp.add(loaderInfo.loader);
                    break;
                }
                case beforeApp: {
                    tmpBeforeApp.add(loaderInfo.loader);
                    break;
                }
            }
        }
        this.beforeAppDelegateLoaders = tmpBeforeApp.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(tmpBeforeApp);
        this.afterAppDelegateLoaders = tmpAfterApp.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(tmpAfterApp);
        this.generator = generator;
    }

    Iterable<LibertyLoader> getBeforeAppDelegateLoaders() {
        return this.beforeAppDelegateLoaders;
    }

    Iterable<LibertyLoader> getAfterAppDelegateLoaders() {
        return this.afterAppDelegateLoaders;
    }

    Iterable<SearchLocation> getSearchOrder() {
        return PARENT_FIRST_SEARCH_ORDER;
    }

    @Override
    public boolean addTransformer(ClassFileTransformer cft) {
        this.transformers.add(cft);
        if (this.parent instanceof AppClassLoader) {
            if (Util.isGlobalSharedLibraryLoader((AppClassLoader)this.parent)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"addTransformer - skipping parent loader because it is a GlobalSharedLibrary", (Object[])new Object[0]);
                }
            } else {
                return ((AppClassLoader)this.parent).addTransformer(cft);
            }
        }
        return true;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new ShadowClassLoader(this);
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        return this.apiAccess.getApiTypeVisibility();
    }

    @Override
    public URL getResource(String name) {
        URL result = this.findResourceCommonLibraryClassLoaders(name, GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp);
        if (result == null) {
            result = this.parent.getResource(name);
        }
        if (result == null) {
            result = this.findResource(name);
        }
        return result;
    }

    @Override
    @Trivial
    public final URL findResource(String name) {
        return this.findResourceInternal(name, false);
    }

    @Override
    @Trivial
    protected URL delegateFindResource(String name) {
        return this.findResourceInternal(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findResourceInternal(String name, boolean delegate) {
        URL result = null;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            if (delegate) {
                result = this.findResourceCommonLibraryClassLoaders(name, GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp);
            }
            if (result == null) {
                result = super.findResource(name);
            }
            if (result == null) {
                result = this.findResourceCommonLibraryClassLoaders(name, GlobalClassloadingConfiguration.LibraryPrecedence.afterApp);
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return result;
    }

    @Override
    @Trivial
    public CompositeEnumeration<URL> findResources(String name) throws IOException {
        return this.findResourcesInternal(name, false);
    }

    @Override
    protected Enumeration<URL> delegateFindResources(String name) throws IOException {
        return this.findResourcesInternal(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private CompositeEnumeration<URL> findResourcesInternal(String name, boolean delegate) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            CompositeEnumeration enumerations = new CompositeEnumeration();
            if (delegate) {
                this.findResourcesCommonLibraryClassLoaders(name, (CompositeEnumeration<URL>)enumerations, GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp);
            }
            enumerations.add(super.findResources(name));
            CompositeEnumeration<URL> compositeEnumeration = this.findResourcesCommonLibraryClassLoaders(name, (CompositeEnumeration<URL>)enumerations, GlobalClassloadingConfiguration.LibraryPrecedence.afterApp);
            return compositeEnumeration;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @Override
    @Trivial
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResourcesCommonLibraryClassLoaders(name, (CompositeEnumeration<URL>)new CompositeEnumeration(), GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp).add(this.parent.getResources(name)).add(this.findResources(name));
    }

    @Override
    public Bundle getBundle() {
        return this.parent instanceof GatewayClassLoader ? ((GatewayClassLoader)this.parent).getBundle() : (this.parent instanceof LibertyLoader ? ((LibertyLoader)this.parent).getBundle() : null);
    }

    boolean removeTransformer(ClassFileTransformer transformer) {
        if (this.parent instanceof AppClassLoader) {
            ((AppClassLoader)this.parent).removeTransformer(transformer);
        }
        return this.transformers.remove(transformer);
    }

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected final Class<?> findClass(String name, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        String resourceName = Util.convertClassNameToResourceName(name);
        ContainerClassLoader.ByteResourceInformation byteResInfo = this.findClassBytes(name, resourceName);
        if (byteResInfo == null) {
            return this.findClassCommonLibraryClassLoaders(name, returnNull, GlobalClassloadingConfiguration.LibraryPrecedence.afterApp);
        }
        if (delegatePolicy == LibertyLoader.DelegatePolicy.checkParent) {
            Class<?> checkParentResult = null;
            if (this.parent instanceof NoClassNotFoundLoader) {
                checkParentResult = ((NoClassNotFoundLoader)((Object)this.parent)).loadClassNoException(name);
            } else {
                try {
                    checkParentResult = this.parent.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (checkParentResult != null) {
                return checkParentResult;
            }
        }
        byte[] bytes = this.transformers.isEmpty() && this.systemTransformers.isEmpty() ? byteResInfo.getBytes() : this.transformClassBytes(name, byteResInfo);
        return this.definePackageAndClass(name, resourceName, byteResInfo, bytes);
    }

    byte[] transformClassBytes(String name, ContainerClassLoader.ByteResourceInformation toTransform) throws ClassNotFoundException {
        byte[] originalBytes;
        boolean fromSCC = toTransform.foundInClassCache();
        if (!fromSCC) {
            originalBytes = toTransform.getBytes();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to transform \" + name + \" found in shared class cache because we have " + (!this.transformers.isEmpty() ? "[transformers]" : "") + (!this.systemTransformers.isEmpty() ? "[system transformers]" : "")), (Object[])new Object[0]);
            }
            try {
                originalBytes = toTransform.getActualBytes();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"443", (Object)this, (Object[])new Object[]{name, toTransform});
                return toTransform.getBytes();
            }
        }
        byte[] bytes = this.transformClassBytes(originalBytes, name, this.transformers);
        bytes = this.transformClassBytes(bytes, name, this.systemTransformers);
        if (fromSCC && (bytes == originalBytes || Arrays.equals(bytes, originalBytes))) {
            bytes = toTransform.getBytes();
        }
        return bytes;
    }

    private byte[] transformClassBytes(byte[] originalBytes, String name, List<ClassFileTransformer> cfts) throws ClassNotFoundException {
        byte[] bytes = originalBytes;
        for (ClassFileTransformer transformer : cfts) {
            bytes = this.doTransformation(name, bytes, transformer);
        }
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] doTransformation(String name, byte[] bytes, ClassFileTransformer transformer) throws ClassNotFoundException {
        try {
            byte[] newBytes = transformer.transform(this, name, null, this.config.getProtectionDomain(), bytes);
            if (newBytes != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (bytes == newBytes) {
                        Tr.debug((TraceComponent)tc, (String)("transformer " + transformer + " was invoked but returned an unaltered byte array"), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("transformer " + transformer + " successfully transformed the class bytes"), (Object[])new Object[0]);
                    }
                }
                bytes = newBytes;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("transformer " + transformer + " was invoked but did not alter the loaded bytes"), (Object[])new Object[0]);
            }
        }
        catch (IllegalClassFormatException newBytes) {
            void ex;
            FFDCFilter.processException((Throwable)newBytes, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"483", (Object)this, (Object[])new Object[]{name, bytes, transformer});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bad transform - transformer: " + transformer + " attempting to transform class: " + name), (Object[])new Object[]{ex});
            }
            throw new ClassNotFoundException(name, (Throwable)ex);
        }
        return bytes;
    }

    private ProtectionDomain setPermissionCollectionIfNeeded(final ProtectionDomain pd) {
        PermissionCollection pc = null;
        if (pd.getPermissions() == null) {
            if (System.getSecurityManager() == null) {
                pc = ALLPERMISSIONS;
            } else {
                try {
                    pc = AccessController.doPrivileged(new PrivilegedExceptionAction<PermissionCollection>(){
                        static final long serialVersionUID = 3909734018855976071L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public PermissionCollection run() {
                            Policy p = Policy.getPolicy();
                            PermissionCollection fpc = p.getPermissions(pd.getCodeSource());
                            return fpc;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"513", (Object)this, (Object[])new Object[]{pd});
                }
            }
        }
        return pc == null ? pd : new ProtectionDomain(pd.getCodeSource(), pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> definePackageAndClass(String name, String resourceName, ContainerClassLoader.ByteResourceInformation byteResourceInformation, byte[] bytes) throws ClassFormatError {
        TraceComponent cltc;
        int lastDotIndex = name.lastIndexOf(46);
        String packageName = DEFAULT_PACKAGE;
        if (lastDotIndex != -1) {
            packageName = name.substring(0, lastDotIndex);
            this.definePackage(byteResourceInformation, packageName);
        }
        ProtectionDomain pd = this.getClassSpecificProtectionDomain(byteResourceInformation.getContainerURL());
        pd = this.setPermissionCollectionIfNeeded(pd);
        Class<?> clazz = null;
        try {
            clazz = this.defineClass(name, bytes, 0, bytes.length, pd);
        }
        catch (Throwable throwable) {
            TraceComponent cltc2;
            if (TraceComponent.isAnyTracingEnabled() && (cltc2 = this.getClassLoadingTraceComponent(packageName)).isDebugEnabled()) {
                String loc = byteResourceInformation.getContainerURL().toString();
                String message = clazz == null ? "CLASS FAIL" : "CLASS LOAD";
                Tr.debug((TraceComponent)cltc2, (String)String.format("%s: [%s] [%s] [%s]", message, this.getKey(), loc, name), (Object[])new Object[0]);
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && (cltc = this.getClassLoadingTraceComponent(packageName)).isDebugEnabled()) {
            String loc = byteResourceInformation.getContainerURL().toString();
            String message = clazz == null ? "CLASS FAIL" : "CLASS LOAD";
            Tr.debug((TraceComponent)cltc, (String)String.format("%s: [%s] [%s] [%s]", message, this.getKey(), loc, name), (Object[])new Object[0]);
        }
        byteResourceInformation.storeInClassCache(clazz, bytes);
        return clazz;
    }

    @Trivial
    private ProtectionDomain getClassSpecificProtectionDomain(final ContainerClassLoader.ContainerURL containerUrl) {
        if (containerUrl == null) {
            return this.config.getProtectionDomain();
        }
        ProtectionDomain pd = null;
        try {
            pd = AccessController.doPrivileged(new PrivilegedExceptionAction<ProtectionDomain>(){
                static final long serialVersionUID = 2685128114983663922L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ProtectionDomain run() {
                    return AppClassLoader.this.getClassSpecificProtectionDomainPrivileged(containerUrl);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$2", 2.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"561", (Object)this, (Object[])new Object[]{containerUrl});
            pd = this.config.getProtectionDomain();
        }
        return pd;
    }

    ProtectionDomain getClassSpecificProtectionDomainPrivileged(ContainerClassLoader.ContainerURL containerUrl) {
        return this.protectionDomains.computeIfAbsent(containerUrl.urlString, c -> {
            ProtectionDomain pdFromConfig = this.config.getProtectionDomain();
            CodeSource cs = new CodeSource(containerUrl.url, pdFromConfig.getCodeSource().getCertificates());
            return new ProtectionDomain(cs, pdFromConfig.getPermissions());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void definePackage(ContainerClassLoader.ByteResourceInformation byteResourceInformation, String packageName) {
        if (!this.packagesDefined.contains(packageName)) {
            NameBasedClassLoaderLock nameBasedClassLoaderLock = this.getClassLoadingLock(packageName);
            synchronized (nameBasedClassLoaderLock) {
                if (!this.packagesDefined.contains(packageName)) {
                    byteResourceInformation.definePackage(packageName, this);
                    this.packagesDefined.add(packageName);
                }
            }
        }
    }

    @Override
    @Trivial
    protected final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, LibertyLoader.DelegatePolicy.includeParent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected final Class<?> loadClass(String name, boolean resolve, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        ClassNotFoundException toThrow;
        if (forbiddenClassNames.contains(name)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loadClass " + name + " forbidden"), (Object[])new Object[0]);
            }
            if (returnNull) {
                return null;
            }
            throw new ClassNotFoundException(name);
        }
        ClassNotFoundException cnfe = null;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            Class<?> result = this.findOrDelegateLoadClass(name, delegatePolicy, returnNull);
            if (result != null) {
                Class<?> clazz = result;
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            cnfe = e;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        ClassNotFoundException classNotFoundException = toThrow = delegatePolicy == LibertyLoader.DelegatePolicy.includeParent ? FeatureSuggestion.getExceptionWithSuggestion(cnfe, name, returnNull) : cnfe;
        if (returnNull) {
            return null;
        }
        throw toThrow;
    }

    @Trivial
    Class<?> generateClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        Class<?> generatedClass = null;
        if (this.generator != null && (bytes = this.generator.generateClass(name, this)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("defining generated class " + name), (Object[])new Object[0]);
            }
            String remoteInterfaceClassName = null;
            ProtectionDomain pd = null;
            if (name != null && name.endsWith("_Stub") && !name.endsWith("._Stub")) {
                StringBuilder nameBuilder = new StringBuilder(name);
                nameBuilder.setLength(nameBuilder.length() - 5);
                int packageOffset = nameBuilder.lastIndexOf(".") + 1;
                if (nameBuilder.charAt(packageOffset) == '_') {
                    nameBuilder.deleteCharAt(packageOffset);
                }
                remoteInterfaceClassName = nameBuilder.toString();
                try {
                    final Class<?> remoteClass = super.loadClass(remoteInterfaceClassName, false);
                    pd = AccessController.doPrivileged(new PrivilegedExceptionAction<ProtectionDomain>(){
                        static final long serialVersionUID = -3148758349673546360L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public ProtectionDomain run() {
                            return remoteClass.getProtectionDomain();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$3", 3.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.classloading.internal.AppClassLoader", (String)"692", (Object)this, (Object[])new Object[]{name});
                }
                pd = this.setPermissionCollectionIfNeeded(pd);
                generatedClass = this.defineClass(name, bytes, 0, bytes.length, pd);
            } else {
                generatedClass = this.defineClass(name, bytes, 0, bytes.length, this.config.getProtectionDomain());
            }
        }
        return generatedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findOrDelegateLoadClass(String name, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        boolean RETURN_NULL_FOR_NO_CLASS = true;
        Class<?> beforeAppLoad = this.findClassCommonLibraryClassLoaders(name, true, GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp);
        if (beforeAppLoad != null) {
            return beforeAppLoad;
        }
        if (this.parent == null) {
            return super.loadClass(name, false);
        }
        Class<?> result = null;
        ClassNotFoundException findException = null;
        NameBasedClassLoaderLock nameBasedClassLoaderLock = this.getClassLoadingLock(name);
        synchronized (nameBasedClassLoaderLock) {
            result = this.findLoadedClass(name);
            if (result == null) {
                if (delegatePolicy == LibertyLoader.DelegatePolicy.includeParent) {
                    if (this.parent instanceof NoClassNotFoundLoader) {
                        result = ((NoClassNotFoundLoader)((Object)this.parent)).loadClassNoException(name);
                    } else {
                        try {
                            result = this.parent.loadClass(name);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (result == null) {
                    try {
                        result = this.findClass(name, delegatePolicy, returnNull);
                    }
                    catch (ClassNotFoundException cnfe) {
                        findException = cnfe;
                    }
                    if (result == null) {
                        result = this.generateClass(name);
                    }
                }
            }
        }
        if (result != null || returnNull) {
            return result;
        }
        throw findException;
    }

    @Trivial
    private Iterable<LibertyLoader> getDelegates(GlobalClassloadingConfiguration.LibraryPrecedence precedence) {
        if (precedence == GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp) {
            return this.beforeAppDelegateLoaders;
        }
        return this.afterAppDelegateLoaders;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findClassCommonLibraryClassLoaders(String name, boolean returnNull, GlobalClassloadingConfiguration.LibraryPrecedence precedence) throws ClassNotFoundException {
        LibertyLoader.DelegatePolicy delegatePolicy = precedence == GlobalClassloadingConfiguration.LibraryPrecedence.beforeApp || this.isParentFirst() ? LibertyLoader.DelegatePolicy.excludeParent : LibertyLoader.DelegatePolicy.checkParent;
        for (LibertyLoader cl : this.getDelegates(precedence)) {
            try {
                Class<?> rc = cl.loadClass(name, false, delegatePolicy, true);
                if (rc == null) continue;
                return rc;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (returnNull) {
            return null;
        }
        throw new ClassNotFoundException(name);
    }

    @Trivial
    protected boolean isParentFirst() {
        return true;
    }

    protected URL findResourceCommonLibraryClassLoaders(String name, GlobalClassloadingConfiguration.LibraryPrecedence precedence) {
        for (LibertyLoader cl : this.getDelegates(precedence)) {
            URL url = cl.delegateFindResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    protected CompositeEnumeration<URL> findResourcesCommonLibraryClassLoaders(String name, CompositeEnumeration<URL> enumerations, GlobalClassloadingConfiguration.LibraryPrecedence precedence) throws IOException {
        for (LibertyLoader cl : this.getDelegates(precedence)) {
            enumerations.add(cl.delegateFindResources(name));
        }
        return enumerations;
    }

    @Override
    protected void lazyInit() {
        List curPrivateLibraries;
        List curOverrideLibraries = this.overrideLibraries.getAndSet(null);
        if (curOverrideLibraries != null) {
            for (Library lib : curOverrideLibraries) {
                this.copyLibraryElementsToClasspath(lib, true);
            }
        }
        if ((curPrivateLibraries = (List)this.privateLibraries.getAndSet(null)) != null) {
            for (Library lib : curPrivateLibraries) {
                this.copyLibraryElementsToClasspath(lib, false);
            }
        }
    }

    private void copyLibraryElementsToClasspath(Library library, boolean prepend) {
        Collection<File> files = library.getFiles();
        this.addToClassPath(library.getContainers(), prepend);
        if (files != null && !files.isEmpty()) {
            for (File file : files) {
                this.nativeLibraryFiles.add(file);
            }
        }
        for (Fileset fileset : library.getFilesets()) {
            for (File file : fileset.getFileset()) {
                this.nativeLibraryFiles.add(file);
            }
        }
    }

    private static boolean isWindows(String basename) {
        return basename.endsWith(".dll") || basename.endsWith(".DLL");
    }

    private static boolean checkLib(final File f, String basename) {
        boolean fExists = System.getSecurityManager() == null ? f.exists() : AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 8191871100894090428L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return f.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.AppClassLoader$4", 4.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        }).booleanValue();
        return fExists && (f.getName().equals(basename) || AppClassLoader.isWindows(basename) && f.getName().equalsIgnoreCase(basename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String findLibrary(String libname) {
        if (libname == null || libname.length() == 0) {
            return null;
        }
        String path = super.findLibrary(libname);
        if (path != null) {
            return path;
        }
        Object token = ThreadIdentityManager.runAsServer();
        try {
            String psLibname = System.mapLibraryName(libname);
            for (File f : this.nativeLibraryFiles) {
                if (!AppClassLoader.checkLib(f, psLibname)) continue;
                String string = f.getAbsolutePath();
                return string;
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return null;
    }

    @Override
    public ClassLoaderIdentity getKey() {
        return this.config.getId();
    }

    public String toDiagString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.config).append(ClassLoadingConstants.LS);
        sb.append("    API Visibility: ");
        for (ApiType apiType : this.apiAccess.getApiTypeVisibility()) {
            sb.append((Object)apiType).append(" ");
        }
        sb.append(ClassLoadingConstants.LS);
        sb.append("    ClassPath: ").append(ClassLoadingConstants.LS);
        for (Collection collection : this.getClassPath()) {
            sb.append("      * ");
            for (URL url : collection) {
                sb.append(url.toString()).append(" | ");
            }
            sb.append(ClassLoadingConstants.LS);
        }
        sb.append(ClassLoadingConstants.LS);
        sb.append("    CodeSources: ");
        for (Map.Entry entry : this.protectionDomains.entrySet()) {
            sb.append(ClassLoadingConstants.LS).append("      ").append((String)entry.getKey()).append(" = ").append(((ProtectionDomain)entry.getValue()).getCodeSource().getLocation());
        }
        sb.append(ClassLoadingConstants.LS);
        return sb.toString();
    }

    @Override
    public Class<?> publicDefineClass(String name, byte[] b, ProtectionDomain protectionDomain) {
        return this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        AllPermission allPerm = new AllPermission();
        ALLPERMISSIONS = allPerm.newPermissionCollection();
        if (ALLPERMISSIONS != null) {
            ALLPERMISSIONS.add(allPerm);
        }
        PARENT_FIRST_SEARCH_ORDER = Util.freeze(Util.list(SearchLocation.BEFORE_DELEGATES, SearchLocation.PARENT, SearchLocation.SELF, SearchLocation.AFTER_DELEGATES));
    }

    static enum SearchLocation {
        BEFORE_DELEGATES,
        PARENT,
        SELF,
        AFTER_DELEGATES;

    }
}

