/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.collaborator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.collaborator.WebAppSecurityCollaborator;
import com.ibm.ws.webcontainer.collaborator.WebAppTransactionCollaborator;
import com.ibm.ws.webcontainer.osgi.collaborator.CollaboratorServiceImpl;
import com.ibm.ws.webcontainer.osgi.collaborator.WebAppNameSpaceCollaboratorImpl;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInvocationCollaborator;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorInvocationEnum;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorMetaData;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppTransactionCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInvocationCollaborator;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.security.SecurityViolationException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CollaboratorHelperImpl
extends CollaboratorHelper {
    private static final String CLASS_NAME = CollaboratorHelperImpl.class.getName();
    private Set<WebAppInvocationCollaborator> webAppInvCollabs;
    private String securityDomainForApp = null;
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.collaborator");
    private static final WebAppSecurityCollaborator staticDefaultSecurityCollaborator = new WebAppSecurityCollaborator();
    private static final WebAppTransactionCollaborator staticDefaultWebAppTransactionCollaborator = new WebAppTransactionCollaborator();

    public CollaboratorHelperImpl(WebApp webApp, DeployedModule deployedMod) {
        super(webApp);
        if (webApp != null) {
            this.nameSpaceCollaborator = new WebAppNameSpaceCollaboratorImpl();
            this.transactionCollaborator = CollaboratorServiceImpl.getWebAppTransactionCollaborator();
            Dictionary<String, String> headers = ((WebAppConfiguration)webApp.getConfiguration()).getBundleHeaders();
            if (headers != null) {
                this.securityDomainForApp = headers.get("IBM-Authorization-Roles");
            }
            this.connectionCollaborator = CollaboratorServiceImpl.getWebAppConnectionCollaborator();
            this.webAppInvCollabs = CollaboratorServiceImpl.getWebAppInvocationCollaborators();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "constructor ", " webApp [" + webApp + "] , deployedMod [" + deployedMod + "] webAppInvCollabs [" + this.webAppInvCollabs + "] connectionCollaborator [" + this.connectionCollaborator + "]");
        }
    }

    @Override
    public IWebAppSecurityCollaborator getSecurityCollaborator() {
        IWebAppSecurityCollaborator service = CollaboratorServiceImpl.getWebAppSecurityCollaborator(this.securityDomainForApp);
        if (service != null) {
            this.securityCollaborator = service;
            return this.securityCollaborator;
        }
        this.securityCollaborator = staticDefaultSecurityCollaborator;
        return this.securityCollaborator;
    }

    @Override
    public IWebAppTransactionCollaborator getWebAppTransactionCollaborator() {
        IWebAppTransactionCollaborator service = CollaboratorServiceImpl.getWebAppTransactionCollaborator();
        this.transactionCollaborator = service != null ? service : staticDefaultWebAppTransactionCollaborator;
        return this.transactionCollaborator;
    }

    @Override
    public void doInvocationCollaboratorsPreInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd, ServletRequest request, ServletResponse response) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "doInvocationCollaboratorsPreInvoke(webAppInv,cmd, req, resp)");
        }
        if (this.webAppInvCollabs != null && !this.webAppInvCollabs.isEmpty()) {
            for (WebAppInvocationCollaborator inv : this.webAppInvCollabs) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "doInvocationCollaboratorsPreInvoke", " preInvoke WebAppInvocationCollaborator [" + inv + "]");
                }
                inv.preInvoke(cmd, request, response);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "doInvocationCollaboratorsPreInvoke(webAppInv,cmd, req, resp)");
        }
    }

    @Override
    public void doInvocationCollaboratorsPostInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd, ServletRequest request, ServletResponse response) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "doInvocationCollaboratorsPostInvoke(webAppInv,cmd, req, resp)");
        }
        if (this.webAppInvCollabs != null && !this.webAppInvCollabs.isEmpty()) {
            for (WebAppInvocationCollaborator inv : this.webAppInvCollabs) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "doInvocationCollaboratorsPostInvoke", " postInvoke WebAppInvocationCollaborator [" + inv + "]");
                }
                inv.postInvoke(cmd, request, response);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "doInvocationCollaboratorsPostInvoke(webAppInv,cmd, req, resp)");
        }
    }

    @Override
    public void doInvocationCollaboratorsPreInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "doInvocationCollaboratorsPreInvoke(webAppInv,cmd)");
        }
        if (this.webAppInvCollabs != null && !this.webAppInvCollabs.isEmpty()) {
            for (WebAppInvocationCollaborator inv : this.webAppInvCollabs) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "doInvocationCollaboratorsPreInvoke", " preInvoke WebAppInvocationCollaborator [" + inv + "]");
                }
                inv.preInvoke(cmd);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "doInvocationCollaboratorsPreInvoke(webAppInv,cmd)");
        }
    }

    @Override
    public void doInvocationCollaboratorsPostInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "doInvocationCollaboratorsPostInvoke(webAppInv,cmd)");
        }
        if (this.webAppInvCollabs != null && !this.webAppInvCollabs.isEmpty()) {
            for (WebAppInvocationCollaborator inv : this.webAppInvCollabs) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "doInvocationCollaboratorsPostInvoke", " postInvoke WebAppInvocationCollaborator [" + inv + "]");
                }
                inv.postInvoke(cmd);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "doInvocationCollaboratorsPostInvoke(webAppInv,cmd)");
        }
    }

    @Override
    protected void checkTransaction(Object tx1) {
    }

    @Override
    protected void checkForRollback() {
    }

    @Override
    protected Object getTransaction() throws Exception {
        return null;
    }

    @Override
    public Object processSecurityPreInvokeException(SecurityViolationException sve, RequestProcessor requestProcessor, HttpServletRequest request, HttpServletResponse response, WebAppDispatcherContext dispatchContext, WebApp context, String name) throws ServletErrorReport {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "processSecurityPreInvokeException");
        }
        Object secObject = null;
        secObject = sve.getWebSecurityContext();
        int sc = sve.getStatusCode();
        Throwable cause = sve.getCause();
        if (sc == 403) {
            if (context.isErrorPageDefined(sc)) {
                WebAppErrorReport wErrorReport = new WebAppErrorReport(cause);
                wErrorReport.setErrorCode(sc);
                context.sendError(request, response, wErrorReport);
            } else {
                try {
                    this.securityCollaborator.handleException(request, response, cause);
                }
                catch (Exception ex) {
                    if (requestProcessor != null) {
                        throw WebAppErrorReport.constructErrorReport((Throwable)ex, requestProcessor);
                    }
                    throw WebAppErrorReport.constructErrorReport((Throwable)ex, name);
                }
            }
        } else if (sc == 401) {
            try {
                this.securityCollaborator.handleException(request, response, cause);
            }
            catch (Exception ex) {
                if (requestProcessor != null) {
                    throw WebAppErrorReport.constructErrorReport((Throwable)ex, requestProcessor);
                }
                throw WebAppErrorReport.constructErrorReport((Throwable)ex, name);
            }
            if (context.isErrorPageDefined(sc)) {
                WebAppErrorReport wErrorReport = new WebAppErrorReport(cause);
                wErrorReport.setErrorCode(sc);
                context.sendError(request, response, wErrorReport);
            }
        } else {
            try {
                this.securityCollaborator.handleException(request, response, cause);
            }
            catch (Exception ex) {
                if (requestProcessor != null) {
                    throw WebAppErrorReport.constructErrorReport((Throwable)ex, requestProcessor);
                }
                throw WebAppErrorReport.constructErrorReport((Throwable)ex, name);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "processSecurityPreInvokeException");
        }
        return secObject;
    }

    @Override
    public void preInvokeCollaborators(ICollaboratorMetaData collabMetaData, EnumSet<CollaboratorInvocationEnum> colEnum) throws ServletException, IOException, Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "preInvokeCollaborators", " ");
        }
        this.getSecurityCollaborator();
        this.getWebAppTransactionCollaborator();
        super.preInvokeCollaborators(collabMetaData, colEnum);
    }

    @Override
    public void postInvokeCollaborators(ICollaboratorMetaData collabMetaData, EnumSet<CollaboratorInvocationEnum> colEnum) throws ServletException, IOException, Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "postInvokeCollaborators", " ");
        }
        this.getSecurityCollaborator();
        this.getWebAppTransactionCollaborator();
        super.postInvokeCollaborators(collabMetaData, colEnum);
    }

    @FFDCIgnore(value={ClassCastException.class})
    public static IWebAppSecurityCollaborator getCurrentSecurityCollaborator(ServletContext sc) {
        IWebAppSecurityCollaborator secCollab = null;
        ICollaboratorHelper instance = null;
        try {
            instance = ((WebApp)sc).getCollaboratorHelper();
        }
        catch (ClassCastException cce) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getCurrentSecurityCollaborator", "ClassCastException on ServletContext - returning null");
            }
            return CollaboratorHelperImpl.getCurrentSecurityCollaborator();
        }
        if (instance != null) {
            secCollab = instance.getSecurityCollaborator();
        }
        return secCollab;
    }

    public static IWebAppSecurityCollaborator getCurrentSecurityCollaborator() {
        IWebAppSecurityCollaborator currentCollab = null;
        ICollaboratorHelper instance = CollaboratorHelperImpl.getCurrentInstance();
        if (instance != null) {
            currentCollab = instance.getSecurityCollaborator();
        }
        return currentCollab;
    }

    public static boolean getCurrentSecurityEnabled() {
        boolean enabled = false;
        ICollaboratorHelper instance = CollaboratorHelperImpl.getCurrentInstance();
        if (instance != null) {
            enabled = ((CollaboratorHelperImpl)instance).isSecurityEnabled();
        }
        return enabled;
    }

    private static ICollaboratorHelper getCurrentInstance() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd != null) {
            WebModuleMetaData wmmd = (WebModuleMetaData)cmd.getModuleMetaData();
            return ((WebAppConfiguration)wmmd.getConfiguration()).getWebApp().getCollaboratorHelper();
        }
        return null;
    }

    public boolean isSecurityEnabled() {
        return CollaboratorServiceImpl.getWebAppSecurityCollaborator(this.securityDomainForApp) != null;
    }

    public static boolean isSecurityDomainEnabled(String secDomain) {
        return CollaboratorServiceImpl.getWebAppSecurityCollaborator(secDomain) != null;
    }
}

