/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.reader.tasks;

import com.ibm.ws.security.audit.reader.AuditUtilityReturnCodes;
import com.ibm.ws.security.audit.reader.AuditUtilityTask;
import com.ibm.ws.security.audit.reader.tasks.BaseCommandTask;
import com.ibm.ws.security.audit.reader.utils.ConsoleWrapper;
import java.io.PrintStream;
import java.util.List;

public class HelpTask
extends BaseCommandTask {
    private final List<AuditUtilityTask> tasks;

    public HelpTask(String scriptName, List<AuditUtilityTask> tasks) {
        super(scriptName);
        this.tasks = tasks;
    }

    @Override
    public String getTaskName() {
        return "help";
    }

    @Override
    public String getTaskHelp() {
        return this.getTaskHelp("help.desc", "help.usage.options", null, null, null, null, null, null, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("help.desc", true, new Object[0]);
    }

    public String getScriptUsage() {
        StringBuffer scriptUsage = new StringBuffer(NL);
        scriptUsage.append(this.getMessage("usage", this.scriptName));
        scriptUsage.append(" {");
        for (int i = 0; i < this.tasks.size(); ++i) {
            AuditUtilityTask task = this.tasks.get(i);
            scriptUsage.append(task.getTaskName());
            if (i == this.tasks.size() - 1) continue;
            scriptUsage.append("|");
        }
        scriptUsage.append("} [options]");
        scriptUsage.append(NL);
        return scriptUsage.toString();
    }

    public String getTaskUsage(AuditUtilityTask task) {
        StringBuffer taskUsage = new StringBuffer(NL);
        taskUsage.append(NL);
        taskUsage.append(task.getTaskHelp());
        return taskUsage.toString();
    }

    private String verboseHelp() {
        StringBuffer verboseHelp = new StringBuffer(this.getScriptUsage());
        if (this.tasks.size() > 0) {
            verboseHelp.append(NL);
            verboseHelp.append(this.getOption("global.actions", true, new Object[0]));
            verboseHelp.append(NL);
            for (AuditUtilityTask task : this.tasks) {
                verboseHelp.append(NL);
                verboseHelp.append("    ");
                verboseHelp.append(task.getTaskName());
                verboseHelp.append(NL);
                verboseHelp.append(task.getTaskDescription());
                verboseHelp.append(NL);
            }
            verboseHelp.append(NL);
            verboseHelp.append(this.getOption("global.options", true, new Object[0]));
            verboseHelp.append(NL);
            verboseHelp.append(this.getOption("global.options.statement", true, new Object[0]));
        }
        return verboseHelp.toString();
    }

    private String taskHelp(AuditUtilityTask task) {
        StringBuffer taskUsage = new StringBuffer(NL);
        taskUsage.append(task.getTaskHelp());
        taskUsage.append(NL);
        return taskUsage.toString();
    }

    private AuditUtilityTask getTask(String taskName) {
        AuditUtilityTask task = null;
        for (AuditUtilityTask availTask : this.tasks) {
            if (!availTask.getTaskName().equals(taskName)) continue;
            task = availTask;
        }
        return task;
    }

    @Override
    public AuditUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) {
        if (args.length == 1) {
            stdout.println(this.verboseHelp());
        } else {
            AuditUtilityTask task = this.getTask(args[1]);
            if (task == null) {
                stderr.println(NL + this.getMessage("task.unknown", args[1]) + NL);
            } else {
                stdout.println(this.taskHelp(task));
            }
        }
        return AuditUtilityReturnCodes.OK;
    }

    @Override
    boolean isKnownArgument(String arg) {
        return false;
    }

    @Override
    void checkRequiredArguments(String[] args) {
    }
}

