/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.ClassLoaderIdentifierService;
import com.ibm.ws.container.service.metadata.extended.IdentifiableComponentMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import io.openliberty.concurrent.internal.cdi.ConcurrencyExtensionMetadata;
import io.openliberty.concurrent.internal.cdi.MTFBeanResourceInfoImpl;
import io.openliberty.concurrent.internal.cdi.metadata.MTFDeferredMetaDataFactory;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactory;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ManagedThreadFactoryBean
implements Bean<ManagedThreadFactory>,
PassivationCapable {
    private static final TraceComponent tc = Tr.register(ManagedThreadFactoryBean.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");
    private final Set<Type> beanTypes = Set.of(ManagedThreadFactory.class);
    private final ClassLoader declaringClassLoader;
    private final MetaData declaringMetadata;
    private final ResourceFactory factory;
    private final Set<Annotation> qualifiers;
    static final long serialVersionUID = 1966576953342361565L;

    ManagedThreadFactoryBean(ComponentMetaData cmd, ConcurrencyExtensionMetadata extSvc, Set<Annotation> qualifiers) {
        this.factory = extSvc.defaultManagedThreadFactoryFactory;
        this.qualifiers = qualifiers;
        if (!(cmd instanceof IdentifiableComponentMetaData)) {
            throw new IllegalArgumentException(cmd.toString());
        }
        String identifier = ((IdentifiableComponentMetaData)cmd).getPersistentIdentifier();
        BundleContext bc = FrameworkUtil.getBundle(ClassLoaderIdentifierService.class).getBundleContext();
        ServiceReference ref = bc.getServiceReference(ClassLoaderIdentifierService.class);
        ClassLoaderIdentifierService classloaderIdSvc = (ClassLoaderIdentifierService)bc.getService(ref);
        this.declaringClassLoader = classloaderIdSvc.getClassLoader(identifier);
        ApplicationMetaData amd = cmd.getModuleMetaData().getApplicationMetaData();
        MTFDeferredMetaDataFactory metadataFactory = (MTFDeferredMetaDataFactory)extSvc.mtfMetadataFactory;
        this.declaringMetadata = metadataFactory.createComponentMetadata((MetaData)amd, this.declaringClassLoader);
    }

    ManagedThreadFactoryBean(QualifiedResourceFactory factory, ConcurrencyExtensionMetadata extSvc) {
        this.factory = factory;
        this.qualifiers = factory.getQualifiers();
        this.declaringClassLoader = factory.getDeclaringClassLoader();
        MetaData mdata = factory.getDeclaringMetadata();
        if (mdata instanceof ApplicationMetaData) {
            ApplicationMetaData amd = (ApplicationMetaData)mdata;
            MTFDeferredMetaDataFactory metadataFactory = (MTFDeferredMetaDataFactory)extSvc.mtfMetadataFactory;
            this.declaringMetadata = metadataFactory.createComponentMetadata((MetaData)amd, this.declaringClassLoader);
        } else {
            this.declaringMetadata = mdata;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    public ManagedThreadFactory create(CreationalContext<ManagedThreadFactory> cc) {
        ManagedThreadFactory instance;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"create", (Object[])new Object[]{cc, this.factory, this.qualifiers});
        }
        try {
            MTFBeanResourceInfoImpl info = new MTFBeanResourceInfoImpl(this.declaringClassLoader, this.declaringMetadata);
            instance = (ManagedThreadFactory)this.factory.createResource((ResourceInfo)info);
        }
        catch (RuntimeException info) {
            void x;
            FFDCFilter.processException((Throwable)info, (String)"io.openliberty.concurrent.internal.cdi.ManagedThreadFactoryBean", (String)"138", (Object)this, (Object[])new Object[]{cc});
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"create", (Object)x);
            }
            throw x;
        }
        catch (Exception x) {
            FFDCFilter.processException((Throwable)x, (String)"io.openliberty.concurrent.internal.cdi.ManagedThreadFactoryBean", (String)"142", (Object)this, (Object[])new Object[]{cc});
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"create", (Object)x);
            }
            throw new RuntimeException(x);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"create", (Object)instance);
        }
        return instance;
    }

    public void destroy(ManagedThreadFactory instance, CreationalContext<ManagedThreadFactory> creationalContext) {
    }

    @Trivial
    public Class<ManagedThreadFactory> getBeanClass() {
        return ManagedThreadFactory.class;
    }

    @Trivial
    public String getId() {
        return this.getClass().getName() + ":" + this.qualifiers + ':' + this.factory;
    }

    @Trivial
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Trivial
    public String getName() {
        return null;
    }

    @Trivial
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    @Trivial
    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    @Trivial
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Trivial
    public Set<Type> getTypes() {
        return this.beanTypes;
    }

    @Trivial
    public boolean isAlternative() {
        return false;
    }

    @Trivial
    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()) + ' ' + this.factory + " with qualifiers " + this.qualifiers;
    }
}

