/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchExpressionHint;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;

public class FormSearchKeywordResolver
extends SearchKeywordResolver {
    public static final String FORM_KEYWORD = "form";

    public void resolve(SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        expressionContext.invokeContextCallback((UIComponent)FormSearchKeywordResolver.closest(UIForm.class, current));
    }

    private static <T> T closest(Class<T> type, UIComponent base) {
        for (UIComponent parent = base.getParent(); parent != null; parent = parent.getParent()) {
            if (!type.isAssignableFrom(parent.getClass())) continue;
            return (T)parent;
        }
        return null;
    }

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return FORM_KEYWORD.equalsIgnoreCase(keyword);
    }

    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return searchExpressionContext.getExpressionHints() != null && searchExpressionContext.getExpressionHints().contains(SearchExpressionHint.RESOLVE_CLIENT_SIDE);
    }

    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }
}

