/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal.eclipselink;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import org.eclipse.persistence.logging.SessionLogEntry;

@Trivial
class LogChannel {
    private final TraceComponent _tc;
    private static final TraceComponent _stc = Tr.register(LogChannel.class);

    LogChannel(String channel) {
        this._tc = Tr.register((String)channel, LogChannel.class, (String)"persistenceService");
    }

    boolean shouldLog(int level) {
        switch (level) {
            case 8: {
                return false;
            }
            case 7: {
                return this._tc.isErrorEnabled();
            }
            case 6: {
                return this._tc.isWarningEnabled();
            }
            case 5: {
                return this._tc.isInfoEnabled();
            }
            case 4: {
                return this._tc.isConfigEnabled();
            }
            case 3: {
                return this._tc.isEventEnabled();
            }
            case 2: {
                return this._tc.isEntryEnabled();
            }
        }
        return this._tc.isDebugEnabled();
    }

    void log(SessionLogEntry entry, String formattedMessage) {
        int level = entry.getLevel();
        Throwable loggedException = entry.getException();
        String msgParm = (formattedMessage == null || formattedMessage.equals("")) && loggedException != null ? loggedException.toString() : formattedMessage;
        switch (level) {
            case 8: {
                return;
            }
            case 7: {
                String errMsg = Tr.formatMessage((TraceComponent)_stc, (String)"PROVIDER_ERROR_CWWKD0292E", (Object[])new Object[]{msgParm});
                Tr.error((TraceComponent)this._tc, (String)errMsg, (Object[])new Object[0]);
                break;
            }
            case 6: {
                String wrnMsg = Tr.formatMessage((TraceComponent)_stc, (String)"PROVIDER_WARNING_CWWKD0291W", (Object[])new Object[]{msgParm});
                Tr.debug((TraceComponent)this._tc, (String)wrnMsg, (Object[])new Object[0]);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                Tr.debug((TraceComponent)this._tc, (String)formattedMessage, (Object[])new Object[0]);
            }
        }
        if (this._tc.isDebugEnabled() && loggedException != null) {
            Tr.debug((TraceComponent)this._tc, (String)"throwable", (Object[])new Object[]{loggedException});
        }
    }
}

