/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared.lang;

import jakarta.faces.context.FacesContext;
import java.util.Map;

public class SharedStringBuilder {
    public static StringBuilder get(String stringBuilderKey) {
        return SharedStringBuilder.get(FacesContext.getCurrentInstance(), stringBuilderKey);
    }

    public static StringBuilder get(String stringBuilderKey, String initialText) {
        return SharedStringBuilder.get(FacesContext.getCurrentInstance(), stringBuilderKey, initialText);
    }

    public static StringBuilder get(FacesContext facesContext, String stringBuilderKey) {
        Map attributes = facesContext.getAttributes();
        StringBuilder sb = (StringBuilder)attributes.get(stringBuilderKey);
        if (sb == null) {
            sb = new StringBuilder();
            attributes.put(stringBuilderKey, sb);
        } else {
            sb.setLength(0);
        }
        return sb;
    }

    public static StringBuilder get(FacesContext facesContext, String stringBuilderKey, String initialText) {
        Map attributes = facesContext.getAttributes();
        StringBuilder sb = (StringBuilder)attributes.get(stringBuilderKey);
        if (sb == null) {
            sb = new StringBuilder(initialText);
            attributes.put(stringBuilderKey, sb);
        } else {
            sb.setLength(0);
            sb.append(initialText);
        }
        return sb;
    }

    public static StringBuilder get(FacesContext facesContext, String stringBuilderKey, int initialSize) {
        Map attributes = facesContext.getAttributes();
        StringBuilder sb = (StringBuilder)attributes.get(stringBuilderKey);
        if (sb == null) {
            sb = new StringBuilder(initialSize);
            attributes.put(stringBuilderKey, sb);
        } else {
            sb.setLength(0);
        }
        return sb;
    }
}

