/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.jboss.weld.bean.proxy.StackAwareMethodHandler;
import org.jboss.weld.interceptor.proxy.AroundInvokeInvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.proxy.SecurityActions;
import org.jboss.weld.interceptor.proxy.WeldInvocationContextImpl;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptorMethodHandler
implements StackAwareMethodHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final InterceptionContext ctx;
    private final transient ConcurrentMap<Method, CachedInterceptionChain> cachedChains;

    public InterceptorMethodHandler(InterceptionContext ctx) {
        this.ctx = ctx;
        this.cachedChains = new ConcurrentHashMap<Method, CachedInterceptionChain>();
    }

    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        return this.invoke(InterceptionDecorationContext.getStack(), self, thisMethod, proceed, args);
    }

    @Override
    public Object invoke(InterceptionDecorationContext.Stack stack, Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        SecurityActions.ensureAccessible(proceed);
        if (proceed == null) {
            if (thisMethod.getName().equals("lifecycle_mixin_$$_postConstruct")) {
                return this.executeInterception(self, null, null, null, InterceptionType.POST_CONSTRUCT, stack);
            }
            if (thisMethod.getName().equals("lifecycle_mixin_$$_preDestroy")) {
                return this.executeInterception(self, null, null, null, InterceptionType.PRE_DESTROY, stack);
            }
        } else {
            if (this.isInterceptorMethod(thisMethod)) {
                return Reflections.invokeAndUnwrap(self, proceed, args);
            }
            return this.executeInterception(self, thisMethod, proceed, args, InterceptionType.AROUND_INVOKE, stack);
        }
        return null;
    }

    protected Object executeInterception(Object instance, Method method, Method proceed, Object[] args, InterceptionType interceptionType, InterceptionDecorationContext.Stack stack) throws Throwable {
        CachedInterceptionChain chain = this.getInterceptionChain(instance, method, interceptionType);
        if (chain.interceptorMethods.isEmpty()) {
            if (proceed == null) {
                return null;
            }
            return Reflections.invokeAndUnwrap(instance, proceed, args);
        }
        if (InterceptionType.AROUND_INVOKE == interceptionType) {
            return this.executeAroundInvoke(instance, method, proceed, args, chain, stack);
        }
        return this.executeLifecycleInterception(instance, method, proceed, args, chain, stack);
    }

    protected Object executeLifecycleInterception(Object instance, Method method, Method proceed, Object[] args, CachedInterceptionChain chain, InterceptionDecorationContext.Stack stack) throws Throwable {
        return new WeldInvocationContextImpl(instance, method, proceed, args, chain.interceptorMethods, chain.interceptorBindings, stack).proceed();
    }

    protected Object executeAroundInvoke(Object instance, Method method, Method proceed, Object[] args, CachedInterceptionChain chain, InterceptionDecorationContext.Stack stack) throws Throwable {
        AroundInvokeInvocationContext ctx = AroundInvokeInvocationContext.create(instance, method, proceed, args, chain.interceptorMethods, chain.interceptorBindings, stack);
        try {
            return chain.interceptorMethods.get(0).invoke(ctx);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private CachedInterceptionChain getInterceptionChain(Object instance, Method method, InterceptionType interceptionType) {
        if (method != null) {
            CachedInterceptionChain old;
            CachedInterceptionChain cachedChain = (CachedInterceptionChain)this.cachedChains.get(method);
            if (cachedChain == null && (old = this.cachedChains.putIfAbsent(method, cachedChain = new CachedInterceptionChain(this.ctx.buildInterceptorMethodInvocations(instance, method, interceptionType), this.ctx.getInterceptionModel().getMemberInterceptorBindings(method)))) != null) {
                cachedChain = old;
            }
            return cachedChain;
        }
        return new CachedInterceptionChain(this.ctx.buildInterceptorMethodInvocations(instance, null, interceptionType), this.ctx.getInterceptionModel().getClassInterceptorBindings());
    }

    private boolean isInterceptorMethod(Method method) {
        return this.ctx.getInterceptionModel().getTargetClassInterceptorMetadata().isInterceptorMethod(method);
    }

    private Object readResolve() throws ObjectStreamException {
        return new InterceptorMethodHandler(this.ctx);
    }

    private static class CachedInterceptionChain {
        private final List<InterceptorMethodInvocation> interceptorMethods;
        private final Set<Annotation> interceptorBindings;

        public CachedInterceptionChain(List<InterceptorMethodInvocation> chain, Set<Annotation> interceptorBindings) {
            this.interceptorMethods = chain;
            this.interceptorBindings = interceptorBindings;
        }
    }
}

