/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.udpchannel.internal.UDPBufferFactory;
import com.ibm.ws.udpchannel.internal.UDPBufferImpl;
import com.ibm.ws.udpchannel.internal.UDPConnLink;
import com.ibm.ws.udpchannel.internal.UDPRequestContextImpl;
import com.ibm.ws.udpchannel.internal.WorkQueueManager;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.udpchannel.UDPBuffer;
import com.ibm.wsspi.udpchannel.UDPReadCompletedCallback;
import com.ibm.wsspi.udpchannel.UDPReadCompletedCallbackThreaded;
import com.ibm.wsspi.udpchannel.UDPReadRequestContext;
import java.net.SocketAddress;

public class UDPReadRequestContextImpl
extends UDPRequestContextImpl
implements UDPReadRequestContext {
    private static final TraceComponent tc = Tr.register(UDPReadRequestContextImpl.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private boolean readCalled = false;
    private UDPReadCompletedCallback readCallback = null;
    private UDPReadCompletedCallbackThreaded readAlwaysCallback = null;
    private boolean bIsForceQueue = false;
    private UDPBufferImpl udpBuffer = UDPBufferFactory.getUDPBuffer();

    public UDPReadRequestContextImpl(UDPConnLink udpContext, WorkQueueManager wqm) {
        super(udpContext, wqm);
    }

    @Override
    public VirtualConnection read(UDPReadCompletedCallback callback, boolean forceQueue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("read(force=" + forceQueue + ")"), (Object[])new Object[0]);
        }
        this.readCallback = callback;
        this.readCalled = true;
        this.bIsForceQueue = forceQueue;
        VirtualConnection vc = this.getWorkQueueManager().processWork(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("read(): " + vc));
        }
        return vc;
    }

    @Override
    public void readAlways(UDPReadCompletedCallbackThreaded callback, boolean enable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("readAlways(enable=" + enable + ")"), (Object[])new Object[0]);
        }
        this.readAlwaysCallback = enable ? callback : null;
        this.getWorkQueueManager().processWork(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readAlways()");
        }
    }

    @Override
    public UDPBuffer getUDPBuffer() {
        this.readCalled = false;
        return this.udpBuffer;
    }

    protected boolean setBuffer(WsByteBuffer buffer, SocketAddress address, boolean firstPacket) {
        boolean returnValue = true;
        if (this.readCalled || firstPacket || this.isReadAlwaysCalled()) {
            this.udpBuffer.set(buffer, address);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setBuffer called with " + buffer + " address " + address), (Object[])new Object[0]);
            }
        } else {
            returnValue = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setBuffer called but no read was called.", (Object[])new Object[0]);
            }
        }
        return returnValue;
    }

    protected void complete(UDPBuffer buffer) {
        if (this.isReadAlwaysCalled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling multi-threaded read callback.", (Object[])new Object[0]);
            }
            this.readAlwaysCallback.complete(this.getConnLink().getVirtualConnection(), buffer);
        }
    }

    protected void complete() {
        if (this.isReadAlwaysCalled()) {
            UDPBufferImpl buffer = UDPBufferFactory.getUDPBuffer();
            buffer.set(this.udpBuffer.getBuffer(), this.udpBuffer.getAddress());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling multi-threaded read callback.", (Object[])new Object[0]);
            }
            this.readAlwaysCallback.complete(this.getConnLink().getVirtualConnection(), buffer);
        } else if (this.readCallback != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling read callback.", (Object[])new Object[0]);
            }
            this.readCallback.complete(this.getConnLink().getVirtualConnection(), this);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No read callback set", (Object[])new Object[0]);
        }
    }

    public boolean isForceQueue() {
        return this.bIsForceQueue;
    }

    protected boolean isReadAlwaysCalled() {
        return null != this.readAlwaysCallback;
    }

    @Override
    public boolean isRead() {
        return true;
    }
}

