/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Spliterators;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceVisitOption;
import javax.faces.application.ResourceWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.application.DefaultResourceHandlerSupport;
import org.apache.myfaces.application.ViewResourceIterator;
import org.apache.myfaces.application._LocaleUtils;
import org.apache.myfaces.shared.renderkit.html.util.SharedStringBuilder;
import org.apache.myfaces.shared.resource.ContractResourceLoader;
import org.apache.myfaces.shared.resource.ResourceCachedInfo;
import org.apache.myfaces.shared.resource.ResourceHandlerCache;
import org.apache.myfaces.shared.resource.ResourceHandlerSupport;
import org.apache.myfaces.shared.resource.ResourceImpl;
import org.apache.myfaces.shared.resource.ResourceLoader;
import org.apache.myfaces.shared.resource.ResourceMeta;
import org.apache.myfaces.shared.resource.ResourceValidationUtils;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.ExternalContextUtils;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.util.SkipMatchIterator;

public class ResourceHandlerImpl
extends ResourceHandler {
    private static final String IS_RESOURCE_REQUEST = "org.apache.myfaces.IS_RESOURCE_REQUEST";
    private ResourceHandlerSupport _resourceHandlerSupport;
    private ResourceHandlerCache _resourceHandlerCache;
    private static final Logger log = Logger.getLogger(ResourceHandlerImpl.class.getName());
    public static final String INIT_PARAM_STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME = "org.apache.myfaces.STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME";
    public static final boolean INIT_PARAM_STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME_DEFAULT = false;
    public static final String INIT_PARAM_RESOURCE_BUFFER_SIZE = "org.apache.myfaces.RESOURCE_BUFFER_SIZE";
    public static final int INIT_PARAM_RESOURCE_BUFFER_SIZE_DEFAULT = 2048;
    public static final Pattern LIBRARY_VERSION_CHECKER = Pattern.compile("\\p{Digit}+(_\\p{Digit}*)*");
    public static final Pattern RESOURCE_VERSION_CHECKER = Pattern.compile("\\p{Digit}+(_\\p{Digit}*)*\\..*");
    private Boolean _allowSlashLibraryName;
    private int _resourceBufferSize = -1;
    private String[] _excludedResourceExtensions;
    private static final String[] FACELETS_VIEW_MAPPINGS_PARAM = new String[]{"javax.faces.FACELETS_VIEW_MAPPINGS", "facelets.VIEW_MAPPINGS"};
    private Set<String> _viewSuffixes = null;
    private static final String MYFACES_JS_RESOURCE_NAME = "oamSubmit.js";
    public static final String RENDERED_RESOURCES_SET = "org.apache.myfaces.RENDERED_RESOURCES_SET";
    private static final String MYFACES_LIBRARY_NAME = "org.apache.myfaces";
    private static final String SHARED_STRING_BUILDER = ResourceHandlerImpl.class.getName() + ".SHARED_STRING_BUILDER";

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        ResourceImpl resource = null;
        if (resourceName == null) {
            throw new NullPointerException();
        }
        if (resourceName.length() == 0) {
            return null;
        }
        if (resourceName.charAt(0) == '/') {
            resourceName = resourceName.substring(1);
        }
        if (!ResourceValidationUtils.isValidResourceName(resourceName)) {
            return null;
        }
        if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName, this.isAllowSlashesLibraryName())) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (contentType == null) {
            contentType = facesContext.getExternalContext().getMimeType(resourceName);
        }
        String localePrefix = this.getLocalePrefixForLocateResource(facesContext);
        List contracts = facesContext.getResourceLibraryContracts();
        String contractPreferred = this.getContractNameForLocateResource(facesContext);
        ResourceHandlerCache.ResourceValue resourceValue = null;
        if (contractPreferred != null) {
            resourceValue = this.getResourceLoaderCache().getResource(resourceName, libraryName, contentType, localePrefix, contractPreferred);
        }
        if (resourceValue == null && !contracts.isEmpty()) {
            for (String contract : contracts) {
                resourceValue = this.getResourceLoaderCache().getResource(resourceName, libraryName, contentType, localePrefix, contract);
                if (resourceValue == null) continue;
                break;
            }
        }
        if (resourceValue == null) {
            resourceValue = this.getResourceLoaderCache().getResource(resourceName, libraryName, contentType, localePrefix);
        }
        if (resourceValue != null) {
            resource = new ResourceImpl(resourceValue.getResourceMeta(), resourceValue.getResourceLoader(), this.getResourceHandlerSupport(), contentType, resourceValue.getCachedInfo() != null ? resourceValue.getCachedInfo().getURL() : null, resourceValue.getCachedInfo() != null ? resourceValue.getCachedInfo().getRequestPath() : null);
        } else {
            Object resourceMeta;
            boolean resolved = false;
            if (contractPreferred != null) {
                for (ResourceLoader resourceLoader : this.getResourceHandlerSupport().getContractResourceLoaders()) {
                    resourceMeta = this.deriveResourceMeta((ContractResourceLoader)resourceLoader, resourceName, libraryName, localePrefix, contractPreferred);
                    if (resourceMeta == null) continue;
                    resource = new ResourceImpl((ResourceMeta)resourceMeta, resourceLoader, this.getResourceHandlerSupport(), contentType);
                    this.getResourceLoaderCache().putResource(resourceName, libraryName, contentType, localePrefix, contractPreferred, (ResourceMeta)resourceMeta, resourceLoader, new ResourceCachedInfo(resource.getURL(), resource.getRequestPath()));
                    resolved = true;
                    break;
                }
            }
            if (!resolved && !contracts.isEmpty()) {
                block2: for (ResourceLoader resourceLoader : this.getResourceHandlerSupport().getContractResourceLoaders()) {
                    for (String contract : contracts) {
                        ResourceMeta resourceMeta2 = this.deriveResourceMeta((ContractResourceLoader)resourceLoader, resourceName, libraryName, localePrefix, contract);
                        if (resourceMeta2 == null) continue;
                        resource = new ResourceImpl(resourceMeta2, resourceLoader, this.getResourceHandlerSupport(), contentType);
                        this.getResourceLoaderCache().putResource(resourceName, libraryName, contentType, localePrefix, contract, resourceMeta2, resourceLoader, new ResourceCachedInfo(resource.getURL(), resource.getRequestPath()));
                        resolved = true;
                        continue block2;
                    }
                }
            }
            if (!resolved) {
                for (ResourceLoader resourceLoader : this.getResourceHandlerSupport().getResourceLoaders()) {
                    resourceMeta = this.deriveResourceMeta(resourceLoader, resourceName, libraryName, localePrefix);
                    if (resourceMeta == null) continue;
                    resource = new ResourceImpl((ResourceMeta)resourceMeta, resourceLoader, this.getResourceHandlerSupport(), contentType);
                    this.getResourceLoaderCache().putResource(resourceName, libraryName, contentType, localePrefix, null, (ResourceMeta)resourceMeta, resourceLoader, new ResourceCachedInfo(resource.getURL(), resource.getRequestPath()));
                    break;
                }
            }
        }
        return resource;
    }

    protected ResourceMeta deriveResourceMeta(ContractResourceLoader resourceLoader, String resourceName, String libraryName, String localePrefix, String contractName) {
        String resourceVersion = null;
        String libraryVersion = null;
        ResourceMeta resourceId = null;
        if (localePrefix != null) {
            if (null != libraryName) {
                String pathToLib = localePrefix + '/' + libraryName;
                libraryVersion = resourceLoader.getLibraryVersion(pathToLib, contractName);
                if (null != libraryVersion) {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource, contractName);
                } else {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource, contractName);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, libraryName, libraryVersion, resourceName, resourceVersion, contractName);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(localePrefix + '/' + resourceName, contractName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, null, null, resourceName, resourceVersion, contractName);
                }
            }
            if (resourceId != null && !resourceLoader.resourceExists(resourceId)) {
                resourceId = null;
            }
        }
        if (resourceId == null) {
            if (null != libraryName) {
                String pathToResource;
                libraryVersion = resourceLoader.getLibraryVersion(libraryName, contractName);
                if (null != libraryVersion) {
                    pathToResource = libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource, contractName);
                } else {
                    pathToResource = libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource, contractName);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, libraryName, libraryVersion, resourceName, resourceVersion, contractName);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(resourceName, contractName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, null, null, resourceName, resourceVersion, contractName);
                }
            }
            if (resourceId != null && !resourceLoader.resourceExists(resourceId)) {
                resourceId = null;
            }
        }
        return resourceId;
    }

    protected ResourceMeta deriveResourceMeta(ResourceLoader resourceLoader, String resourceName, String libraryName, String localePrefix) {
        String resourceVersion = null;
        String libraryVersion = null;
        ResourceMeta resourceId = null;
        if (localePrefix != null) {
            if (null != libraryName) {
                String pathToLib = localePrefix + '/' + libraryName;
                libraryVersion = resourceLoader.getLibraryVersion(pathToLib);
                if (null != libraryVersion) {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(localePrefix + '/' + resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && !resourceLoader.resourceExists(resourceId)) {
                resourceId = null;
            }
        }
        if (resourceId == null) {
            if (null != libraryName) {
                String pathToResource;
                libraryVersion = resourceLoader.getLibraryVersion(libraryName);
                if (null != libraryVersion) {
                    pathToResource = libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    pathToResource = libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && !resourceLoader.resourceExists(resourceId)) {
                resourceId = null;
            }
        }
        return resourceId;
    }

    public String getRendererTypeForResourceName(String resourceName) {
        if (resourceName.endsWith(".js")) {
            return "javax.faces.resource.Script";
        }
        if (resourceName.endsWith(".css")) {
            return "javax.faces.resource.Stylesheet";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        String resourceBasePath = this.getResourceHandlerSupport().calculateResourceBasePath(facesContext);
        if (resourceBasePath == null) {
            return;
        }
        ExternalContext extContext = facesContext.getExternalContext();
        Object response = extContext.getResponse();
        HttpServletResponse httpServletResponse = ExternalContextUtils.getHttpServletResponse(response);
        if (httpServletResponse == null) {
            throw new IllegalStateException("Could not obtain an instance of HttpServletResponse.");
        }
        if (this.isResourceIdentifierExcluded(facesContext, resourceBasePath)) {
            httpServletResponse.setStatus(404);
            return;
        }
        String resourceName = null;
        if (resourceBasePath.startsWith("/javax.faces.resource")) {
            resourceName = resourceBasePath.substring("/javax.faces.resource".length() + 1);
            if (resourceBasePath != null && !ResourceValidationUtils.isValidResourceName(resourceName)) {
                httpServletResponse.setStatus(404);
                return;
            }
        } else {
            httpServletResponse.setStatus(404);
            return;
        }
        String libraryName = (String)facesContext.getExternalContext().getRequestParameterMap().get("ln");
        if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName, this.isAllowSlashesLibraryName())) {
            httpServletResponse.setStatus(404);
            return;
        }
        Resource resource = null;
        resource = libraryName != null ? facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName) : facesContext.getApplication().getResourceHandler().createResource(resourceName);
        if (resource == null) {
            httpServletResponse.setStatus(404);
            return;
        }
        if (!resource.userAgentNeedsUpdate(facesContext)) {
            httpServletResponse.setStatus(304);
            return;
        }
        httpServletResponse.setContentType(this._getContentType(resource, facesContext.getExternalContext()));
        Map headers = resource.getResponseHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            httpServletResponse.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        extContext.setResponseBufferSize(this.getResourceBufferSize());
        try {
            InputStream in = resource.getInputStream();
            ServletOutputStream out = httpServletResponse.getOutputStream();
            byte[] buffer = new byte[this.getResourceBufferSize()];
            try {
                int count = ResourceHandlerImpl.pipeBytes(in, (OutputStream)out, buffer);
                if (!httpServletResponse.isCommitted()) {
                    httpServletResponse.setContentLength(count);
                }
            }
            finally {
                try {
                    in.close();
                }
                finally {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            if (ResourceHandlerImpl.isConnectionAbort(e)) {
                log.log(Level.INFO, "Connection was aborted while loading resource " + resourceName + " with library " + libraryName);
            }
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Error trying to load and send resource " + resourceName + " with library " + libraryName + " :" + e.getMessage(), e);
            }
            httpServletResponse.setStatus(404);
        }
    }

    private static boolean isConnectionAbort(IOException e) {
        return e.getClass().getCanonicalName().equals("org.apache.catalina.connector.ClientAbortException");
    }

    private static int pipeBytes(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int length;
        int count = 0;
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
            count += length;
        }
        return count;
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        Boolean value = (Boolean)facesContext.getAttributes().get(IS_RESOURCE_REQUEST);
        if (value == null) {
            String resourceBasePath = this.getResourceHandlerSupport().calculateResourceBasePath(facesContext);
            value = resourceBasePath != null && resourceBasePath.startsWith("/javax.faces.resource");
            facesContext.getAttributes().put(IS_RESOURCE_REQUEST, value);
        }
        return value;
    }

    protected String getLocalePrefixForLocateResource() {
        return this.getLocalePrefixForLocateResource(FacesContext.getCurrentInstance());
    }

    protected String getLocalePrefixForLocateResource(FacesContext context) {
        String localePrefix = null;
        boolean isResourceRequest = context.getApplication().getResourceHandler().isResourceRequest(context);
        if (isResourceRequest && (localePrefix = (String)context.getExternalContext().getRequestParameterMap().get("loc")) != null) {
            if (!ResourceValidationUtils.isValidLocalePrefix(localePrefix)) {
                return null;
            }
            return localePrefix;
        }
        String bundleName = context.getApplication().getMessageBundle();
        if (null != bundleName) {
            Locale locale = null;
            locale = isResourceRequest || context.getViewRoot() == null ? context.getApplication().getViewHandler().calculateLocale(context) : context.getViewRoot().getLocale();
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, ClassUtils.getContextClassLoader());
                if (bundle != null && bundle.containsKey("javax.faces.resource.localePrefix")) {
                    localePrefix = bundle.getString("javax.faces.resource.localePrefix");
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return localePrefix;
    }

    protected String getContractNameForLocateResource(FacesContext context) {
        String contractName = null;
        boolean isResourceRequest = context.getApplication().getResourceHandler().isResourceRequest(context);
        if (isResourceRequest) {
            contractName = (String)context.getExternalContext().getRequestParameterMap().get("con");
        }
        if (contractName == null) {
            contractName = (String)context.getAttributes().get("oam.contract.SELECTED");
        }
        if (contractName != null && !ResourceValidationUtils.isValidContractName(contractName)) {
            return null;
        }
        return contractName;
    }

    protected boolean isResourceIdentifierExcluded(FacesContext context, String resourceIdentifier) {
        if (this._excludedResourceExtensions == null) {
            String value = WebConfigParamUtils.getStringInitParameter(context.getExternalContext(), "javax.faces.RESOURCE_EXCLUDES", ".class .jsp .jspx .properties .xhtml .groovy");
            this._excludedResourceExtensions = StringUtils.splitShortString(value, ' ');
        }
        for (int i = 0; i < this._excludedResourceExtensions.length; ++i) {
            if (!resourceIdentifier.endsWith(this._excludedResourceExtensions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean libraryExists(String libraryName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String localePrefix = this.getLocalePrefixForLocateResource(facesContext);
        List contracts = facesContext.getResourceLibraryContracts();
        String pathToLib = null;
        Boolean libraryFound = null;
        if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName, this.isAllowSlashesLibraryName())) {
            return false;
        }
        if (localePrefix != null) {
            pathToLib = localePrefix + '/' + libraryName;
            libraryFound = this.getResourceLoaderCache().libraryExists(pathToLib);
            if (libraryFound != null) {
                return libraryFound;
            }
        }
        if ((libraryFound = this.getResourceLoaderCache().libraryExists(libraryName)) != null) {
            return libraryFound;
        }
        if (localePrefix != null) {
            if (!contracts.isEmpty()) {
                for (String contract : contracts) {
                    ContractResourceLoader[] contractResourceLoaderArray = this.getResourceHandlerSupport().getContractResourceLoaders();
                    int n = contractResourceLoaderArray.length;
                    for (int i = 0; i < n; ++i) {
                        ContractResourceLoader loader = contractResourceLoaderArray[i];
                        if (!loader.libraryExists(pathToLib, contract)) continue;
                        this.getResourceLoaderCache().confirmLibraryExists(pathToLib);
                        return true;
                    }
                }
            }
            for (ResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
                if (!loader.libraryExists(pathToLib)) continue;
                this.getResourceLoaderCache().confirmLibraryExists(pathToLib);
                return true;
            }
        }
        if (!contracts.isEmpty()) {
            for (String contract : contracts) {
                for (ContractResourceLoader loader : this.getResourceHandlerSupport().getContractResourceLoaders()) {
                    if (!loader.libraryExists(libraryName, contract)) continue;
                    this.getResourceLoaderCache().confirmLibraryExists(libraryName);
                    return true;
                }
            }
        }
        for (ResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
            if (!loader.libraryExists(libraryName)) continue;
            this.getResourceLoaderCache().confirmLibraryExists(libraryName);
            return true;
        }
        if (localePrefix != null) {
            this.getResourceLoaderCache().confirmLibraryNotExists(pathToLib);
        } else {
            this.getResourceLoaderCache().confirmLibraryNotExists(libraryName);
        }
        return false;
    }

    public void setResourceHandlerSupport(ResourceHandlerSupport resourceHandlerSupport) {
        this._resourceHandlerSupport = resourceHandlerSupport;
    }

    protected ResourceHandlerSupport getResourceHandlerSupport() {
        if (this._resourceHandlerSupport == null) {
            this._resourceHandlerSupport = new DefaultResourceHandlerSupport();
        }
        return this._resourceHandlerSupport;
    }

    private ResourceHandlerCache getResourceLoaderCache() {
        if (this._resourceHandlerCache == null) {
            this._resourceHandlerCache = new ResourceHandlerCache();
        }
        return this._resourceHandlerCache;
    }

    private String _getContentType(Resource resource, ExternalContext externalContext) {
        String resourceName;
        String contentType = resource.getContentType();
        if ((contentType == null || contentType.length() == 0) && (resourceName = this.getWrappedResourceName(resource)) != null) {
            contentType = externalContext.getMimeType(resourceName);
        }
        return contentType;
    }

    private String getWrappedResourceName(Resource resource) {
        String resourceName = resource.getResourceName();
        if (resourceName != null) {
            return resourceName;
        }
        if (resource instanceof ResourceWrapper) {
            return this.getWrappedResourceName(((ResourceWrapper)resource).getWrapped());
        }
        return null;
    }

    protected boolean isAllowSlashesLibraryName() {
        if (this._allowSlashLibraryName == null) {
            this._allowSlashLibraryName = WebConfigParamUtils.getBooleanInitParameter(FacesContext.getCurrentInstance().getExternalContext(), INIT_PARAM_STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME, false);
        }
        return this._allowSlashLibraryName;
    }

    protected int getResourceBufferSize() {
        if (this._resourceBufferSize == -1) {
            this._resourceBufferSize = WebConfigParamUtils.getIntegerInitParameter(FacesContext.getCurrentInstance().getExternalContext(), INIT_PARAM_RESOURCE_BUFFER_SIZE, 2048);
        }
        return this._resourceBufferSize;
    }

    public Resource createResourceFromId(String resourceId) {
        ResourceImpl resource = null;
        if (resourceId == null) {
            throw new NullPointerException();
        }
        if (!ResourceValidationUtils.isValidResourceId(resourceId)) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        List contracts = facesContext.getResourceLibraryContracts();
        String contractPreferred = this.getContractNameForLocateResource(facesContext);
        ResourceHandlerCache.ResourceValue resourceValue = null;
        if (contractPreferred != null) {
            resourceValue = this.getResourceLoaderCache().getResource(resourceId, contractPreferred);
        }
        if (resourceValue == null && !contracts.isEmpty()) {
            for (String contract : contracts) {
                resourceValue = this.getResourceLoaderCache().getResource(resourceId, contract);
                if (resourceValue == null) continue;
                break;
            }
        }
        if (resourceValue == null) {
            resourceValue = this.getResourceLoaderCache().getResource(resourceId);
        }
        if (resourceValue != null) {
            String contentType = facesContext.getExternalContext().getMimeType(resourceValue.getResourceMeta().getResourceName());
            resource = new ResourceImpl(resourceValue.getResourceMeta(), resourceValue.getResourceLoader(), this.getResourceHandlerSupport(), contentType, resourceValue.getCachedInfo() != null ? resourceValue.getCachedInfo().getURL() : null, resourceValue.getCachedInfo() != null ? resourceValue.getCachedInfo().getRequestPath() : null);
        } else {
            String contentType;
            Object resourceMeta;
            boolean resolved = false;
            if (contractPreferred != null) {
                for (ResourceLoader resourceLoader : this.getResourceHandlerSupport().getContractResourceLoaders()) {
                    resourceMeta = this.deriveResourceMeta(facesContext, (ContractResourceLoader)resourceLoader, resourceId, contractPreferred);
                    if (resourceMeta == null) continue;
                    contentType = facesContext.getExternalContext().getMimeType(((ResourceMeta)resourceMeta).getResourceName());
                    resource = new ResourceImpl((ResourceMeta)resourceMeta, resourceLoader, this.getResourceHandlerSupport(), contentType);
                    this.getResourceLoaderCache().putResource(resourceId, (ResourceMeta)resourceMeta, resourceLoader, new ResourceCachedInfo(resource.getURL(), resource.getRequestPath()));
                    resolved = true;
                    break;
                }
            }
            if (!resolved && !contracts.isEmpty()) {
                block2: for (ResourceLoader resourceLoader : this.getResourceHandlerSupport().getContractResourceLoaders()) {
                    for (String contract : contracts) {
                        ResourceMeta resourceMeta2 = this.deriveResourceMeta(facesContext, (ContractResourceLoader)resourceLoader, resourceId, contract);
                        if (resourceMeta2 == null) continue;
                        String contentType2 = facesContext.getExternalContext().getMimeType(resourceMeta2.getResourceName());
                        resource = new ResourceImpl(resourceMeta2, resourceLoader, this.getResourceHandlerSupport(), contentType2);
                        this.getResourceLoaderCache().putResource(resourceId, resourceMeta2, resourceLoader, new ResourceCachedInfo(resource.getURL(), resource.getRequestPath()));
                        resolved = true;
                        continue block2;
                    }
                }
            }
            if (!resolved) {
                for (ResourceLoader resourceLoader : this.getResourceHandlerSupport().getResourceLoaders()) {
                    resourceMeta = this.deriveResourceMeta(facesContext, resourceLoader, resourceId);
                    if (resourceMeta == null) continue;
                    contentType = facesContext.getExternalContext().getMimeType(((ResourceMeta)resourceMeta).getResourceName());
                    resource = new ResourceImpl((ResourceMeta)resourceMeta, resourceLoader, this.getResourceHandlerSupport(), contentType);
                    this.getResourceLoaderCache().putResource(resourceId, (ResourceMeta)resourceMeta, resourceLoader, new ResourceCachedInfo(resource.getURL(), resource.getRequestPath()));
                    break;
                }
            }
        }
        return resource;
    }

    protected ResourceMeta deriveResourceMeta(FacesContext context, ResourceLoader resourceLoader, String resourceId) {
        ResourceMeta resourceMeta = null;
        String token = null;
        String localePrefix = null;
        String libraryName = null;
        String libraryVersion = null;
        String resourceName = null;
        String resourceVersion = null;
        int lastSlash = resourceId.lastIndexOf(47);
        if (lastSlash < 0) {
            resourceName = resourceId;
        } else {
            Locale locale;
            token = resourceId.substring(lastSlash + 1);
            if (RESOURCE_VERSION_CHECKER.matcher(token).matches()) {
                String ext;
                String rnToken;
                int lastPoint;
                int secondLastSlash = resourceId.lastIndexOf(47, lastSlash - 1);
                if (secondLastSlash < 0) {
                    secondLastSlash = 0;
                }
                if ((lastPoint = (rnToken = resourceId.substring(secondLastSlash + 1, lastSlash)).lastIndexOf(46)) >= 0 && token.endsWith(ext = rnToken.substring(lastPoint))) {
                    resourceVersion = token.substring(0, token.length() - ext.length());
                }
            }
            int start = 0;
            int firstSlash = resourceId.indexOf(47);
            String bundleName = context.getApplication().getMessageBundle();
            if (null != bundleName && (locale = _LocaleUtils.deriveLocale(token = resourceId.substring(start, firstSlash))) != null && _LocaleUtils.isAvailableLocale(locale)) {
                localePrefix = token;
                start = firstSlash + 1;
            }
            if ((firstSlash = resourceId.indexOf(47, start)) < 0) {
                resourceName = resourceId.substring(start);
            } else {
                int minResourceNameSlash;
                token = resourceId.substring(start, firstSlash);
                int n = minResourceNameSlash = resourceVersion != null ? resourceId.lastIndexOf(47, lastSlash - 1) : lastSlash;
                if (start < minResourceNameSlash) {
                    libraryName = token;
                    start = firstSlash + 1;
                    if ((firstSlash = resourceId.indexOf(47, start)) >= 0 && LIBRARY_VERSION_CHECKER.matcher(token = resourceId.substring(start, firstSlash)).matches()) {
                        libraryVersion = token;
                        start = firstSlash + 1;
                    }
                }
                resourceName = (firstSlash = resourceId.indexOf(47, start)) < 0 ? resourceId.substring(start) : (resourceVersion != null ? resourceId.substring(start, lastSlash) : resourceId.substring(start));
            }
        }
        if (resourceName == null) {
            return null;
        }
        if (!ResourceValidationUtils.isValidResourceName(resourceName)) {
            return null;
        }
        if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName, this.isAllowSlashesLibraryName())) {
            return null;
        }
        if (localePrefix != null && localePrefix.length() == 0) {
            localePrefix = null;
        }
        if (libraryName != null && libraryName.length() == 0) {
            libraryName = null;
        }
        if (libraryVersion != null && libraryVersion.length() == 0) {
            libraryVersion = null;
        }
        if (resourceName != null && resourceName.length() == 0) {
            resourceName = null;
        }
        if (resourceVersion != null && resourceVersion.length() == 0) {
            resourceVersion = null;
        }
        if ((resourceMeta = resourceLoader.createResourceMeta(localePrefix, libraryName, libraryVersion, resourceName, resourceVersion)) != null && !resourceLoader.resourceExists(resourceMeta)) {
            resourceMeta = null;
        }
        return resourceMeta;
    }

    protected ResourceMeta deriveResourceMeta(FacesContext context, ContractResourceLoader resourceLoader, String resourceId, String contractName) {
        ResourceMeta resourceMeta = null;
        String token = null;
        String localePrefix = null;
        String libraryName = null;
        String libraryVersion = null;
        String resourceName = null;
        String resourceVersion = null;
        int lastSlash = resourceId.lastIndexOf(47);
        if (lastSlash < 0) {
            resourceName = resourceId;
        } else {
            Locale locale;
            token = resourceId.substring(lastSlash + 1);
            if (RESOURCE_VERSION_CHECKER.matcher(token).matches()) {
                String ext;
                String rnToken;
                int lastPoint;
                int secondLastSlash = resourceId.lastIndexOf(47, lastSlash - 1);
                if (secondLastSlash < 0) {
                    secondLastSlash = 0;
                }
                if ((lastPoint = (rnToken = resourceId.substring(secondLastSlash + 1, lastSlash)).lastIndexOf(46)) >= 0 && token.endsWith(ext = rnToken.substring(lastPoint))) {
                    resourceVersion = token.substring(0, token.length() - ext.length());
                }
            }
            int start = 0;
            int firstSlash = resourceId.indexOf(47);
            String bundleName = context.getApplication().getMessageBundle();
            if (null != bundleName && (locale = _LocaleUtils.deriveLocale(token = resourceId.substring(start, firstSlash))) != null && _LocaleUtils.isAvailableLocale(locale)) {
                localePrefix = token;
                start = firstSlash + 1;
            }
            if ((firstSlash = resourceId.indexOf(47, start)) < 0) {
                resourceName = resourceId.substring(start);
            } else {
                int minResourceNameSlash;
                token = resourceId.substring(start, firstSlash);
                int n = minResourceNameSlash = resourceVersion != null ? resourceId.lastIndexOf(47, lastSlash - 1) : lastSlash;
                if (start < minResourceNameSlash) {
                    libraryName = token;
                    start = firstSlash + 1;
                    if ((firstSlash = resourceId.indexOf(47, start)) >= 0 && LIBRARY_VERSION_CHECKER.matcher(token = resourceId.substring(start, firstSlash)).matches()) {
                        libraryVersion = token;
                        start = firstSlash + 1;
                    }
                }
                resourceName = (firstSlash = resourceId.indexOf(47, start)) < 0 ? resourceId.substring(start) : (resourceVersion != null ? resourceId.substring(start, lastSlash) : resourceId.substring(start));
            }
        }
        if (resourceName == null) {
            return null;
        }
        if (!ResourceValidationUtils.isValidResourceName(resourceName)) {
            return null;
        }
        if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName, this.isAllowSlashesLibraryName())) {
            return null;
        }
        if (localePrefix != null && localePrefix.length() == 0) {
            localePrefix = null;
        }
        if (libraryName != null && libraryName.length() == 0) {
            libraryName = null;
        }
        if (libraryVersion != null && libraryVersion.length() == 0) {
            libraryVersion = null;
        }
        if (resourceName != null && resourceName.length() == 0) {
            resourceName = null;
        }
        if (resourceVersion != null && resourceVersion.length() == 0) {
            resourceVersion = null;
        }
        if ((resourceMeta = resourceLoader.createResourceMeta(localePrefix, libraryName, libraryVersion, resourceName, resourceVersion, contractName)) != null && !resourceLoader.resourceExists(resourceMeta)) {
            resourceMeta = null;
        }
        return resourceMeta;
    }

    protected ResourceMeta deriveViewResourceMeta(FacesContext context, ResourceLoader resourceLoader, String resourceName, String localePrefix) {
        ResourceMeta resourceMeta = null;
        String resourceVersion = null;
        if (localePrefix != null) {
            resourceVersion = resourceLoader.getResourceVersion(localePrefix + '/' + resourceName);
            if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                resourceMeta = resourceLoader.createResourceMeta(localePrefix, null, null, resourceName, resourceVersion);
            }
            if (resourceMeta != null && !resourceLoader.resourceExists(resourceMeta)) {
                resourceMeta = null;
            }
        }
        if (resourceMeta == null) {
            resourceVersion = resourceLoader.getResourceVersion(resourceName);
            if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                resourceMeta = resourceLoader.createResourceMeta(null, null, null, resourceName, resourceVersion);
            }
            if (resourceMeta != null && !resourceLoader.resourceExists(resourceMeta)) {
                resourceMeta = null;
            }
        }
        return resourceMeta;
    }

    protected ResourceMeta deriveViewResourceMeta(FacesContext context, ContractResourceLoader resourceLoader, String resourceName, String localePrefix, String contractName) {
        ResourceMeta resourceMeta = null;
        String resourceVersion = null;
        if (localePrefix != null) {
            resourceVersion = resourceLoader.getResourceVersion(localePrefix + '/' + resourceName, contractName);
            if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                resourceMeta = resourceLoader.createResourceMeta(localePrefix, null, null, resourceName, resourceVersion, contractName);
            }
            if (resourceMeta != null && !resourceLoader.resourceExists(resourceMeta)) {
                resourceMeta = null;
            }
        }
        if (resourceMeta == null) {
            resourceVersion = resourceLoader.getResourceVersion(resourceName, contractName);
            if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                resourceMeta = resourceLoader.createResourceMeta(null, null, null, resourceName, resourceVersion, contractName);
            }
            if (resourceMeta != null && !resourceLoader.resourceExists(resourceMeta)) {
                resourceMeta = null;
            }
        }
        return resourceMeta;
    }

    public Resource createViewResource(FacesContext facesContext, String resourceName) {
        ResourceImpl resource = null;
        if (resourceName == null) {
            throw new NullPointerException();
        }
        if (resourceName.charAt(0) == '/') {
            resourceName = resourceName.substring(1);
        }
        if (!ResourceValidationUtils.isValidViewResource(resourceName)) {
            return null;
        }
        String localePrefix = this.getLocalePrefixForLocateResource(facesContext);
        String contentType = facesContext.getExternalContext().getMimeType(resourceName);
        List contracts = facesContext.getResourceLibraryContracts();
        String contractPreferred = this.getContractNameForLocateResource(facesContext);
        ResourceHandlerCache.ResourceValue resourceValue = null;
        if (contractPreferred != null) {
            resourceValue = this.getResourceLoaderCache().getViewResource(resourceName, contentType, localePrefix, contractPreferred);
        }
        if (resourceValue == null && !contracts.isEmpty()) {
            for (String contract : contracts) {
                resourceValue = this.getResourceLoaderCache().getViewResource(resourceName, contentType, localePrefix, contract);
                if (resourceValue == null) continue;
                break;
            }
        }
        if (resourceValue == null) {
            resourceValue = this.getResourceLoaderCache().getViewResource(resourceName, contentType, localePrefix);
        }
        if (resourceValue != null) {
            resource = new ResourceImpl(resourceValue.getResourceMeta(), resourceValue.getResourceLoader(), this.getResourceHandlerSupport(), contentType, resourceValue.getCachedInfo() != null ? resourceValue.getCachedInfo().getURL() : null, null);
        } else {
            Object resourceMeta;
            boolean resolved = false;
            if (contractPreferred != null) {
                for (ResourceLoader resourceLoader : this.getResourceHandlerSupport().getContractResourceLoaders()) {
                    resourceMeta = this.deriveViewResourceMeta(facesContext, (ContractResourceLoader)resourceLoader, resourceName, localePrefix, contractPreferred);
                    if (resourceMeta == null) continue;
                    resource = new ResourceImpl((ResourceMeta)resourceMeta, resourceLoader, this.getResourceHandlerSupport(), contentType);
                    this.getResourceLoaderCache().putViewResource(resourceName, contentType, localePrefix, contractPreferred, (ResourceMeta)resourceMeta, resourceLoader, new ResourceCachedInfo(resource.getURL(), null));
                    resolved = true;
                    break;
                }
            }
            if (!resolved && !contracts.isEmpty()) {
                block2: for (ResourceLoader resourceLoader : this.getResourceHandlerSupport().getContractResourceLoaders()) {
                    for (String contract : contracts) {
                        ResourceMeta resourceMeta2 = this.deriveViewResourceMeta(facesContext, (ContractResourceLoader)resourceLoader, resourceName, localePrefix, contract);
                        if (resourceMeta2 == null) continue;
                        resource = new ResourceImpl(resourceMeta2, resourceLoader, this.getResourceHandlerSupport(), contentType);
                        this.getResourceLoaderCache().putViewResource(resourceName, contentType, localePrefix, contract, resourceMeta2, resourceLoader, new ResourceCachedInfo(resource.getURL(), null));
                        resolved = true;
                        continue block2;
                    }
                }
            }
            if (!resolved) {
                for (ResourceLoader resourceLoader : this.getResourceHandlerSupport().getViewResourceLoaders()) {
                    resourceMeta = this.deriveViewResourceMeta(facesContext, resourceLoader, resourceName, localePrefix);
                    if (resourceMeta == null) continue;
                    resource = new ResourceImpl((ResourceMeta)resourceMeta, resourceLoader, this.getResourceHandlerSupport(), contentType);
                    this.getResourceLoaderCache().putViewResource(resourceName, contentType, localePrefix, (ResourceMeta)resourceMeta, resourceLoader, new ResourceCachedInfo(resource.getURL(), null));
                    break;
                }
            }
        }
        return resource;
    }

    public Stream<String> getViewResources(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        String localePrefix = this.getLocalePrefixForLocateResource(facesContext);
        List contracts = facesContext.getResourceLibraryContracts();
        String contractPreferred = this.getContractNameForLocateResource(facesContext);
        if (this._viewSuffixes == null) {
            this._viewSuffixes = this.loadSuffixes(facesContext.getExternalContext());
        }
        FilterInvalidSuffixViewResourceIterator it = new FilterInvalidSuffixViewResourceIterator(new ViewResourceIterator(facesContext, this.getResourceHandlerSupport(), localePrefix, contracts, contractPreferred, path, maxDepth, options), facesContext, this._viewSuffixes);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1), false);
    }

    private Set<String> loadSuffixes(ExternalContext context) {
        String faceletViewMappings;
        HashSet<String> result = new HashSet<String>();
        String definedSuffixes = WebConfigParamUtils.getStringInitParameter(context, "javax.faces.DEFAULT_SUFFIX", ".xhtml .view.xml .jsp");
        if (definedSuffixes == null) {
            definedSuffixes = ".xhtml .view.xml .jsp";
        }
        StringTokenizer tokenizer = new StringTokenizer(definedSuffixes, " ");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        String faceletSuffix = WebConfigParamUtils.getStringInitParameter(context, "javax.faces.FACELETS_SUFFIX", ".xhtml");
        if (faceletSuffix != null) {
            result.add(faceletSuffix.trim());
        }
        if ((faceletViewMappings = WebConfigParamUtils.getStringInitParameter(context, FACELETS_VIEW_MAPPINGS_PARAM)) != null) {
            tokenizer = new StringTokenizer(faceletViewMappings, ";");
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken());
            }
        }
        return result;
    }

    public boolean isResourceRendered(FacesContext facesContext, String resourceName, String libraryName) {
        return ResourceHandlerImpl.getRenderedResources(facesContext).containsKey(libraryName != null ? ResourceHandlerImpl.contactLibraryAndResource(facesContext, libraryName, resourceName) : resourceName);
    }

    public void markResourceRendered(FacesContext facesContext, String resourceName, String libraryName) {
        ResourceHandlerImpl.getRenderedResources(facesContext).put(libraryName != null ? ResourceHandlerImpl.contactLibraryAndResource(facesContext, libraryName, resourceName) : resourceName, Boolean.TRUE);
        if ("javax.faces".equals(libraryName) && "jsf.js".equals(resourceName)) {
            ResourceHandlerImpl.getRenderedResources(facesContext).put(ResourceHandlerImpl.contactLibraryAndResource(facesContext, MYFACES_LIBRARY_NAME, MYFACES_JS_RESOURCE_NAME), Boolean.TRUE);
        }
    }

    private static Map<String, Boolean> getRenderedResources(FacesContext facesContext) {
        HashMap map = (HashMap)facesContext.getViewRoot().getTransientStateHelper().getTransient((Object)RENDERED_RESOURCES_SET);
        if (map == null) {
            map = new HashMap();
            facesContext.getViewRoot().getTransientStateHelper().putTransient((Object)RENDERED_RESOURCES_SET, map);
        }
        return map;
    }

    private static String contactLibraryAndResource(FacesContext facesContext, String libraryName, String resourceName) {
        StringBuilder sb = SharedStringBuilder.get((FacesContext)facesContext, (String)SHARED_STRING_BUILDER, (int)40);
        return sb.append(libraryName).append('/').append(resourceName).toString();
    }

    private static class FilterInvalidSuffixViewResourceIterator
    extends SkipMatchIterator<String> {
        private FacesContext facesContext;
        private Set<String> validSuffixes;

        public FilterInvalidSuffixViewResourceIterator(Iterator<String> delegate, FacesContext facesContext, Set<String> validSuffixes) {
            super(delegate);
            this.facesContext = facesContext;
            this.validSuffixes = validSuffixes;
        }

        @Override
        protected boolean match(String value) {
            String viewId = value;
            ViewDeclarationLanguage vdl = this.facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(this.facesContext, viewId);
            if (vdl != null && vdl.viewExists(this.facesContext, viewId)) {
                boolean matchSuffix = false;
                for (String suffix : this.validSuffixes) {
                    if (suffix == null || suffix.length() <= 0 || !viewId.endsWith(suffix)) continue;
                    matchSuffix = true;
                    break;
                }
                return !matchSuffix;
            }
            return true;
        }
    }
}

