/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.Scheduler;
import com.ibm.ws.ffdc.FFDCFilter;

public abstract class RealTimeDaemon {
    private static TraceComponent tc = Tr.register(RealTimeDaemon.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    protected long timeInterval = 0L;
    protected long startDaemonTime = 0L;
    protected boolean stopDaemon = false;

    protected abstract void wakeUp(long var1, long var3);

    protected RealTimeDaemon(long timeInterval) {
        if (timeInterval <= 0L) {
            throw new IllegalArgumentException("timeInterval must be positive");
        }
        this.timeInterval = timeInterval;
    }

    public void start() {
        this.startDaemonTime = System.currentTimeMillis();
        this.stopDaemon = false;
        Scheduler.createNonDeferrable(this.timeInterval, this, new Runnable(){

            @Override
            public void run() {
                RealTimeDaemon.this.alarm(this);
            }
        });
    }

    public void stop() {
        this.stopDaemon = true;
    }

    public void alarm(final Object context) {
        long startWakeUpTime;
        long sleepInterval = 0L;
        do {
            startWakeUpTime = System.currentTimeMillis();
            try {
                this.wakeUp(this.startDaemonTime, startWakeUpTime);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.RealTimeDaemon.alarm", (String)"83", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"exception during wakeUp", (Object[])new Object[]{ex});
            }
        } while ((sleepInterval = this.timeInterval - (System.currentTimeMillis() - startWakeUpTime)) <= 0L);
        if (!this.stopDaemon) {
            Scheduler.createNonDeferrable(sleepInterval, context, new Runnable(){

                @Override
                public void run() {
                    RealTimeDaemon.this.alarm(context);
                }
            });
        }
    }
}

