/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.cache;

import com.ibm.websphere.cache.Cache;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class DynamicCacheAccessor {
    private static TraceComponent tc = Tr.register(DynamicCacheAccessor.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");

    public static Cache getCache() {
        if (DynamicCacheAccessor.isServletCachingEnabled()) {
            return ServerCache.cache;
        }
        return null;
    }

    public static boolean isCachingEnabled() {
        return ServerCache.servletCacheEnabled || ServerCache.objectCacheEnabled;
    }

    public static boolean isServletCachingEnabled() {
        return ServerCache.servletCacheEnabled;
    }

    public static boolean isObjectCachingEnabled() {
        return ServerCache.objectCacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistributedMap getDistributedMap() {
        String methodName = "getDistributedMap()";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDistributedMap()", (Object[])new Object[0]);
        }
        DistributedObjectCache distributedMap = null;
        InitialContext context = null;
        if (DynamicCacheAccessor.isObjectCachingEnabled()) {
            try {
                context = new InitialContext();
                distributedMap = (DistributedObjectCache)context.lookup("services/cache/basecache");
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.cache.DynamicCacheAccessor.getDistributedMap", (String)"99", DynamicCacheAccessor.class);
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (NamingException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.cache.DynamicCacheAccessor.getDistributedMap", (String)"110", DynamicCacheAccessor.class);
                }
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1060W", (Object[])new Object[]{"services/cache/basecache"});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDistributedMap()", (Object)distributedMap);
        }
        return distributedMap;
    }
}

