/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.cdi40.internal.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.internal.archive.liberty.ExtensionArchiveImpl;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.ExtensionArchive;
import com.ibm.ws.cdi.internal.interfaces.ExtensionArchiveFactory;
import com.ibm.ws.cdi.internal.interfaces.ExtensionArchiveProvider;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.cdi.spi.CDIExtensionMetadata;
import io.openliberty.cdi40.internal.extension.CDI40ExtensionMetadataInternal;
import io.openliberty.cdi40.internal.weld.LiteExtensionArchive;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.spi.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.LiteExtensionTranslator;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class CDI40ExtensionSPIProvider
implements ExtensionArchiveProvider,
ExtensionArchiveFactory {
    private static final TraceComponent tc = Tr.register(CDI40ExtensionSPIProvider.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    static final long serialVersionUID = 9160779013484459634L;

    public Collection<ExtensionArchive> getArchives(CDIRuntime cdiRuntime, WebSphereCDIDeployment deployment) throws CDIException {
        HashMap<ClassLoader, Set> extensions = new HashMap<ClassLoader, Set>();
        for (WebSphereBeanDeploymentArchive bda : deployment.getWebSphereBeanDeploymentArchives()) {
            for (String bceClassName : bda.getBuildCompatibleExtensionClassNames()) {
                Class<? extends BuildCompatibleExtension> bceClass = this.loadBuildCompatibleExtension(bceClassName, bda.getClassLoader());
                extensions.computeIfAbsent(bceClass.getClassLoader(), x -> new HashSet()).add(bceClass);
            }
        }
        ArrayList<ExtensionArchive> newArchives = new ArrayList<ExtensionArchive>();
        for (Map.Entry entry : extensions.entrySet()) {
            ClassLoader cl = (ClassLoader)entry.getKey();
            ArrayList<Class<? extends BuildCompatibleExtension>> classes = new ArrayList<Class<? extends BuildCompatibleExtension>>((Collection)entry.getValue());
            newArchives.add(new LiteExtensionArchive(cdiRuntime, cl, classes));
        }
        return newArchives;
    }

    public ExtensionArchive newSPIExtensionArchive(CDIRuntime cdiRuntime, ServiceReference<CDIExtensionMetadata> sr, CDIExtensionMetadata webSphereCDIExtensionMetaData, WebSphereCDIDeployment applicationContext) throws CDIException {
        ExtensionArchive newExtensionArchive = CDIUtils.newSPIExtensionArchive((CDIRuntime)cdiRuntime, sr, (CDIExtensionMetadata)webSphereCDIExtensionMetaData, (WebSphereCDIDeployment)applicationContext);
        Set buildCompatibleExtensionClasses = new HashSet();
        Set<Object> buildCompatibleExtensionsClassNames = new HashSet();
        if (webSphereCDIExtensionMetaData instanceof CDI40ExtensionMetadataInternal) {
            CDI40ExtensionMetadataInternal internalExtension = (CDI40ExtensionMetadataInternal)webSphereCDIExtensionMetaData;
            buildCompatibleExtensionClasses = internalExtension.getBuildCompatibleExtensions();
            buildCompatibleExtensionsClassNames = buildCompatibleExtensionClasses.stream().map(clazz -> clazz.getCanonicalName()).collect(Collectors.toSet());
        }
        if (!buildCompatibleExtensionClasses.isEmpty() && newExtensionArchive instanceof ExtensionArchiveImpl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"newSPIExtensionArchive", (Object[])new Object[]{"The previous extension is being ammended: The following classes will be registered as build compatible extensions: " + String.join((CharSequence)", ", buildCompatibleExtensionsClassNames)});
            }
            LiteExtensionTranslator translator = new LiteExtensionTranslator(new ArrayList(buildCompatibleExtensionClasses), webSphereCDIExtensionMetaData.getClass().getClassLoader());
            ExtensionArchiveImpl extensionArchiveImpl = (ExtensionArchiveImpl)newExtensionArchive;
            extensionArchiveImpl.addConstructedExtension((Extension)translator);
        }
        return newExtensionArchive;
    }

    /*
     * WARNING - void declaration
     */
    private Class<? extends BuildCompatibleExtension> loadBuildCompatibleExtension(String className, ClassLoader cl) throws CDIException {
        try {
            Class<?> clazz = cl.loadClass(className);
            return clazz.asSubclass(BuildCompatibleExtension.class);
        }
        catch (ClassNotFoundException clazz) {
            void e;
            FFDCFilter.processException((Throwable)clazz, (String)"io.openliberty.cdi40.internal.weld.CDI40ExtensionSPIProvider", (String)"126", (Object)this, (Object[])new Object[]{className, cl});
            Tr.error((TraceComponent)tc, (String)"bce.not.loadable.CWOWB1013E", (Object[])new Object[]{className});
            throw new CDIException(Tr.formatMessage((TraceComponent)tc, (String)"bce.not.loadable.CWOWB1013E", (Object[])new Object[]{className}), (Throwable)e);
        }
        catch (ClassCastException e) {
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.cdi40.internal.weld.CDI40ExtensionSPIProvider", (String)"129", (Object)this, (Object[])new Object[]{className, cl});
            Tr.error((TraceComponent)tc, (String)"bce.does.not.implement.bce.CWOWB1014E", (Object[])new Object[]{className});
            throw new CDIException(Tr.formatMessage((TraceComponent)tc, (String)"bce.does.not.implement.bce.CWOWB1014E", (Object[])new Object[]{className}), (Throwable)e);
        }
    }
}

